package pl.topteam.arisco.dom.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.arisco.dom.model.KaRodzina;
import pl.topteam.arisco.dom.model_gen.KaRodzinaCriteria.Criteria;
import pl.topteam.arisco.dom.model_gen.KaRodzinaCriteria.Criterion;
import pl.topteam.arisco.dom.model.KaRodzinaCriteria;

public class KaRodzinaSqlProvider {

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String countByExample(KaRodzinaCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("KA_RODZINA");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(KaRodzinaCriteria example) {
        BEGIN();
        DELETE_FROM("KA_RODZINA");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(KaRodzina record) {
        BEGIN();
        INSERT_INTO("KA_RODZINA");
        
        if (record.getIdPrac() != null) {
            VALUES("ID_PRAC", "#{idPrac,jdbcType=INTEGER}");
        }
        
        if (record.getNip() != null) {
            VALUES("NIP", "#{nip,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzDok() != null) {
            VALUES("RODZ_DOK", "#{rodzDok,jdbcType=CHAR}");
        }
        
        if (record.getNazwisko() != null) {
            VALUES("NAZWISKO", "#{nazwisko,jdbcType=VARCHAR}");
        }
        
        if (record.getImiePierwsze() != null) {
            VALUES("IMIE_PIERWSZE", "#{imiePierwsze,jdbcType=VARCHAR}");
        }
        
        if (record.getKodPocztowy() != null) {
            VALUES("KOD_POCZTOWY", "#{kodPocztowy,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscowosc() != null) {
            VALUES("MIEJSCOWOSC", "#{miejscowosc,jdbcType=VARCHAR}");
        }
        
        if (record.getGmina() != null) {
            VALUES("GMINA", "#{gmina,jdbcType=VARCHAR}");
        }
        
        if (record.getUlica() != null) {
            VALUES("ULICA", "#{ulica,jdbcType=VARCHAR}");
        }
        
        if (record.getNrDomu() != null) {
            VALUES("NR_DOMU", "#{nrDomu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrLokalu() != null) {
            VALUES("NR_LOKALU", "#{nrLokalu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrTelefonu() != null) {
            VALUES("NR_TELEFONU", "#{nrTelefonu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrFaksu() != null) {
            VALUES("NR_FAKSU", "#{nrFaksu,jdbcType=VARCHAR}");
        }
        
        if (record.getOsoba() != null) {
            VALUES("OSOBA", "#{osoba,jdbcType=VARCHAR}");
        }
        
        if (record.getDataUrodzenia() != null) {
            VALUES("DATA_URODZENIA", "#{dataUrodzenia,jdbcType=TIMESTAMP}");
        }
        
        if (record.getAdresNiezgodny() != null) {
            VALUES("ADRES_NIEZGODNY", "#{adresNiezgodny,jdbcType=CHAR}");
        }
        
        if (record.getPoprawil() != null) {
            VALUES("POPRAWIL", "#{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            VALUES("UTWORZYL", "#{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscePr() != null) {
            VALUES("MIEJSCE_PR", "#{miejscePr,jdbcType=VARCHAR}");
        }
        
        if (record.getTelefonPr() != null) {
            VALUES("TELEFON_PR", "#{telefonPr,jdbcType=VARCHAR}");
        }
        
        if (record.getRelacja() != null) {
            VALUES("RELACJA", "#{relacja,jdbcType=INTEGER}");
        }
        
        if (record.getWyksztalcenie() != null) {
            VALUES("WYKSZTALCENIE", "#{wyksztalcenie,jdbcType=INTEGER}");
        }
        
        if (record.getPlatnik() != null) {
            VALUES("PLATNIK", "#{platnik,jdbcType=CHAR}");
        }
        
        if (record.getOsKontaktu() != null) {
            VALUES("OS_KONTAKTU", "#{osKontaktu,jdbcType=CHAR}");
        }
        
        if (record.getRodzina() != null) {
            VALUES("RODZINA", "#{rodzina,jdbcType=CHAR}");
        }
        
        if (record.getTyp() != null) {
            VALUES("TYP", "#{typ,jdbcType=VARCHAR}");
        }
        
        if (record.getOpiekPraw() != null) {
            VALUES("OPIEK_PRAW", "#{opiekPraw,jdbcType=CHAR}");
        }
        
        if (record.getZmiana() != null) {
            VALUES("ZMIANA", "#{zmiana,jdbcType=TIMESTAMP}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(KaRodzinaCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("IDUNIK");
        } else {
            SELECT("IDUNIK");
        }
        SELECT("ID_PRAC");
        SELECT("NIP");
        SELECT("RODZ_DOK");
        SELECT("NAZWISKO");
        SELECT("IMIE_PIERWSZE");
        SELECT("KOD_POCZTOWY");
        SELECT("MIEJSCOWOSC");
        SELECT("GMINA");
        SELECT("ULICA");
        SELECT("NR_DOMU");
        SELECT("NR_LOKALU");
        SELECT("NR_TELEFONU");
        SELECT("NR_FAKSU");
        SELECT("OSOBA");
        SELECT("DATA_URODZENIA");
        SELECT("ADRES_NIEZGODNY");
        SELECT("POPRAWIL");
        SELECT("UTWORZYL");
        SELECT("MIEJSCE_PR");
        SELECT("TELEFON_PR");
        SELECT("RELACJA");
        SELECT("WYKSZTALCENIE");
        SELECT("PLATNIK");
        SELECT("OS_KONTAKTU");
        SELECT("RODZINA");
        SELECT("TYP");
        SELECT("OPIEK_PRAW");
        SELECT("ZMIANA");
        FROM("KA_RODZINA");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        KaRodzina record = (KaRodzina) parameter.get("record");
        KaRodzinaCriteria example = (KaRodzinaCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("KA_RODZINA");
        
        if (record.getIdunik() != null) {
            SET("IDUNIK = #{record.idunik,jdbcType=INTEGER}");
        }
        
        if (record.getIdPrac() != null) {
            SET("ID_PRAC = #{record.idPrac,jdbcType=INTEGER}");
        }
        
        if (record.getNip() != null) {
            SET("NIP = #{record.nip,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzDok() != null) {
            SET("RODZ_DOK = #{record.rodzDok,jdbcType=CHAR}");
        }
        
        if (record.getNazwisko() != null) {
            SET("NAZWISKO = #{record.nazwisko,jdbcType=VARCHAR}");
        }
        
        if (record.getImiePierwsze() != null) {
            SET("IMIE_PIERWSZE = #{record.imiePierwsze,jdbcType=VARCHAR}");
        }
        
        if (record.getKodPocztowy() != null) {
            SET("KOD_POCZTOWY = #{record.kodPocztowy,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscowosc() != null) {
            SET("MIEJSCOWOSC = #{record.miejscowosc,jdbcType=VARCHAR}");
        }
        
        if (record.getGmina() != null) {
            SET("GMINA = #{record.gmina,jdbcType=VARCHAR}");
        }
        
        if (record.getUlica() != null) {
            SET("ULICA = #{record.ulica,jdbcType=VARCHAR}");
        }
        
        if (record.getNrDomu() != null) {
            SET("NR_DOMU = #{record.nrDomu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrLokalu() != null) {
            SET("NR_LOKALU = #{record.nrLokalu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrTelefonu() != null) {
            SET("NR_TELEFONU = #{record.nrTelefonu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrFaksu() != null) {
            SET("NR_FAKSU = #{record.nrFaksu,jdbcType=VARCHAR}");
        }
        
        if (record.getOsoba() != null) {
            SET("OSOBA = #{record.osoba,jdbcType=VARCHAR}");
        }
        
        if (record.getDataUrodzenia() != null) {
            SET("DATA_URODZENIA = #{record.dataUrodzenia,jdbcType=TIMESTAMP}");
        }
        
        if (record.getAdresNiezgodny() != null) {
            SET("ADRES_NIEZGODNY = #{record.adresNiezgodny,jdbcType=CHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscePr() != null) {
            SET("MIEJSCE_PR = #{record.miejscePr,jdbcType=VARCHAR}");
        }
        
        if (record.getTelefonPr() != null) {
            SET("TELEFON_PR = #{record.telefonPr,jdbcType=VARCHAR}");
        }
        
        if (record.getRelacja() != null) {
            SET("RELACJA = #{record.relacja,jdbcType=INTEGER}");
        }
        
        if (record.getWyksztalcenie() != null) {
            SET("WYKSZTALCENIE = #{record.wyksztalcenie,jdbcType=INTEGER}");
        }
        
        if (record.getPlatnik() != null) {
            SET("PLATNIK = #{record.platnik,jdbcType=CHAR}");
        }
        
        if (record.getOsKontaktu() != null) {
            SET("OS_KONTAKTU = #{record.osKontaktu,jdbcType=CHAR}");
        }
        
        if (record.getRodzina() != null) {
            SET("RODZINA = #{record.rodzina,jdbcType=CHAR}");
        }
        
        if (record.getTyp() != null) {
            SET("TYP = #{record.typ,jdbcType=VARCHAR}");
        }
        
        if (record.getOpiekPraw() != null) {
            SET("OPIEK_PRAW = #{record.opiekPraw,jdbcType=CHAR}");
        }
        
        if (record.getZmiana() != null) {
            SET("ZMIANA = #{record.zmiana,jdbcType=TIMESTAMP}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("KA_RODZINA");
        
        SET("IDUNIK = #{record.idunik,jdbcType=INTEGER}");
        SET("ID_PRAC = #{record.idPrac,jdbcType=INTEGER}");
        SET("NIP = #{record.nip,jdbcType=VARCHAR}");
        SET("RODZ_DOK = #{record.rodzDok,jdbcType=CHAR}");
        SET("NAZWISKO = #{record.nazwisko,jdbcType=VARCHAR}");
        SET("IMIE_PIERWSZE = #{record.imiePierwsze,jdbcType=VARCHAR}");
        SET("KOD_POCZTOWY = #{record.kodPocztowy,jdbcType=VARCHAR}");
        SET("MIEJSCOWOSC = #{record.miejscowosc,jdbcType=VARCHAR}");
        SET("GMINA = #{record.gmina,jdbcType=VARCHAR}");
        SET("ULICA = #{record.ulica,jdbcType=VARCHAR}");
        SET("NR_DOMU = #{record.nrDomu,jdbcType=VARCHAR}");
        SET("NR_LOKALU = #{record.nrLokalu,jdbcType=VARCHAR}");
        SET("NR_TELEFONU = #{record.nrTelefonu,jdbcType=VARCHAR}");
        SET("NR_FAKSU = #{record.nrFaksu,jdbcType=VARCHAR}");
        SET("OSOBA = #{record.osoba,jdbcType=VARCHAR}");
        SET("DATA_URODZENIA = #{record.dataUrodzenia,jdbcType=TIMESTAMP}");
        SET("ADRES_NIEZGODNY = #{record.adresNiezgodny,jdbcType=CHAR}");
        SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        SET("MIEJSCE_PR = #{record.miejscePr,jdbcType=VARCHAR}");
        SET("TELEFON_PR = #{record.telefonPr,jdbcType=VARCHAR}");
        SET("RELACJA = #{record.relacja,jdbcType=INTEGER}");
        SET("WYKSZTALCENIE = #{record.wyksztalcenie,jdbcType=INTEGER}");
        SET("PLATNIK = #{record.platnik,jdbcType=CHAR}");
        SET("OS_KONTAKTU = #{record.osKontaktu,jdbcType=CHAR}");
        SET("RODZINA = #{record.rodzina,jdbcType=CHAR}");
        SET("TYP = #{record.typ,jdbcType=VARCHAR}");
        SET("OPIEK_PRAW = #{record.opiekPraw,jdbcType=CHAR}");
        SET("ZMIANA = #{record.zmiana,jdbcType=TIMESTAMP}");
        
        KaRodzinaCriteria example = (KaRodzinaCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByPrimaryKeySelective(KaRodzina record) {
        BEGIN();
        UPDATE("KA_RODZINA");
        
        if (record.getIdPrac() != null) {
            SET("ID_PRAC = #{idPrac,jdbcType=INTEGER}");
        }
        
        if (record.getNip() != null) {
            SET("NIP = #{nip,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzDok() != null) {
            SET("RODZ_DOK = #{rodzDok,jdbcType=CHAR}");
        }
        
        if (record.getNazwisko() != null) {
            SET("NAZWISKO = #{nazwisko,jdbcType=VARCHAR}");
        }
        
        if (record.getImiePierwsze() != null) {
            SET("IMIE_PIERWSZE = #{imiePierwsze,jdbcType=VARCHAR}");
        }
        
        if (record.getKodPocztowy() != null) {
            SET("KOD_POCZTOWY = #{kodPocztowy,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscowosc() != null) {
            SET("MIEJSCOWOSC = #{miejscowosc,jdbcType=VARCHAR}");
        }
        
        if (record.getGmina() != null) {
            SET("GMINA = #{gmina,jdbcType=VARCHAR}");
        }
        
        if (record.getUlica() != null) {
            SET("ULICA = #{ulica,jdbcType=VARCHAR}");
        }
        
        if (record.getNrDomu() != null) {
            SET("NR_DOMU = #{nrDomu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrLokalu() != null) {
            SET("NR_LOKALU = #{nrLokalu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrTelefonu() != null) {
            SET("NR_TELEFONU = #{nrTelefonu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrFaksu() != null) {
            SET("NR_FAKSU = #{nrFaksu,jdbcType=VARCHAR}");
        }
        
        if (record.getOsoba() != null) {
            SET("OSOBA = #{osoba,jdbcType=VARCHAR}");
        }
        
        if (record.getDataUrodzenia() != null) {
            SET("DATA_URODZENIA = #{dataUrodzenia,jdbcType=TIMESTAMP}");
        }
        
        if (record.getAdresNiezgodny() != null) {
            SET("ADRES_NIEZGODNY = #{adresNiezgodny,jdbcType=CHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscePr() != null) {
            SET("MIEJSCE_PR = #{miejscePr,jdbcType=VARCHAR}");
        }
        
        if (record.getTelefonPr() != null) {
            SET("TELEFON_PR = #{telefonPr,jdbcType=VARCHAR}");
        }
        
        if (record.getRelacja() != null) {
            SET("RELACJA = #{relacja,jdbcType=INTEGER}");
        }
        
        if (record.getWyksztalcenie() != null) {
            SET("WYKSZTALCENIE = #{wyksztalcenie,jdbcType=INTEGER}");
        }
        
        if (record.getPlatnik() != null) {
            SET("PLATNIK = #{platnik,jdbcType=CHAR}");
        }
        
        if (record.getOsKontaktu() != null) {
            SET("OS_KONTAKTU = #{osKontaktu,jdbcType=CHAR}");
        }
        
        if (record.getRodzina() != null) {
            SET("RODZINA = #{rodzina,jdbcType=CHAR}");
        }
        
        if (record.getTyp() != null) {
            SET("TYP = #{typ,jdbcType=VARCHAR}");
        }
        
        if (record.getOpiekPraw() != null) {
            SET("OPIEK_PRAW = #{opiekPraw,jdbcType=CHAR}");
        }
        
        if (record.getZmiana() != null) {
            SET("ZMIANA = #{zmiana,jdbcType=TIMESTAMP}");
        }
        
        WHERE("IDUNIK = #{idunik,jdbcType=INTEGER}");
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(KaRodzinaCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}