package pl.topteam.arisco.dom.dao_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.arisco.dom.model.MjDecyzje;
import pl.topteam.arisco.dom.model.MjDecyzjeCriteria;

public abstract interface MjDecyzjeMapper {
    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjDecyzjeSqlProvider.class, method="countByExample")
    int countByExample(MjDecyzjeCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @DeleteProvider(type=MjDecyzjeSqlProvider.class, method="deleteByExample")
    int deleteByExample(MjDecyzjeCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Delete({
        "delete from MJ_DECYZJE",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    int deleteByPrimaryKey(Integer id);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Insert({
        "insert into MJ_DECYZJE (ID_PLATNOSCI, OD_DNIA, ",
        "DO_DNIA, NAZWA, TYP, ",
        "SPOSOB, PODSTAWA, PROCENT, ",
        "KWOTA, POZYCJE, UTWORZYL, ",
        "POPRAWIL, POPRAWIL_DEC, ",
        "TERMIN_SWIAD)",
        "values (#{idPlatnosci,jdbcType=INTEGER}, #{odDnia,jdbcType=DATE}, ",
        "#{doDnia,jdbcType=DATE}, #{nazwa,jdbcType=VARCHAR}, #{typ,jdbcType=INTEGER}, ",
        "#{sposob,jdbcType=CHAR}, #{podstawa,jdbcType=NUMERIC}, #{procent,jdbcType=SMALLINT}, ",
        "#{kwota,jdbcType=NUMERIC}, #{pozycje,jdbcType=CHAR}, #{utworzyl,jdbcType=VARCHAR}, ",
        "#{poprawil,jdbcType=VARCHAR}, #{poprawilDec,jdbcType=CHAR}, ",
        "#{terminSwiad,jdbcType=INTEGER})"
    })
    @SelectKey(statement="_", keyProperty="id", before=false, resultType=Integer.class)
    int insert(MjDecyzje record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    int mergeInto(MjDecyzje record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @InsertProvider(type=MjDecyzjeSqlProvider.class, method="insertSelective")
    @SelectKey(statement="_", keyProperty="id", before=false, resultType=Integer.class)
    int insertSelective(MjDecyzje record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjDecyzjeSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_PLATNOSCI", property="idPlatnosci", jdbcType=JdbcType.INTEGER),
        @Result(column="OD_DNIA", property="odDnia", jdbcType=JdbcType.DATE),
        @Result(column="DO_DNIA", property="doDnia", jdbcType=JdbcType.DATE),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.INTEGER),
        @Result(column="SPOSOB", property="sposob", jdbcType=JdbcType.CHAR),
        @Result(column="PODSTAWA", property="podstawa", jdbcType=JdbcType.NUMERIC),
        @Result(column="PROCENT", property="procent", jdbcType=JdbcType.SMALLINT),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.NUMERIC),
        @Result(column="POZYCJE", property="pozycje", jdbcType=JdbcType.CHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL_DEC", property="poprawilDec", jdbcType=JdbcType.CHAR),
        @Result(column="TERMIN_SWIAD", property="terminSwiad", jdbcType=JdbcType.INTEGER)
    })
    List<MjDecyzje> selectByExampleWithRowbounds(MjDecyzjeCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjDecyzjeSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_PLATNOSCI", property="idPlatnosci", jdbcType=JdbcType.INTEGER),
        @Result(column="OD_DNIA", property="odDnia", jdbcType=JdbcType.DATE),
        @Result(column="DO_DNIA", property="doDnia", jdbcType=JdbcType.DATE),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.INTEGER),
        @Result(column="SPOSOB", property="sposob", jdbcType=JdbcType.CHAR),
        @Result(column="PODSTAWA", property="podstawa", jdbcType=JdbcType.NUMERIC),
        @Result(column="PROCENT", property="procent", jdbcType=JdbcType.SMALLINT),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.NUMERIC),
        @Result(column="POZYCJE", property="pozycje", jdbcType=JdbcType.CHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL_DEC", property="poprawilDec", jdbcType=JdbcType.CHAR),
        @Result(column="TERMIN_SWIAD", property="terminSwiad", jdbcType=JdbcType.INTEGER)
    })
    List<MjDecyzje> selectByExample(MjDecyzjeCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Select({
        "select",
        "ID, ID_PLATNOSCI, OD_DNIA, DO_DNIA, NAZWA, TYP, SPOSOB, PODSTAWA, PROCENT, KWOTA, ",
        "POZYCJE, UTWORZYL, POPRAWIL, POPRAWIL_DEC, TERMIN_SWIAD",
        "from MJ_DECYZJE",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_PLATNOSCI", property="idPlatnosci", jdbcType=JdbcType.INTEGER),
        @Result(column="OD_DNIA", property="odDnia", jdbcType=JdbcType.DATE),
        @Result(column="DO_DNIA", property="doDnia", jdbcType=JdbcType.DATE),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.INTEGER),
        @Result(column="SPOSOB", property="sposob", jdbcType=JdbcType.CHAR),
        @Result(column="PODSTAWA", property="podstawa", jdbcType=JdbcType.NUMERIC),
        @Result(column="PROCENT", property="procent", jdbcType=JdbcType.SMALLINT),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.NUMERIC),
        @Result(column="POZYCJE", property="pozycje", jdbcType=JdbcType.CHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL_DEC", property="poprawilDec", jdbcType=JdbcType.CHAR),
        @Result(column="TERMIN_SWIAD", property="terminSwiad", jdbcType=JdbcType.INTEGER)
    })
    MjDecyzje selectByPrimaryKey(Integer id);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjDecyzjeSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") MjDecyzje record, @Param("example") MjDecyzjeCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjDecyzjeSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") MjDecyzje record, @Param("example") MjDecyzjeCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjDecyzjeSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(MjDecyzje record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Update({
        "update MJ_DECYZJE",
        "set ID_PLATNOSCI = #{idPlatnosci,jdbcType=INTEGER},",
          "OD_DNIA = #{odDnia,jdbcType=DATE},",
          "DO_DNIA = #{doDnia,jdbcType=DATE},",
          "NAZWA = #{nazwa,jdbcType=VARCHAR},",
          "TYP = #{typ,jdbcType=INTEGER},",
          "SPOSOB = #{sposob,jdbcType=CHAR},",
          "PODSTAWA = #{podstawa,jdbcType=NUMERIC},",
          "PROCENT = #{procent,jdbcType=SMALLINT},",
          "KWOTA = #{kwota,jdbcType=NUMERIC},",
          "POZYCJE = #{pozycje,jdbcType=CHAR},",
          "UTWORZYL = #{utworzyl,jdbcType=VARCHAR},",
          "POPRAWIL = #{poprawil,jdbcType=VARCHAR},",
          "POPRAWIL_DEC = #{poprawilDec,jdbcType=CHAR},",
          "TERMIN_SWIAD = #{terminSwiad,jdbcType=INTEGER}",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    int updateByPrimaryKey(MjDecyzje record);
}