package pl.topteam.arisco.dom.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.arisco.dom.model.MjDecyzje;
import pl.topteam.arisco.dom.model_gen.MjDecyzjeCriteria.Criteria;
import pl.topteam.arisco.dom.model_gen.MjDecyzjeCriteria.Criterion;
import pl.topteam.arisco.dom.model.MjDecyzjeCriteria;

public class MjDecyzjeSqlProvider {

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String countByExample(MjDecyzjeCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("MJ_DECYZJE");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(MjDecyzjeCriteria example) {
        BEGIN();
        DELETE_FROM("MJ_DECYZJE");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(MjDecyzje record) {
        BEGIN();
        INSERT_INTO("MJ_DECYZJE");
        
        if (record.getIdPlatnosci() != null) {
            VALUES("ID_PLATNOSCI", "#{idPlatnosci,jdbcType=INTEGER}");
        }
        
        if (record.getOdDnia() != null) {
            VALUES("OD_DNIA", "#{odDnia,jdbcType=DATE}");
        }
        
        if (record.getDoDnia() != null) {
            VALUES("DO_DNIA", "#{doDnia,jdbcType=DATE}");
        }
        
        if (record.getNazwa() != null) {
            VALUES("NAZWA", "#{nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getTyp() != null) {
            VALUES("TYP", "#{typ,jdbcType=INTEGER}");
        }
        
        if (record.getSposob() != null) {
            VALUES("SPOSOB", "#{sposob,jdbcType=CHAR}");
        }
        
        if (record.getPodstawa() != null) {
            VALUES("PODSTAWA", "#{podstawa,jdbcType=NUMERIC}");
        }
        
        if (record.getProcent() != null) {
            VALUES("PROCENT", "#{procent,jdbcType=SMALLINT}");
        }
        
        if (record.getKwota() != null) {
            VALUES("KWOTA", "#{kwota,jdbcType=NUMERIC}");
        }
        
        if (record.getPozycje() != null) {
            VALUES("POZYCJE", "#{pozycje,jdbcType=CHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            VALUES("UTWORZYL", "#{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            VALUES("POPRAWIL", "#{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawilDec() != null) {
            VALUES("POPRAWIL_DEC", "#{poprawilDec,jdbcType=CHAR}");
        }
        
        if (record.getTerminSwiad() != null) {
            VALUES("TERMIN_SWIAD", "#{terminSwiad,jdbcType=INTEGER}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(MjDecyzjeCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("ID");
        } else {
            SELECT("ID");
        }
        SELECT("ID_PLATNOSCI");
        SELECT("OD_DNIA");
        SELECT("DO_DNIA");
        SELECT("NAZWA");
        SELECT("TYP");
        SELECT("SPOSOB");
        SELECT("PODSTAWA");
        SELECT("PROCENT");
        SELECT("KWOTA");
        SELECT("POZYCJE");
        SELECT("UTWORZYL");
        SELECT("POPRAWIL");
        SELECT("POPRAWIL_DEC");
        SELECT("TERMIN_SWIAD");
        FROM("MJ_DECYZJE");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        MjDecyzje record = (MjDecyzje) parameter.get("record");
        MjDecyzjeCriteria example = (MjDecyzjeCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("MJ_DECYZJE");
        
        if (record.getId() != null) {
            SET("ID = #{record.id,jdbcType=INTEGER}");
        }
        
        if (record.getIdPlatnosci() != null) {
            SET("ID_PLATNOSCI = #{record.idPlatnosci,jdbcType=INTEGER}");
        }
        
        if (record.getOdDnia() != null) {
            SET("OD_DNIA = #{record.odDnia,jdbcType=DATE}");
        }
        
        if (record.getDoDnia() != null) {
            SET("DO_DNIA = #{record.doDnia,jdbcType=DATE}");
        }
        
        if (record.getNazwa() != null) {
            SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getTyp() != null) {
            SET("TYP = #{record.typ,jdbcType=INTEGER}");
        }
        
        if (record.getSposob() != null) {
            SET("SPOSOB = #{record.sposob,jdbcType=CHAR}");
        }
        
        if (record.getPodstawa() != null) {
            SET("PODSTAWA = #{record.podstawa,jdbcType=NUMERIC}");
        }
        
        if (record.getProcent() != null) {
            SET("PROCENT = #{record.procent,jdbcType=SMALLINT}");
        }
        
        if (record.getKwota() != null) {
            SET("KWOTA = #{record.kwota,jdbcType=NUMERIC}");
        }
        
        if (record.getPozycje() != null) {
            SET("POZYCJE = #{record.pozycje,jdbcType=CHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawilDec() != null) {
            SET("POPRAWIL_DEC = #{record.poprawilDec,jdbcType=CHAR}");
        }
        
        if (record.getTerminSwiad() != null) {
            SET("TERMIN_SWIAD = #{record.terminSwiad,jdbcType=INTEGER}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("MJ_DECYZJE");
        
        SET("ID = #{record.id,jdbcType=INTEGER}");
        SET("ID_PLATNOSCI = #{record.idPlatnosci,jdbcType=INTEGER}");
        SET("OD_DNIA = #{record.odDnia,jdbcType=DATE}");
        SET("DO_DNIA = #{record.doDnia,jdbcType=DATE}");
        SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        SET("TYP = #{record.typ,jdbcType=INTEGER}");
        SET("SPOSOB = #{record.sposob,jdbcType=CHAR}");
        SET("PODSTAWA = #{record.podstawa,jdbcType=NUMERIC}");
        SET("PROCENT = #{record.procent,jdbcType=SMALLINT}");
        SET("KWOTA = #{record.kwota,jdbcType=NUMERIC}");
        SET("POZYCJE = #{record.pozycje,jdbcType=CHAR}");
        SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        SET("POPRAWIL_DEC = #{record.poprawilDec,jdbcType=CHAR}");
        SET("TERMIN_SWIAD = #{record.terminSwiad,jdbcType=INTEGER}");
        
        MjDecyzjeCriteria example = (MjDecyzjeCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByPrimaryKeySelective(MjDecyzje record) {
        BEGIN();
        UPDATE("MJ_DECYZJE");
        
        if (record.getIdPlatnosci() != null) {
            SET("ID_PLATNOSCI = #{idPlatnosci,jdbcType=INTEGER}");
        }
        
        if (record.getOdDnia() != null) {
            SET("OD_DNIA = #{odDnia,jdbcType=DATE}");
        }
        
        if (record.getDoDnia() != null) {
            SET("DO_DNIA = #{doDnia,jdbcType=DATE}");
        }
        
        if (record.getNazwa() != null) {
            SET("NAZWA = #{nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getTyp() != null) {
            SET("TYP = #{typ,jdbcType=INTEGER}");
        }
        
        if (record.getSposob() != null) {
            SET("SPOSOB = #{sposob,jdbcType=CHAR}");
        }
        
        if (record.getPodstawa() != null) {
            SET("PODSTAWA = #{podstawa,jdbcType=NUMERIC}");
        }
        
        if (record.getProcent() != null) {
            SET("PROCENT = #{procent,jdbcType=SMALLINT}");
        }
        
        if (record.getKwota() != null) {
            SET("KWOTA = #{kwota,jdbcType=NUMERIC}");
        }
        
        if (record.getPozycje() != null) {
            SET("POZYCJE = #{pozycje,jdbcType=CHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawilDec() != null) {
            SET("POPRAWIL_DEC = #{poprawilDec,jdbcType=CHAR}");
        }
        
        if (record.getTerminSwiad() != null) {
            SET("TERMIN_SWIAD = #{terminSwiad,jdbcType=INTEGER}");
        }
        
        WHERE("ID = #{id,jdbcType=INTEGER}");
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(MjDecyzjeCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}