package pl.topteam.arisco.dom.dao_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.arisco.dom.model.MjDepozyty;
import pl.topteam.arisco.dom.model.MjDepozytyCriteria;

public abstract interface MjDepozytyMapper {
    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjDepozytySqlProvider.class, method="countByExample")
    int countByExample(MjDepozytyCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @DeleteProvider(type=MjDepozytySqlProvider.class, method="deleteByExample")
    int deleteByExample(MjDepozytyCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Delete({
        "delete from MJ_DEPOZYTY",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    int deleteByPrimaryKey(Integer id);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Insert({
        "insert into MJ_DEPOZYTY (ID_OSOBY, DATA, ",
        "KWOTA, RODZAJ, OPIS, ",
        "TYP_DOK, NR_DOK, UTWORZYL, ",
        "POPRAWIL)",
        "values (#{idOsoby,jdbcType=INTEGER}, #{data,jdbcType=DATE}, ",
        "#{kwota,jdbcType=NUMERIC}, #{rodzaj,jdbcType=VARCHAR}, #{opis,jdbcType=VARCHAR}, ",
        "#{typDok,jdbcType=INTEGER}, #{nrDok,jdbcType=VARCHAR}, #{utworzyl,jdbcType=VARCHAR}, ",
        "#{poprawil,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="_", keyProperty="id", before=false, resultType=Integer.class)
    int insert(MjDepozyty record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    int mergeInto(MjDepozyty record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @InsertProvider(type=MjDepozytySqlProvider.class, method="insertSelective")
    @SelectKey(statement="_", keyProperty="id", before=false, resultType=Integer.class)
    int insertSelective(MjDepozyty record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjDepozytySqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.NUMERIC),
        @Result(column="RODZAJ", property="rodzaj", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPIS", property="opis", jdbcType=JdbcType.VARCHAR),
        @Result(column="TYP_DOK", property="typDok", jdbcType=JdbcType.INTEGER),
        @Result(column="NR_DOK", property="nrDok", jdbcType=JdbcType.VARCHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR)
    })
    List<MjDepozyty> selectByExampleWithRowbounds(MjDepozytyCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjDepozytySqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.NUMERIC),
        @Result(column="RODZAJ", property="rodzaj", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPIS", property="opis", jdbcType=JdbcType.VARCHAR),
        @Result(column="TYP_DOK", property="typDok", jdbcType=JdbcType.INTEGER),
        @Result(column="NR_DOK", property="nrDok", jdbcType=JdbcType.VARCHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR)
    })
    List<MjDepozyty> selectByExample(MjDepozytyCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Select({
        "select",
        "ID, ID_OSOBY, DATA, KWOTA, RODZAJ, OPIS, TYP_DOK, NR_DOK, UTWORZYL, POPRAWIL",
        "from MJ_DEPOZYTY",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.NUMERIC),
        @Result(column="RODZAJ", property="rodzaj", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPIS", property="opis", jdbcType=JdbcType.VARCHAR),
        @Result(column="TYP_DOK", property="typDok", jdbcType=JdbcType.INTEGER),
        @Result(column="NR_DOK", property="nrDok", jdbcType=JdbcType.VARCHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR)
    })
    MjDepozyty selectByPrimaryKey(Integer id);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjDepozytySqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") MjDepozyty record, @Param("example") MjDepozytyCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjDepozytySqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") MjDepozyty record, @Param("example") MjDepozytyCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjDepozytySqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(MjDepozyty record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Update({
        "update MJ_DEPOZYTY",
        "set ID_OSOBY = #{idOsoby,jdbcType=INTEGER},",
          "DATA = #{data,jdbcType=DATE},",
          "KWOTA = #{kwota,jdbcType=NUMERIC},",
          "RODZAJ = #{rodzaj,jdbcType=VARCHAR},",
          "OPIS = #{opis,jdbcType=VARCHAR},",
          "TYP_DOK = #{typDok,jdbcType=INTEGER},",
          "NR_DOK = #{nrDok,jdbcType=VARCHAR},",
          "UTWORZYL = #{utworzyl,jdbcType=VARCHAR},",
          "POPRAWIL = #{poprawil,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    int updateByPrimaryKey(MjDepozyty record);
}