package pl.topteam.arisco.dom.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.arisco.dom.model.MjInterwolnem;
import pl.topteam.arisco.dom.model_gen.MjInterwolnemCriteria.Criteria;
import pl.topteam.arisco.dom.model_gen.MjInterwolnemCriteria.Criterion;
import pl.topteam.arisco.dom.model.MjInterwolnemCriteria;

public class MjInterwolnemSqlProvider {

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String countByExample(MjInterwolnemCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("MJ_INTERWOLNEM");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(MjInterwolnemCriteria example) {
        BEGIN();
        DELETE_FROM("MJ_INTERWOLNEM");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(MjInterwolnem record) {
        BEGIN();
        INSERT_INTO("MJ_INTERWOLNEM");
        
        if (record.getDataLokalna() != null) {
            VALUES("DATA_LOKALNA", "#{dataLokalna,jdbcType=DATE}");
        }
        
        if (record.getCalkIlM() != null) {
            VALUES("CALK_IL_M", "#{calkIlM,jdbcType=INTEGER}");
        }
        
        if (record.getAktualPrzeb() != null) {
            VALUES("AKTUAL_PRZEB", "#{aktualPrzeb,jdbcType=INTEGER}");
        }
        
        if (record.getWolneMiej() != null) {
            VALUES("WOLNE_MIEJ", "#{wolneMiej,jdbcType=INTEGER}");
        }
        
        if (record.getStatusOperacji() != null) {
            VALUES("STATUS_OPERACJI", "#{statusOperacji,jdbcType=CHAR}");
        }
        
        if (record.getIntData() != null) {
            VALUES("INT_DATA", "#{intData,jdbcType=VARCHAR}");
        }
        
        if (record.getIntStatus() != null) {
            VALUES("INT_STATUS", "#{intStatus,jdbcType=VARCHAR}");
        }
        
        if (record.getIntIdHist() != null) {
            VALUES("INT_ID_HIST", "#{intIdHist,jdbcType=VARCHAR}");
        }
        
        if (record.getIntNrKlient() != null) {
            VALUES("INT_NR_KLIENT", "#{intNrKlient,jdbcType=VARCHAR}");
        }
        
        if (record.getIntAktilm() != null) {
            VALUES("INT_AKTILM", "#{intAktilm,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            VALUES("UTWORZYL", "#{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getIntKodhtml() != null) {
            VALUES("INT_KODHTML", "#{intKodhtml,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejWylicz() != null) {
            VALUES("MIEJ_WYLICZ", "#{miejWylicz,jdbcType=INTEGER}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(MjInterwolnemCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("ID");
        } else {
            SELECT("ID");
        }
        SELECT("DATA_LOKALNA");
        SELECT("CALK_IL_M");
        SELECT("AKTUAL_PRZEB");
        SELECT("WOLNE_MIEJ");
        SELECT("STATUS_OPERACJI");
        SELECT("INT_DATA");
        SELECT("INT_STATUS");
        SELECT("INT_ID_HIST");
        SELECT("INT_NR_KLIENT");
        SELECT("INT_AKTILM");
        SELECT("UTWORZYL");
        SELECT("INT_KODHTML");
        SELECT("MIEJ_WYLICZ");
        FROM("MJ_INTERWOLNEM");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        MjInterwolnem record = (MjInterwolnem) parameter.get("record");
        MjInterwolnemCriteria example = (MjInterwolnemCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("MJ_INTERWOLNEM");
        
        if (record.getId() != null) {
            SET("ID = #{record.id,jdbcType=INTEGER}");
        }
        
        if (record.getDataLokalna() != null) {
            SET("DATA_LOKALNA = #{record.dataLokalna,jdbcType=DATE}");
        }
        
        if (record.getCalkIlM() != null) {
            SET("CALK_IL_M = #{record.calkIlM,jdbcType=INTEGER}");
        }
        
        if (record.getAktualPrzeb() != null) {
            SET("AKTUAL_PRZEB = #{record.aktualPrzeb,jdbcType=INTEGER}");
        }
        
        if (record.getWolneMiej() != null) {
            SET("WOLNE_MIEJ = #{record.wolneMiej,jdbcType=INTEGER}");
        }
        
        if (record.getStatusOperacji() != null) {
            SET("STATUS_OPERACJI = #{record.statusOperacji,jdbcType=CHAR}");
        }
        
        if (record.getIntData() != null) {
            SET("INT_DATA = #{record.intData,jdbcType=VARCHAR}");
        }
        
        if (record.getIntStatus() != null) {
            SET("INT_STATUS = #{record.intStatus,jdbcType=VARCHAR}");
        }
        
        if (record.getIntIdHist() != null) {
            SET("INT_ID_HIST = #{record.intIdHist,jdbcType=VARCHAR}");
        }
        
        if (record.getIntNrKlient() != null) {
            SET("INT_NR_KLIENT = #{record.intNrKlient,jdbcType=VARCHAR}");
        }
        
        if (record.getIntAktilm() != null) {
            SET("INT_AKTILM = #{record.intAktilm,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getIntKodhtml() != null) {
            SET("INT_KODHTML = #{record.intKodhtml,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejWylicz() != null) {
            SET("MIEJ_WYLICZ = #{record.miejWylicz,jdbcType=INTEGER}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("MJ_INTERWOLNEM");
        
        SET("ID = #{record.id,jdbcType=INTEGER}");
        SET("DATA_LOKALNA = #{record.dataLokalna,jdbcType=DATE}");
        SET("CALK_IL_M = #{record.calkIlM,jdbcType=INTEGER}");
        SET("AKTUAL_PRZEB = #{record.aktualPrzeb,jdbcType=INTEGER}");
        SET("WOLNE_MIEJ = #{record.wolneMiej,jdbcType=INTEGER}");
        SET("STATUS_OPERACJI = #{record.statusOperacji,jdbcType=CHAR}");
        SET("INT_DATA = #{record.intData,jdbcType=VARCHAR}");
        SET("INT_STATUS = #{record.intStatus,jdbcType=VARCHAR}");
        SET("INT_ID_HIST = #{record.intIdHist,jdbcType=VARCHAR}");
        SET("INT_NR_KLIENT = #{record.intNrKlient,jdbcType=VARCHAR}");
        SET("INT_AKTILM = #{record.intAktilm,jdbcType=VARCHAR}");
        SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        SET("INT_KODHTML = #{record.intKodhtml,jdbcType=VARCHAR}");
        SET("MIEJ_WYLICZ = #{record.miejWylicz,jdbcType=INTEGER}");
        
        MjInterwolnemCriteria example = (MjInterwolnemCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByPrimaryKeySelective(MjInterwolnem record) {
        BEGIN();
        UPDATE("MJ_INTERWOLNEM");
        
        if (record.getDataLokalna() != null) {
            SET("DATA_LOKALNA = #{dataLokalna,jdbcType=DATE}");
        }
        
        if (record.getCalkIlM() != null) {
            SET("CALK_IL_M = #{calkIlM,jdbcType=INTEGER}");
        }
        
        if (record.getAktualPrzeb() != null) {
            SET("AKTUAL_PRZEB = #{aktualPrzeb,jdbcType=INTEGER}");
        }
        
        if (record.getWolneMiej() != null) {
            SET("WOLNE_MIEJ = #{wolneMiej,jdbcType=INTEGER}");
        }
        
        if (record.getStatusOperacji() != null) {
            SET("STATUS_OPERACJI = #{statusOperacji,jdbcType=CHAR}");
        }
        
        if (record.getIntData() != null) {
            SET("INT_DATA = #{intData,jdbcType=VARCHAR}");
        }
        
        if (record.getIntStatus() != null) {
            SET("INT_STATUS = #{intStatus,jdbcType=VARCHAR}");
        }
        
        if (record.getIntIdHist() != null) {
            SET("INT_ID_HIST = #{intIdHist,jdbcType=VARCHAR}");
        }
        
        if (record.getIntNrKlient() != null) {
            SET("INT_NR_KLIENT = #{intNrKlient,jdbcType=VARCHAR}");
        }
        
        if (record.getIntAktilm() != null) {
            SET("INT_AKTILM = #{intAktilm,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getIntKodhtml() != null) {
            SET("INT_KODHTML = #{intKodhtml,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejWylicz() != null) {
            SET("MIEJ_WYLICZ = #{miejWylicz,jdbcType=INTEGER}");
        }
        
        WHERE("ID = #{id,jdbcType=INTEGER}");
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(MjInterwolnemCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}