package pl.topteam.arisco.dom.dao_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.arisco.dom.model.MjMiesiace;
import pl.topteam.arisco.dom.model.MjMiesiaceCriteria;

public abstract interface MjMiesiaceMapper {
    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjMiesiaceSqlProvider.class, method="countByExample")
    int countByExample(MjMiesiaceCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @DeleteProvider(type=MjMiesiaceSqlProvider.class, method="deleteByExample")
    int deleteByExample(MjMiesiaceCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Delete({
        "delete from MJ_MIESIACE",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    int deleteByPrimaryKey(Integer id);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Insert({
        "insert into MJ_MIESIACE (ID_OSOBY, MIESIAC, ",
        "ROK, OBR_PRZYPISY, ",
        "OBR_ODPISY, OBR_WPLATY, ",
        "OBR_ZWROTY, UTWORZYL, ",
        "POPRAWIL)",
        "values (#{idOsoby,jdbcType=INTEGER}, #{miesiac,jdbcType=INTEGER}, ",
        "#{rok,jdbcType=INTEGER}, #{obrPrzypisy,jdbcType=NUMERIC}, ",
        "#{obrOdpisy,jdbcType=NUMERIC}, #{obrWplaty,jdbcType=NUMERIC}, ",
        "#{obrZwroty,jdbcType=NUMERIC}, #{utworzyl,jdbcType=VARCHAR}, ",
        "#{poprawil,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="_", keyProperty="id", before=false, resultType=Integer.class)
    int insert(MjMiesiace record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    int mergeInto(MjMiesiace record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @InsertProvider(type=MjMiesiaceSqlProvider.class, method="insertSelective")
    @SelectKey(statement="_", keyProperty="id", before=false, resultType=Integer.class)
    int insertSelective(MjMiesiace record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjMiesiaceSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="MIESIAC", property="miesiac", jdbcType=JdbcType.INTEGER),
        @Result(column="ROK", property="rok", jdbcType=JdbcType.INTEGER),
        @Result(column="OBR_PRZYPISY", property="obrPrzypisy", jdbcType=JdbcType.NUMERIC),
        @Result(column="OBR_ODPISY", property="obrOdpisy", jdbcType=JdbcType.NUMERIC),
        @Result(column="OBR_WPLATY", property="obrWplaty", jdbcType=JdbcType.NUMERIC),
        @Result(column="OBR_ZWROTY", property="obrZwroty", jdbcType=JdbcType.NUMERIC),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR)
    })
    List<MjMiesiace> selectByExampleWithRowbounds(MjMiesiaceCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjMiesiaceSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="MIESIAC", property="miesiac", jdbcType=JdbcType.INTEGER),
        @Result(column="ROK", property="rok", jdbcType=JdbcType.INTEGER),
        @Result(column="OBR_PRZYPISY", property="obrPrzypisy", jdbcType=JdbcType.NUMERIC),
        @Result(column="OBR_ODPISY", property="obrOdpisy", jdbcType=JdbcType.NUMERIC),
        @Result(column="OBR_WPLATY", property="obrWplaty", jdbcType=JdbcType.NUMERIC),
        @Result(column="OBR_ZWROTY", property="obrZwroty", jdbcType=JdbcType.NUMERIC),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR)
    })
    List<MjMiesiace> selectByExample(MjMiesiaceCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Select({
        "select",
        "ID, ID_OSOBY, MIESIAC, ROK, OBR_PRZYPISY, OBR_ODPISY, OBR_WPLATY, OBR_ZWROTY, ",
        "UTWORZYL, POPRAWIL",
        "from MJ_MIESIACE",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="MIESIAC", property="miesiac", jdbcType=JdbcType.INTEGER),
        @Result(column="ROK", property="rok", jdbcType=JdbcType.INTEGER),
        @Result(column="OBR_PRZYPISY", property="obrPrzypisy", jdbcType=JdbcType.NUMERIC),
        @Result(column="OBR_ODPISY", property="obrOdpisy", jdbcType=JdbcType.NUMERIC),
        @Result(column="OBR_WPLATY", property="obrWplaty", jdbcType=JdbcType.NUMERIC),
        @Result(column="OBR_ZWROTY", property="obrZwroty", jdbcType=JdbcType.NUMERIC),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR)
    })
    MjMiesiace selectByPrimaryKey(Integer id);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjMiesiaceSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") MjMiesiace record, @Param("example") MjMiesiaceCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjMiesiaceSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") MjMiesiace record, @Param("example") MjMiesiaceCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjMiesiaceSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(MjMiesiace record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Update({
        "update MJ_MIESIACE",
        "set ID_OSOBY = #{idOsoby,jdbcType=INTEGER},",
          "MIESIAC = #{miesiac,jdbcType=INTEGER},",
          "ROK = #{rok,jdbcType=INTEGER},",
          "OBR_PRZYPISY = #{obrPrzypisy,jdbcType=NUMERIC},",
          "OBR_ODPISY = #{obrOdpisy,jdbcType=NUMERIC},",
          "OBR_WPLATY = #{obrWplaty,jdbcType=NUMERIC},",
          "OBR_ZWROTY = #{obrZwroty,jdbcType=NUMERIC},",
          "UTWORZYL = #{utworzyl,jdbcType=VARCHAR},",
          "POPRAWIL = #{poprawil,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    int updateByPrimaryKey(MjMiesiace record);
}