package pl.topteam.arisco.dom.dao_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.arisco.dom.model.MjNieob;
import pl.topteam.arisco.dom.model.MjNieobCriteria;

public abstract interface MjNieobMapper {
    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjNieobSqlProvider.class, method="countByExample")
    int countByExample(MjNieobCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @DeleteProvider(type=MjNieobSqlProvider.class, method="deleteByExample")
    int deleteByExample(MjNieobCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Delete({
        "delete from MJ_NIEOB",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    int deleteByPrimaryKey(Integer id);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Insert({
        "insert into MJ_NIEOB (ID_OSOBY, DATA_OD, ",
        "DATA_DO, RODZ_NIEOB, ",
        "RODZ_SLOW, PLATNIK, ",
        "ODLICZANA, UTWORZYL, ",
        "POPRAWIL, DATA_STARA)",
        "values (#{idOsoby,jdbcType=INTEGER}, #{dataOd,jdbcType=DATE}, ",
        "#{dataDo,jdbcType=DATE}, #{rodzNieob,jdbcType=VARCHAR}, ",
        "#{rodzSlow,jdbcType=INTEGER}, #{platnik,jdbcType=INTEGER}, ",
        "#{odliczana,jdbcType=CHAR}, #{utworzyl,jdbcType=VARCHAR}, ",
        "#{poprawil,jdbcType=VARCHAR}, #{dataStara,jdbcType=DATE})"
    })
    @SelectKey(statement="_", keyProperty="id", before=false, resultType=Integer.class)
    int insert(MjNieob record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    int mergeInto(MjNieob record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @InsertProvider(type=MjNieobSqlProvider.class, method="insertSelective")
    @SelectKey(statement="_", keyProperty="id", before=false, resultType=Integer.class)
    int insertSelective(MjNieob record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjNieobSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="RODZ_NIEOB", property="rodzNieob", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZ_SLOW", property="rodzSlow", jdbcType=JdbcType.INTEGER),
        @Result(column="PLATNIK", property="platnik", jdbcType=JdbcType.INTEGER),
        @Result(column="ODLICZANA", property="odliczana", jdbcType=JdbcType.CHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR),
        @Result(column="DATA_STARA", property="dataStara", jdbcType=JdbcType.DATE)
    })
    List<MjNieob> selectByExampleWithRowbounds(MjNieobCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjNieobSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="RODZ_NIEOB", property="rodzNieob", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZ_SLOW", property="rodzSlow", jdbcType=JdbcType.INTEGER),
        @Result(column="PLATNIK", property="platnik", jdbcType=JdbcType.INTEGER),
        @Result(column="ODLICZANA", property="odliczana", jdbcType=JdbcType.CHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR),
        @Result(column="DATA_STARA", property="dataStara", jdbcType=JdbcType.DATE)
    })
    List<MjNieob> selectByExample(MjNieobCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Select({
        "select",
        "ID, ID_OSOBY, DATA_OD, DATA_DO, RODZ_NIEOB, RODZ_SLOW, PLATNIK, ODLICZANA, UTWORZYL, ",
        "POPRAWIL, DATA_STARA",
        "from MJ_NIEOB",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="RODZ_NIEOB", property="rodzNieob", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZ_SLOW", property="rodzSlow", jdbcType=JdbcType.INTEGER),
        @Result(column="PLATNIK", property="platnik", jdbcType=JdbcType.INTEGER),
        @Result(column="ODLICZANA", property="odliczana", jdbcType=JdbcType.CHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR),
        @Result(column="DATA_STARA", property="dataStara", jdbcType=JdbcType.DATE)
    })
    MjNieob selectByPrimaryKey(Integer id);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjNieobSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") MjNieob record, @Param("example") MjNieobCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjNieobSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") MjNieob record, @Param("example") MjNieobCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjNieobSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(MjNieob record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Update({
        "update MJ_NIEOB",
        "set ID_OSOBY = #{idOsoby,jdbcType=INTEGER},",
          "DATA_OD = #{dataOd,jdbcType=DATE},",
          "DATA_DO = #{dataDo,jdbcType=DATE},",
          "RODZ_NIEOB = #{rodzNieob,jdbcType=VARCHAR},",
          "RODZ_SLOW = #{rodzSlow,jdbcType=INTEGER},",
          "PLATNIK = #{platnik,jdbcType=INTEGER},",
          "ODLICZANA = #{odliczana,jdbcType=CHAR},",
          "UTWORZYL = #{utworzyl,jdbcType=VARCHAR},",
          "POPRAWIL = #{poprawil,jdbcType=VARCHAR},",
          "DATA_STARA = #{dataStara,jdbcType=DATE}",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    int updateByPrimaryKey(MjNieob record);
}