package pl.topteam.arisco.dom.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.arisco.dom.model.MjOdsetkiDet;
import pl.topteam.arisco.dom.model_gen.MjOdsetkiDetCriteria.Criteria;
import pl.topteam.arisco.dom.model_gen.MjOdsetkiDetCriteria.Criterion;
import pl.topteam.arisco.dom.model.MjOdsetkiDetCriteria;

public class MjOdsetkiDetSqlProvider {

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String countByExample(MjOdsetkiDetCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("MJ_ODSETKI_DET");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(MjOdsetkiDetCriteria example) {
        BEGIN();
        DELETE_FROM("MJ_ODSETKI_DET");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(MjOdsetkiDet record) {
        BEGIN();
        INSERT_INTO("MJ_ODSETKI_DET");
        
        if (record.getIdMas() != null) {
            VALUES("ID_MAS", "#{idMas,jdbcType=INTEGER}");
        }
        
        if (record.getIdOsoby() != null) {
            VALUES("ID_OSOBY", "#{idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getOdsetMat() != null) {
            VALUES("ODSET_MAT", "#{odsetMat,jdbcType=NUMERIC}");
        }
        
        if (record.getOdsetRoz() != null) {
            VALUES("ODSET_ROZ", "#{odsetRoz,jdbcType=NUMERIC}");
        }
        
        if (record.getOdsetSum() != null) {
            VALUES("ODSET_SUM", "#{odsetSum,jdbcType=NUMERIC}");
        }
        
        if (record.getPerson() != null) {
            VALUES("PERSON", "#{person,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            VALUES("UTWORZYL", "#{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            VALUES("POPRAWIL", "#{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getPodstawZaok() != null) {
            VALUES("PODSTAW_ZAOK", "#{podstawZaok,jdbcType=NUMERIC}");
        }
        
        if (record.getPodat() != null) {
            VALUES("PODAT", "#{podat,jdbcType=NUMERIC}");
        }
        
        if (record.getPodatZaok() != null) {
            VALUES("PODAT_ZAOK", "#{podatZaok,jdbcType=NUMERIC}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(MjOdsetkiDetCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("ID");
        } else {
            SELECT("ID");
        }
        SELECT("ID_MAS");
        SELECT("ID_OSOBY");
        SELECT("ODSET_MAT");
        SELECT("ODSET_ROZ");
        SELECT("ODSET_SUM");
        SELECT("PERSON");
        SELECT("UTWORZYL");
        SELECT("POPRAWIL");
        SELECT("PODSTAW_ZAOK");
        SELECT("PODAT");
        SELECT("PODAT_ZAOK");
        FROM("MJ_ODSETKI_DET");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        MjOdsetkiDet record = (MjOdsetkiDet) parameter.get("record");
        MjOdsetkiDetCriteria example = (MjOdsetkiDetCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("MJ_ODSETKI_DET");
        
        if (record.getId() != null) {
            SET("ID = #{record.id,jdbcType=INTEGER}");
        }
        
        if (record.getIdMas() != null) {
            SET("ID_MAS = #{record.idMas,jdbcType=INTEGER}");
        }
        
        if (record.getIdOsoby() != null) {
            SET("ID_OSOBY = #{record.idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getOdsetMat() != null) {
            SET("ODSET_MAT = #{record.odsetMat,jdbcType=NUMERIC}");
        }
        
        if (record.getOdsetRoz() != null) {
            SET("ODSET_ROZ = #{record.odsetRoz,jdbcType=NUMERIC}");
        }
        
        if (record.getOdsetSum() != null) {
            SET("ODSET_SUM = #{record.odsetSum,jdbcType=NUMERIC}");
        }
        
        if (record.getPerson() != null) {
            SET("PERSON = #{record.person,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getPodstawZaok() != null) {
            SET("PODSTAW_ZAOK = #{record.podstawZaok,jdbcType=NUMERIC}");
        }
        
        if (record.getPodat() != null) {
            SET("PODAT = #{record.podat,jdbcType=NUMERIC}");
        }
        
        if (record.getPodatZaok() != null) {
            SET("PODAT_ZAOK = #{record.podatZaok,jdbcType=NUMERIC}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("MJ_ODSETKI_DET");
        
        SET("ID = #{record.id,jdbcType=INTEGER}");
        SET("ID_MAS = #{record.idMas,jdbcType=INTEGER}");
        SET("ID_OSOBY = #{record.idOsoby,jdbcType=INTEGER}");
        SET("ODSET_MAT = #{record.odsetMat,jdbcType=NUMERIC}");
        SET("ODSET_ROZ = #{record.odsetRoz,jdbcType=NUMERIC}");
        SET("ODSET_SUM = #{record.odsetSum,jdbcType=NUMERIC}");
        SET("PERSON = #{record.person,jdbcType=VARCHAR}");
        SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        SET("PODSTAW_ZAOK = #{record.podstawZaok,jdbcType=NUMERIC}");
        SET("PODAT = #{record.podat,jdbcType=NUMERIC}");
        SET("PODAT_ZAOK = #{record.podatZaok,jdbcType=NUMERIC}");
        
        MjOdsetkiDetCriteria example = (MjOdsetkiDetCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByPrimaryKeySelective(MjOdsetkiDet record) {
        BEGIN();
        UPDATE("MJ_ODSETKI_DET");
        
        if (record.getIdMas() != null) {
            SET("ID_MAS = #{idMas,jdbcType=INTEGER}");
        }
        
        if (record.getIdOsoby() != null) {
            SET("ID_OSOBY = #{idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getOdsetMat() != null) {
            SET("ODSET_MAT = #{odsetMat,jdbcType=NUMERIC}");
        }
        
        if (record.getOdsetRoz() != null) {
            SET("ODSET_ROZ = #{odsetRoz,jdbcType=NUMERIC}");
        }
        
        if (record.getOdsetSum() != null) {
            SET("ODSET_SUM = #{odsetSum,jdbcType=NUMERIC}");
        }
        
        if (record.getPerson() != null) {
            SET("PERSON = #{person,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getPodstawZaok() != null) {
            SET("PODSTAW_ZAOK = #{podstawZaok,jdbcType=NUMERIC}");
        }
        
        if (record.getPodat() != null) {
            SET("PODAT = #{podat,jdbcType=NUMERIC}");
        }
        
        if (record.getPodatZaok() != null) {
            SET("PODAT_ZAOK = #{podatZaok,jdbcType=NUMERIC}");
        }
        
        WHERE("ID = #{id,jdbcType=INTEGER}");
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(MjOdsetkiDetCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}