package pl.topteam.arisco.dom.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.arisco.dom.model.MjOdsetkiMas;
import pl.topteam.arisco.dom.model_gen.MjOdsetkiMasCriteria.Criteria;
import pl.topteam.arisco.dom.model_gen.MjOdsetkiMasCriteria.Criterion;
import pl.topteam.arisco.dom.model.MjOdsetkiMasCriteria;

public class MjOdsetkiMasSqlProvider {

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String countByExample(MjOdsetkiMasCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("MJ_ODSETKI_MAS");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(MjOdsetkiMasCriteria example) {
        BEGIN();
        DELETE_FROM("MJ_ODSETKI_MAS");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(MjOdsetkiMas record) {
        BEGIN();
        INSERT_INTO("MJ_ODSETKI_MAS");
        
        if (record.getDataWyl() != null) {
            VALUES("DATA_WYL", "#{dataWyl,jdbcType=DATE}");
        }
        
        if (record.getOdDnia() != null) {
            VALUES("OD_DNIA", "#{odDnia,jdbcType=DATE}");
        }
        
        if (record.getDoDnia() != null) {
            VALUES("DO_DNIA", "#{doDnia,jdbcType=DATE}");
        }
        
        if (record.getOdsetBanku() != null) {
            VALUES("ODSET_BANKU", "#{odsetBanku,jdbcType=NUMERIC}");
        }
        
        if (record.getWylicz() != null) {
            VALUES("WYLICZ", "#{wylicz,jdbcType=CHAR}");
        }
        
        if (record.getZpis() != null) {
            VALUES("ZPIS", "#{zpis,jdbcType=CHAR}");
        }
        
        if (record.getTypDok() != null) {
            VALUES("TYP_DOK", "#{typDok,jdbcType=INTEGER}");
        }
        
        if (record.getNrDok() != null) {
            VALUES("NR_DOK", "#{nrDok,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            VALUES("UTWORZYL", "#{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            VALUES("POPRAWIL", "#{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getPodatNalicz() != null) {
            VALUES("PODAT_NALICZ", "#{podatNalicz,jdbcType=CHAR}");
        }
        
        if (record.getPodatProcent() != null) {
            VALUES("PODAT_PROCENT", "#{podatProcent,jdbcType=INTEGER}");
        }
        
        if (record.getPodatZaokpodstaw() != null) {
            VALUES("PODAT_ZAOKPODSTAW", "#{podatZaokpodstaw,jdbcType=CHAR}");
        }
        
        if (record.getPodatZaokpodat() != null) {
            VALUES("PODAT_ZAOKPODAT", "#{podatZaokpodat,jdbcType=CHAR}");
        }
        
        if (record.getOdsetkiProwizje() != null) {
            VALUES("ODSETKI_PROWIZJE", "#{odsetkiProwizje,jdbcType=CHAR}");
        }
        
        if (record.getDataPodatku() != null) {
            VALUES("DATA_PODATKU", "#{dataPodatku,jdbcType=DATE}");
        }
        
        if (record.getInnaDataPod() != null) {
            VALUES("INNA_DATA_POD", "#{innaDataPod,jdbcType=CHAR}");
        }
        
        if (record.getZaokrpodns() != null) {
            VALUES("ZAOKRPODNS", "#{zaokrpodns,jdbcType=CHAR}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(MjOdsetkiMasCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("ID");
        } else {
            SELECT("ID");
        }
        SELECT("DATA_WYL");
        SELECT("OD_DNIA");
        SELECT("DO_DNIA");
        SELECT("ODSET_BANKU");
        SELECT("WYLICZ");
        SELECT("ZPIS");
        SELECT("TYP_DOK");
        SELECT("NR_DOK");
        SELECT("UTWORZYL");
        SELECT("POPRAWIL");
        SELECT("PODAT_NALICZ");
        SELECT("PODAT_PROCENT");
        SELECT("PODAT_ZAOKPODSTAW");
        SELECT("PODAT_ZAOKPODAT");
        SELECT("ODSETKI_PROWIZJE");
        SELECT("DATA_PODATKU");
        SELECT("INNA_DATA_POD");
        SELECT("ZAOKRPODNS");
        FROM("MJ_ODSETKI_MAS");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        MjOdsetkiMas record = (MjOdsetkiMas) parameter.get("record");
        MjOdsetkiMasCriteria example = (MjOdsetkiMasCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("MJ_ODSETKI_MAS");
        
        if (record.getId() != null) {
            SET("ID = #{record.id,jdbcType=INTEGER}");
        }
        
        if (record.getDataWyl() != null) {
            SET("DATA_WYL = #{record.dataWyl,jdbcType=DATE}");
        }
        
        if (record.getOdDnia() != null) {
            SET("OD_DNIA = #{record.odDnia,jdbcType=DATE}");
        }
        
        if (record.getDoDnia() != null) {
            SET("DO_DNIA = #{record.doDnia,jdbcType=DATE}");
        }
        
        if (record.getOdsetBanku() != null) {
            SET("ODSET_BANKU = #{record.odsetBanku,jdbcType=NUMERIC}");
        }
        
        if (record.getWylicz() != null) {
            SET("WYLICZ = #{record.wylicz,jdbcType=CHAR}");
        }
        
        if (record.getZpis() != null) {
            SET("ZPIS = #{record.zpis,jdbcType=CHAR}");
        }
        
        if (record.getTypDok() != null) {
            SET("TYP_DOK = #{record.typDok,jdbcType=INTEGER}");
        }
        
        if (record.getNrDok() != null) {
            SET("NR_DOK = #{record.nrDok,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getPodatNalicz() != null) {
            SET("PODAT_NALICZ = #{record.podatNalicz,jdbcType=CHAR}");
        }
        
        if (record.getPodatProcent() != null) {
            SET("PODAT_PROCENT = #{record.podatProcent,jdbcType=INTEGER}");
        }
        
        if (record.getPodatZaokpodstaw() != null) {
            SET("PODAT_ZAOKPODSTAW = #{record.podatZaokpodstaw,jdbcType=CHAR}");
        }
        
        if (record.getPodatZaokpodat() != null) {
            SET("PODAT_ZAOKPODAT = #{record.podatZaokpodat,jdbcType=CHAR}");
        }
        
        if (record.getOdsetkiProwizje() != null) {
            SET("ODSETKI_PROWIZJE = #{record.odsetkiProwizje,jdbcType=CHAR}");
        }
        
        if (record.getDataPodatku() != null) {
            SET("DATA_PODATKU = #{record.dataPodatku,jdbcType=DATE}");
        }
        
        if (record.getInnaDataPod() != null) {
            SET("INNA_DATA_POD = #{record.innaDataPod,jdbcType=CHAR}");
        }
        
        if (record.getZaokrpodns() != null) {
            SET("ZAOKRPODNS = #{record.zaokrpodns,jdbcType=CHAR}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("MJ_ODSETKI_MAS");
        
        SET("ID = #{record.id,jdbcType=INTEGER}");
        SET("DATA_WYL = #{record.dataWyl,jdbcType=DATE}");
        SET("OD_DNIA = #{record.odDnia,jdbcType=DATE}");
        SET("DO_DNIA = #{record.doDnia,jdbcType=DATE}");
        SET("ODSET_BANKU = #{record.odsetBanku,jdbcType=NUMERIC}");
        SET("WYLICZ = #{record.wylicz,jdbcType=CHAR}");
        SET("ZPIS = #{record.zpis,jdbcType=CHAR}");
        SET("TYP_DOK = #{record.typDok,jdbcType=INTEGER}");
        SET("NR_DOK = #{record.nrDok,jdbcType=VARCHAR}");
        SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        SET("PODAT_NALICZ = #{record.podatNalicz,jdbcType=CHAR}");
        SET("PODAT_PROCENT = #{record.podatProcent,jdbcType=INTEGER}");
        SET("PODAT_ZAOKPODSTAW = #{record.podatZaokpodstaw,jdbcType=CHAR}");
        SET("PODAT_ZAOKPODAT = #{record.podatZaokpodat,jdbcType=CHAR}");
        SET("ODSETKI_PROWIZJE = #{record.odsetkiProwizje,jdbcType=CHAR}");
        SET("DATA_PODATKU = #{record.dataPodatku,jdbcType=DATE}");
        SET("INNA_DATA_POD = #{record.innaDataPod,jdbcType=CHAR}");
        SET("ZAOKRPODNS = #{record.zaokrpodns,jdbcType=CHAR}");
        
        MjOdsetkiMasCriteria example = (MjOdsetkiMasCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByPrimaryKeySelective(MjOdsetkiMas record) {
        BEGIN();
        UPDATE("MJ_ODSETKI_MAS");
        
        if (record.getDataWyl() != null) {
            SET("DATA_WYL = #{dataWyl,jdbcType=DATE}");
        }
        
        if (record.getOdDnia() != null) {
            SET("OD_DNIA = #{odDnia,jdbcType=DATE}");
        }
        
        if (record.getDoDnia() != null) {
            SET("DO_DNIA = #{doDnia,jdbcType=DATE}");
        }
        
        if (record.getOdsetBanku() != null) {
            SET("ODSET_BANKU = #{odsetBanku,jdbcType=NUMERIC}");
        }
        
        if (record.getWylicz() != null) {
            SET("WYLICZ = #{wylicz,jdbcType=CHAR}");
        }
        
        if (record.getZpis() != null) {
            SET("ZPIS = #{zpis,jdbcType=CHAR}");
        }
        
        if (record.getTypDok() != null) {
            SET("TYP_DOK = #{typDok,jdbcType=INTEGER}");
        }
        
        if (record.getNrDok() != null) {
            SET("NR_DOK = #{nrDok,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getPodatNalicz() != null) {
            SET("PODAT_NALICZ = #{podatNalicz,jdbcType=CHAR}");
        }
        
        if (record.getPodatProcent() != null) {
            SET("PODAT_PROCENT = #{podatProcent,jdbcType=INTEGER}");
        }
        
        if (record.getPodatZaokpodstaw() != null) {
            SET("PODAT_ZAOKPODSTAW = #{podatZaokpodstaw,jdbcType=CHAR}");
        }
        
        if (record.getPodatZaokpodat() != null) {
            SET("PODAT_ZAOKPODAT = #{podatZaokpodat,jdbcType=CHAR}");
        }
        
        if (record.getOdsetkiProwizje() != null) {
            SET("ODSETKI_PROWIZJE = #{odsetkiProwizje,jdbcType=CHAR}");
        }
        
        if (record.getDataPodatku() != null) {
            SET("DATA_PODATKU = #{dataPodatku,jdbcType=DATE}");
        }
        
        if (record.getInnaDataPod() != null) {
            SET("INNA_DATA_POD = #{innaDataPod,jdbcType=CHAR}");
        }
        
        if (record.getZaokrpodns() != null) {
            SET("ZAOKRPODNS = #{zaokrpodns,jdbcType=CHAR}");
        }
        
        WHERE("ID = #{id,jdbcType=INTEGER}");
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(MjOdsetkiMasCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}