package pl.topteam.arisco.dom.dao_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.arisco.dom.model.MjOkresy;
import pl.topteam.arisco.dom.model.MjOkresyCriteria;

public abstract interface MjOkresyMapper {
    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjOkresySqlProvider.class, method="countByExample")
    int countByExample(MjOkresyCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @DeleteProvider(type=MjOkresySqlProvider.class, method="deleteByExample")
    int deleteByExample(MjOkresyCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Delete({
        "delete from MJ_OKRESY",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    int deleteByPrimaryKey(Integer id);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Insert({
        "insert into MJ_OKRESY (ID_OSOBY, DATA_OD, ",
        "DATA_DO, OPIS, UWAGI_PRZYB, ",
        "UWAGI_WYB, RODZAJ_POBYTU, ",
        "RODZ_WYBYCIA, RODZ_PRZYBYCIA)",
        "values (#{idOsoby,jdbcType=INTEGER}, #{dataOd,jdbcType=DATE}, ",
        "#{dataDo,jdbcType=DATE}, #{opis,jdbcType=VARCHAR}, #{uwagiPrzyb,jdbcType=VARCHAR}, ",
        "#{uwagiWyb,jdbcType=VARCHAR}, #{rodzajPobytu,jdbcType=INTEGER}, ",
        "#{rodzWybycia,jdbcType=INTEGER}, #{rodzPrzybycia,jdbcType=INTEGER})"
    })
    @SelectKey(statement="_", keyProperty="id", before=false, resultType=Integer.class)
    int insert(MjOkresy record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    int mergeInto(MjOkresy record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @InsertProvider(type=MjOkresySqlProvider.class, method="insertSelective")
    @SelectKey(statement="_", keyProperty="id", before=false, resultType=Integer.class)
    int insertSelective(MjOkresy record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjOkresySqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="OPIS", property="opis", jdbcType=JdbcType.VARCHAR),
        @Result(column="UWAGI_PRZYB", property="uwagiPrzyb", jdbcType=JdbcType.VARCHAR),
        @Result(column="UWAGI_WYB", property="uwagiWyb", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZAJ_POBYTU", property="rodzajPobytu", jdbcType=JdbcType.INTEGER),
        @Result(column="RODZ_WYBYCIA", property="rodzWybycia", jdbcType=JdbcType.INTEGER),
        @Result(column="RODZ_PRZYBYCIA", property="rodzPrzybycia", jdbcType=JdbcType.INTEGER)
    })
    List<MjOkresy> selectByExampleWithRowbounds(MjOkresyCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjOkresySqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="OPIS", property="opis", jdbcType=JdbcType.VARCHAR),
        @Result(column="UWAGI_PRZYB", property="uwagiPrzyb", jdbcType=JdbcType.VARCHAR),
        @Result(column="UWAGI_WYB", property="uwagiWyb", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZAJ_POBYTU", property="rodzajPobytu", jdbcType=JdbcType.INTEGER),
        @Result(column="RODZ_WYBYCIA", property="rodzWybycia", jdbcType=JdbcType.INTEGER),
        @Result(column="RODZ_PRZYBYCIA", property="rodzPrzybycia", jdbcType=JdbcType.INTEGER)
    })
    List<MjOkresy> selectByExample(MjOkresyCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Select({
        "select",
        "ID, ID_OSOBY, DATA_OD, DATA_DO, OPIS, UWAGI_PRZYB, UWAGI_WYB, RODZAJ_POBYTU, ",
        "RODZ_WYBYCIA, RODZ_PRZYBYCIA",
        "from MJ_OKRESY",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="OPIS", property="opis", jdbcType=JdbcType.VARCHAR),
        @Result(column="UWAGI_PRZYB", property="uwagiPrzyb", jdbcType=JdbcType.VARCHAR),
        @Result(column="UWAGI_WYB", property="uwagiWyb", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZAJ_POBYTU", property="rodzajPobytu", jdbcType=JdbcType.INTEGER),
        @Result(column="RODZ_WYBYCIA", property="rodzWybycia", jdbcType=JdbcType.INTEGER),
        @Result(column="RODZ_PRZYBYCIA", property="rodzPrzybycia", jdbcType=JdbcType.INTEGER)
    })
    MjOkresy selectByPrimaryKey(Integer id);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjOkresySqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") MjOkresy record, @Param("example") MjOkresyCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjOkresySqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") MjOkresy record, @Param("example") MjOkresyCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjOkresySqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(MjOkresy record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Update({
        "update MJ_OKRESY",
        "set ID_OSOBY = #{idOsoby,jdbcType=INTEGER},",
          "DATA_OD = #{dataOd,jdbcType=DATE},",
          "DATA_DO = #{dataDo,jdbcType=DATE},",
          "OPIS = #{opis,jdbcType=VARCHAR},",
          "UWAGI_PRZYB = #{uwagiPrzyb,jdbcType=VARCHAR},",
          "UWAGI_WYB = #{uwagiWyb,jdbcType=VARCHAR},",
          "RODZAJ_POBYTU = #{rodzajPobytu,jdbcType=INTEGER},",
          "RODZ_WYBYCIA = #{rodzWybycia,jdbcType=INTEGER},",
          "RODZ_PRZYBYCIA = #{rodzPrzybycia,jdbcType=INTEGER}",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    int updateByPrimaryKey(MjOkresy record);
}