package pl.topteam.arisco.dom.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.arisco.dom.model.MjOkresy;
import pl.topteam.arisco.dom.model_gen.MjOkresyCriteria.Criteria;
import pl.topteam.arisco.dom.model_gen.MjOkresyCriteria.Criterion;
import pl.topteam.arisco.dom.model.MjOkresyCriteria;

public class MjOkresySqlProvider {

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String countByExample(MjOkresyCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("MJ_OKRESY");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(MjOkresyCriteria example) {
        BEGIN();
        DELETE_FROM("MJ_OKRESY");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(MjOkresy record) {
        BEGIN();
        INSERT_INTO("MJ_OKRESY");
        
        if (record.getIdOsoby() != null) {
            VALUES("ID_OSOBY", "#{idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getDataOd() != null) {
            VALUES("DATA_OD", "#{dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            VALUES("DATA_DO", "#{dataDo,jdbcType=DATE}");
        }
        
        if (record.getOpis() != null) {
            VALUES("OPIS", "#{opis,jdbcType=VARCHAR}");
        }
        
        if (record.getUwagiPrzyb() != null) {
            VALUES("UWAGI_PRZYB", "#{uwagiPrzyb,jdbcType=VARCHAR}");
        }
        
        if (record.getUwagiWyb() != null) {
            VALUES("UWAGI_WYB", "#{uwagiWyb,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzajPobytu() != null) {
            VALUES("RODZAJ_POBYTU", "#{rodzajPobytu,jdbcType=INTEGER}");
        }
        
        if (record.getRodzWybycia() != null) {
            VALUES("RODZ_WYBYCIA", "#{rodzWybycia,jdbcType=INTEGER}");
        }
        
        if (record.getRodzPrzybycia() != null) {
            VALUES("RODZ_PRZYBYCIA", "#{rodzPrzybycia,jdbcType=INTEGER}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(MjOkresyCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("ID");
        } else {
            SELECT("ID");
        }
        SELECT("ID_OSOBY");
        SELECT("DATA_OD");
        SELECT("DATA_DO");
        SELECT("OPIS");
        SELECT("UWAGI_PRZYB");
        SELECT("UWAGI_WYB");
        SELECT("RODZAJ_POBYTU");
        SELECT("RODZ_WYBYCIA");
        SELECT("RODZ_PRZYBYCIA");
        FROM("MJ_OKRESY");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        MjOkresy record = (MjOkresy) parameter.get("record");
        MjOkresyCriteria example = (MjOkresyCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("MJ_OKRESY");
        
        if (record.getId() != null) {
            SET("ID = #{record.id,jdbcType=INTEGER}");
        }
        
        if (record.getIdOsoby() != null) {
            SET("ID_OSOBY = #{record.idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getDataOd() != null) {
            SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        }
        
        if (record.getOpis() != null) {
            SET("OPIS = #{record.opis,jdbcType=VARCHAR}");
        }
        
        if (record.getUwagiPrzyb() != null) {
            SET("UWAGI_PRZYB = #{record.uwagiPrzyb,jdbcType=VARCHAR}");
        }
        
        if (record.getUwagiWyb() != null) {
            SET("UWAGI_WYB = #{record.uwagiWyb,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzajPobytu() != null) {
            SET("RODZAJ_POBYTU = #{record.rodzajPobytu,jdbcType=INTEGER}");
        }
        
        if (record.getRodzWybycia() != null) {
            SET("RODZ_WYBYCIA = #{record.rodzWybycia,jdbcType=INTEGER}");
        }
        
        if (record.getRodzPrzybycia() != null) {
            SET("RODZ_PRZYBYCIA = #{record.rodzPrzybycia,jdbcType=INTEGER}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("MJ_OKRESY");
        
        SET("ID = #{record.id,jdbcType=INTEGER}");
        SET("ID_OSOBY = #{record.idOsoby,jdbcType=INTEGER}");
        SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        SET("OPIS = #{record.opis,jdbcType=VARCHAR}");
        SET("UWAGI_PRZYB = #{record.uwagiPrzyb,jdbcType=VARCHAR}");
        SET("UWAGI_WYB = #{record.uwagiWyb,jdbcType=VARCHAR}");
        SET("RODZAJ_POBYTU = #{record.rodzajPobytu,jdbcType=INTEGER}");
        SET("RODZ_WYBYCIA = #{record.rodzWybycia,jdbcType=INTEGER}");
        SET("RODZ_PRZYBYCIA = #{record.rodzPrzybycia,jdbcType=INTEGER}");
        
        MjOkresyCriteria example = (MjOkresyCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByPrimaryKeySelective(MjOkresy record) {
        BEGIN();
        UPDATE("MJ_OKRESY");
        
        if (record.getIdOsoby() != null) {
            SET("ID_OSOBY = #{idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getDataOd() != null) {
            SET("DATA_OD = #{dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            SET("DATA_DO = #{dataDo,jdbcType=DATE}");
        }
        
        if (record.getOpis() != null) {
            SET("OPIS = #{opis,jdbcType=VARCHAR}");
        }
        
        if (record.getUwagiPrzyb() != null) {
            SET("UWAGI_PRZYB = #{uwagiPrzyb,jdbcType=VARCHAR}");
        }
        
        if (record.getUwagiWyb() != null) {
            SET("UWAGI_WYB = #{uwagiWyb,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzajPobytu() != null) {
            SET("RODZAJ_POBYTU = #{rodzajPobytu,jdbcType=INTEGER}");
        }
        
        if (record.getRodzWybycia() != null) {
            SET("RODZ_WYBYCIA = #{rodzWybycia,jdbcType=INTEGER}");
        }
        
        if (record.getRodzPrzybycia() != null) {
            SET("RODZ_PRZYBYCIA = #{rodzPrzybycia,jdbcType=INTEGER}");
        }
        
        WHERE("ID = #{id,jdbcType=INTEGER}");
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(MjOkresyCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}