package pl.topteam.arisco.dom.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.arisco.dom.model.MjOrzpzoniep;
import pl.topteam.arisco.dom.model_gen.MjOrzpzoniepCriteria.Criteria;
import pl.topteam.arisco.dom.model_gen.MjOrzpzoniepCriteria.Criterion;
import pl.topteam.arisco.dom.model.MjOrzpzoniepCriteria;

public class MjOrzpzoniepSqlProvider {

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String countByExample(MjOrzpzoniepCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("MJ_ORZPZONIEP");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(MjOrzpzoniepCriteria example) {
        BEGIN();
        DELETE_FROM("MJ_ORZPZONIEP");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(MjOrzpzoniep record) {
        BEGIN();
        INSERT_INTO("MJ_ORZPZONIEP");
        
        if (record.getIdOrzeczpzo() != null) {
            VALUES("ID_ORZECZPZO", "#{idOrzeczpzo,jdbcType=INTEGER}");
        }
        
        if (record.getIdOsoby() != null) {
            VALUES("ID_OSOBY", "#{idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getSymbniep() != null) {
            VALUES("SYMBNIEP", "#{symbniep,jdbcType=VARCHAR}");
        }
        
        if (record.getOpisniep() != null) {
            VALUES("OPISNIEP", "#{opisniep,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            VALUES("UTWORZYL", "#{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            VALUES("POPRAWIL", "#{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getIdSlrodzniepel() != null) {
            VALUES("ID_SLRODZNIEPEL", "#{idSlrodzniepel,jdbcType=INTEGER}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(MjOrzpzoniepCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("ID");
        } else {
            SELECT("ID");
        }
        SELECT("ID_ORZECZPZO");
        SELECT("ID_OSOBY");
        SELECT("SYMBNIEP");
        SELECT("OPISNIEP");
        SELECT("UTWORZYL");
        SELECT("POPRAWIL");
        SELECT("ID_SLRODZNIEPEL");
        FROM("MJ_ORZPZONIEP");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        MjOrzpzoniep record = (MjOrzpzoniep) parameter.get("record");
        MjOrzpzoniepCriteria example = (MjOrzpzoniepCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("MJ_ORZPZONIEP");
        
        if (record.getId() != null) {
            SET("ID = #{record.id,jdbcType=INTEGER}");
        }
        
        if (record.getIdOrzeczpzo() != null) {
            SET("ID_ORZECZPZO = #{record.idOrzeczpzo,jdbcType=INTEGER}");
        }
        
        if (record.getIdOsoby() != null) {
            SET("ID_OSOBY = #{record.idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getSymbniep() != null) {
            SET("SYMBNIEP = #{record.symbniep,jdbcType=VARCHAR}");
        }
        
        if (record.getOpisniep() != null) {
            SET("OPISNIEP = #{record.opisniep,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getIdSlrodzniepel() != null) {
            SET("ID_SLRODZNIEPEL = #{record.idSlrodzniepel,jdbcType=INTEGER}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("MJ_ORZPZONIEP");
        
        SET("ID = #{record.id,jdbcType=INTEGER}");
        SET("ID_ORZECZPZO = #{record.idOrzeczpzo,jdbcType=INTEGER}");
        SET("ID_OSOBY = #{record.idOsoby,jdbcType=INTEGER}");
        SET("SYMBNIEP = #{record.symbniep,jdbcType=VARCHAR}");
        SET("OPISNIEP = #{record.opisniep,jdbcType=VARCHAR}");
        SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        SET("ID_SLRODZNIEPEL = #{record.idSlrodzniepel,jdbcType=INTEGER}");
        
        MjOrzpzoniepCriteria example = (MjOrzpzoniepCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByPrimaryKeySelective(MjOrzpzoniep record) {
        BEGIN();
        UPDATE("MJ_ORZPZONIEP");
        
        if (record.getIdOrzeczpzo() != null) {
            SET("ID_ORZECZPZO = #{idOrzeczpzo,jdbcType=INTEGER}");
        }
        
        if (record.getIdOsoby() != null) {
            SET("ID_OSOBY = #{idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getSymbniep() != null) {
            SET("SYMBNIEP = #{symbniep,jdbcType=VARCHAR}");
        }
        
        if (record.getOpisniep() != null) {
            SET("OPISNIEP = #{opisniep,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getIdSlrodzniepel() != null) {
            SET("ID_SLRODZNIEPEL = #{idSlrodzniepel,jdbcType=INTEGER}");
        }
        
        WHERE("ID = #{id,jdbcType=INTEGER}");
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(MjOrzpzoniepCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}