package pl.topteam.arisco.dom.dao_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.arisco.dom.model.MjPlatnosci;
import pl.topteam.arisco.dom.model.MjPlatnosciCriteria;

public abstract interface MjPlatnosciMapper {
    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjPlatnosciSqlProvider.class, method="countByExample")
    int countByExample(MjPlatnosciCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @DeleteProvider(type=MjPlatnosciSqlProvider.class, method="deleteByExample")
    int deleteByExample(MjPlatnosciCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Delete({
        "delete from MJ_PLATNOSCI",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    int deleteByPrimaryKey(Integer id);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Insert({
        "insert into MJ_PLATNOSCI (ID_OSOBY, ID_PLATNIKA, ",
        "DATA_OD, DATA_DO, STATUS, ",
        "UTWORZYL, POPRAWIL)",
        "values (#{idOsoby,jdbcType=INTEGER}, #{idPlatnika,jdbcType=INTEGER}, ",
        "#{dataOd,jdbcType=DATE}, #{dataDo,jdbcType=DATE}, #{status,jdbcType=CHAR}, ",
        "#{utworzyl,jdbcType=VARCHAR}, #{poprawil,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="_", keyProperty="id", before=false, resultType=Integer.class)
    int insert(MjPlatnosci record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    int mergeInto(MjPlatnosci record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @InsertProvider(type=MjPlatnosciSqlProvider.class, method="insertSelective")
    @SelectKey(statement="_", keyProperty="id", before=false, resultType=Integer.class)
    int insertSelective(MjPlatnosci record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjPlatnosciSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="ID_PLATNIKA", property="idPlatnika", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="STATUS", property="status", jdbcType=JdbcType.CHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR)
    })
    List<MjPlatnosci> selectByExampleWithRowbounds(MjPlatnosciCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=MjPlatnosciSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="ID_PLATNIKA", property="idPlatnika", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="STATUS", property="status", jdbcType=JdbcType.CHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR)
    })
    List<MjPlatnosci> selectByExample(MjPlatnosciCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Select({
        "select",
        "ID, ID_OSOBY, ID_PLATNIKA, DATA_OD, DATA_DO, STATUS, UTWORZYL, POPRAWIL",
        "from MJ_PLATNOSCI",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_OSOBY", property="idOsoby", jdbcType=JdbcType.INTEGER),
        @Result(column="ID_PLATNIKA", property="idPlatnika", jdbcType=JdbcType.INTEGER),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="STATUS", property="status", jdbcType=JdbcType.CHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR)
    })
    MjPlatnosci selectByPrimaryKey(Integer id);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjPlatnosciSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") MjPlatnosci record, @Param("example") MjPlatnosciCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjPlatnosciSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") MjPlatnosci record, @Param("example") MjPlatnosciCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=MjPlatnosciSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(MjPlatnosci record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Update({
        "update MJ_PLATNOSCI",
        "set ID_OSOBY = #{idOsoby,jdbcType=INTEGER},",
          "ID_PLATNIKA = #{idPlatnika,jdbcType=INTEGER},",
          "DATA_OD = #{dataOd,jdbcType=DATE},",
          "DATA_DO = #{dataDo,jdbcType=DATE},",
          "STATUS = #{status,jdbcType=CHAR},",
          "UTWORZYL = #{utworzyl,jdbcType=VARCHAR},",
          "POPRAWIL = #{poprawil,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=INTEGER}"
    })
    int updateByPrimaryKey(MjPlatnosci record);
}