package pl.topteam.arisco.dom.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.arisco.dom.model.MjUbezwlas;
import pl.topteam.arisco.dom.model_gen.MjUbezwlasCriteria.Criteria;
import pl.topteam.arisco.dom.model_gen.MjUbezwlasCriteria.Criterion;
import pl.topteam.arisco.dom.model.MjUbezwlasCriteria;

public class MjUbezwlasSqlProvider {

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String countByExample(MjUbezwlasCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("MJ_UBEZWLAS");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(MjUbezwlasCriteria example) {
        BEGIN();
        DELETE_FROM("MJ_UBEZWLAS");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(MjUbezwlas record) {
        BEGIN();
        INSERT_INTO("MJ_UBEZWLAS");
        
        if (record.getIdPodop() != null) {
            VALUES("ID_PODOP", "#{idPodop,jdbcType=INTEGER}");
        }
        
        if (record.getData() != null) {
            VALUES("DATA", "#{data,jdbcType=DATE}");
        }
        
        if (record.getSygnatura() != null) {
            VALUES("SYGNATURA", "#{sygnatura,jdbcType=VARCHAR}");
        }
        
        if (record.getZakres() != null) {
            VALUES("ZAKRES", "#{zakres,jdbcType=VARCHAR}");
        }
        
        if (record.getWydPrzez() != null) {
            VALUES("WYD_PRZEZ", "#{wydPrzez,jdbcType=VARCHAR}");
        }
        
        if (record.getzWniosku() != null) {
            VALUES("Z_WNIOSKU", "#{zWniosku,jdbcType=VARCHAR}");
        }
        
        if (record.getUwagi() != null) {
            VALUES("UWAGI", "#{uwagi,jdbcType=VARCHAR}");
        }
        
        if (record.getZakresId() != null) {
            VALUES("ZAKRES_ID", "#{zakresId,jdbcType=INTEGER}");
        }
        
        if (record.getUtworzyl() != null) {
            VALUES("UTWORZYL", "#{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            VALUES("POPRAWIL", "#{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getCoTo() != null) {
            VALUES("CO_TO", "#{coTo,jdbcType=CHAR}");
        }
        
        if (record.getOdDnia() != null) {
            VALUES("OD_DNIA", "#{odDnia,jdbcType=DATE}");
        }
        
        if (record.getDoDnia() != null) {
            VALUES("DO_DNIA", "#{doDnia,jdbcType=DATE}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(MjUbezwlasCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("ID");
        } else {
            SELECT("ID");
        }
        SELECT("ID_PODOP");
        SELECT("DATA");
        SELECT("SYGNATURA");
        SELECT("ZAKRES");
        SELECT("WYD_PRZEZ");
        SELECT("Z_WNIOSKU");
        SELECT("UWAGI");
        SELECT("ZAKRES_ID");
        SELECT("UTWORZYL");
        SELECT("POPRAWIL");
        SELECT("CO_TO");
        SELECT("OD_DNIA");
        SELECT("DO_DNIA");
        FROM("MJ_UBEZWLAS");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        MjUbezwlas record = (MjUbezwlas) parameter.get("record");
        MjUbezwlasCriteria example = (MjUbezwlasCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("MJ_UBEZWLAS");
        
        if (record.getId() != null) {
            SET("ID = #{record.id,jdbcType=INTEGER}");
        }
        
        if (record.getIdPodop() != null) {
            SET("ID_PODOP = #{record.idPodop,jdbcType=INTEGER}");
        }
        
        if (record.getData() != null) {
            SET("DATA = #{record.data,jdbcType=DATE}");
        }
        
        if (record.getSygnatura() != null) {
            SET("SYGNATURA = #{record.sygnatura,jdbcType=VARCHAR}");
        }
        
        if (record.getZakres() != null) {
            SET("ZAKRES = #{record.zakres,jdbcType=VARCHAR}");
        }
        
        if (record.getWydPrzez() != null) {
            SET("WYD_PRZEZ = #{record.wydPrzez,jdbcType=VARCHAR}");
        }
        
        if (record.getzWniosku() != null) {
            SET("Z_WNIOSKU = #{record.zWniosku,jdbcType=VARCHAR}");
        }
        
        if (record.getUwagi() != null) {
            SET("UWAGI = #{record.uwagi,jdbcType=VARCHAR}");
        }
        
        if (record.getZakresId() != null) {
            SET("ZAKRES_ID = #{record.zakresId,jdbcType=INTEGER}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getCoTo() != null) {
            SET("CO_TO = #{record.coTo,jdbcType=CHAR}");
        }
        
        if (record.getOdDnia() != null) {
            SET("OD_DNIA = #{record.odDnia,jdbcType=DATE}");
        }
        
        if (record.getDoDnia() != null) {
            SET("DO_DNIA = #{record.doDnia,jdbcType=DATE}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("MJ_UBEZWLAS");
        
        SET("ID = #{record.id,jdbcType=INTEGER}");
        SET("ID_PODOP = #{record.idPodop,jdbcType=INTEGER}");
        SET("DATA = #{record.data,jdbcType=DATE}");
        SET("SYGNATURA = #{record.sygnatura,jdbcType=VARCHAR}");
        SET("ZAKRES = #{record.zakres,jdbcType=VARCHAR}");
        SET("WYD_PRZEZ = #{record.wydPrzez,jdbcType=VARCHAR}");
        SET("Z_WNIOSKU = #{record.zWniosku,jdbcType=VARCHAR}");
        SET("UWAGI = #{record.uwagi,jdbcType=VARCHAR}");
        SET("ZAKRES_ID = #{record.zakresId,jdbcType=INTEGER}");
        SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        SET("CO_TO = #{record.coTo,jdbcType=CHAR}");
        SET("OD_DNIA = #{record.odDnia,jdbcType=DATE}");
        SET("DO_DNIA = #{record.doDnia,jdbcType=DATE}");
        
        MjUbezwlasCriteria example = (MjUbezwlasCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByPrimaryKeySelective(MjUbezwlas record) {
        BEGIN();
        UPDATE("MJ_UBEZWLAS");
        
        if (record.getIdPodop() != null) {
            SET("ID_PODOP = #{idPodop,jdbcType=INTEGER}");
        }
        
        if (record.getData() != null) {
            SET("DATA = #{data,jdbcType=DATE}");
        }
        
        if (record.getSygnatura() != null) {
            SET("SYGNATURA = #{sygnatura,jdbcType=VARCHAR}");
        }
        
        if (record.getZakres() != null) {
            SET("ZAKRES = #{zakres,jdbcType=VARCHAR}");
        }
        
        if (record.getWydPrzez() != null) {
            SET("WYD_PRZEZ = #{wydPrzez,jdbcType=VARCHAR}");
        }
        
        if (record.getzWniosku() != null) {
            SET("Z_WNIOSKU = #{zWniosku,jdbcType=VARCHAR}");
        }
        
        if (record.getUwagi() != null) {
            SET("UWAGI = #{uwagi,jdbcType=VARCHAR}");
        }
        
        if (record.getZakresId() != null) {
            SET("ZAKRES_ID = #{zakresId,jdbcType=INTEGER}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getCoTo() != null) {
            SET("CO_TO = #{coTo,jdbcType=CHAR}");
        }
        
        if (record.getOdDnia() != null) {
            SET("OD_DNIA = #{odDnia,jdbcType=DATE}");
        }
        
        if (record.getDoDnia() != null) {
            SET("DO_DNIA = #{doDnia,jdbcType=DATE}");
        }
        
        WHERE("ID = #{id,jdbcType=INTEGER}");
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(MjUbezwlasCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}