package pl.topteam.arisco.dom.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.arisco.dom.model.MjWplaty;
import pl.topteam.arisco.dom.model_gen.MjWplatyCriteria.Criteria;
import pl.topteam.arisco.dom.model_gen.MjWplatyCriteria.Criterion;
import pl.topteam.arisco.dom.model.MjWplatyCriteria;

public class MjWplatySqlProvider {

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String countByExample(MjWplatyCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("MJ_WPLATY");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(MjWplatyCriteria example) {
        BEGIN();
        DELETE_FROM("MJ_WPLATY");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(MjWplaty record) {
        BEGIN();
        INSERT_INTO("MJ_WPLATY");
        
        if (record.getIdOsoby() != null) {
            VALUES("ID_OSOBY", "#{idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getData() != null) {
            VALUES("DATA", "#{data,jdbcType=DATE}");
        }
        
        if (record.getKwota() != null) {
            VALUES("KWOTA", "#{kwota,jdbcType=NUMERIC}");
        }
        
        if (record.getOpis() != null) {
            VALUES("OPIS", "#{opis,jdbcType=VARCHAR}");
        }
        
        if (record.getKwotaDoPow() != null) {
            VALUES("KWOTA_DO_POW", "#{kwotaDoPow,jdbcType=NUMERIC}");
        }
        
        if (record.getTypDok() != null) {
            VALUES("TYP_DOK", "#{typDok,jdbcType=INTEGER}");
        }
        
        if (record.getNrDok() != null) {
            VALUES("NR_DOK", "#{nrDok,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            VALUES("UTWORZYL", "#{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            VALUES("POPRAWIL", "#{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getWyexport() != null) {
            VALUES("WYEXPORT", "#{wyexport,jdbcType=CHAR}");
        }
        
        if (record.getBddId() != null) {
            VALUES("BDD_ID", "#{bddId,jdbcType=INTEGER}");
        }
        
        if (record.getBdpId() != null) {
            VALUES("BDP_ID", "#{bdpId,jdbcType=INTEGER}");
        }
        
        if (record.getCzyJuzwydr() != null) {
            VALUES("CZY_JUZWYDR", "#{czyJuzwydr,jdbcType=CHAR}");
        }
        
        if (record.getDataWyslania() != null) {
            VALUES("DATA_WYSLANIA", "#{dataWyslania,jdbcType=DATE}");
        }
        
        if (record.getBddStatus() != null) {
            VALUES("BDD_STATUS", "#{bddStatus,jdbcType=INTEGER}");
        }
        
        if (record.getBddPrPrintDate() != null) {
            VALUES("BDD_PR_PRINT_DATE", "#{bddPrPrintDate,jdbcType=DATE}");
        }
        
        if (record.getBddPrDokNrFull() != null) {
            VALUES("BDD_PR_DOK_NR_FULL", "#{bddPrDokNrFull,jdbcType=VARCHAR}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(MjWplatyCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("ID");
        } else {
            SELECT("ID");
        }
        SELECT("ID_OSOBY");
        SELECT("DATA");
        SELECT("KWOTA");
        SELECT("OPIS");
        SELECT("KWOTA_DO_POW");
        SELECT("TYP_DOK");
        SELECT("NR_DOK");
        SELECT("UTWORZYL");
        SELECT("POPRAWIL");
        SELECT("WYEXPORT");
        SELECT("BDD_ID");
        SELECT("BDP_ID");
        SELECT("CZY_JUZWYDR");
        SELECT("DATA_WYSLANIA");
        SELECT("BDD_STATUS");
        SELECT("BDD_PR_PRINT_DATE");
        SELECT("BDD_PR_DOK_NR_FULL");
        FROM("MJ_WPLATY");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        MjWplaty record = (MjWplaty) parameter.get("record");
        MjWplatyCriteria example = (MjWplatyCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("MJ_WPLATY");
        
        if (record.getId() != null) {
            SET("ID = #{record.id,jdbcType=INTEGER}");
        }
        
        if (record.getIdOsoby() != null) {
            SET("ID_OSOBY = #{record.idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getData() != null) {
            SET("DATA = #{record.data,jdbcType=DATE}");
        }
        
        if (record.getKwota() != null) {
            SET("KWOTA = #{record.kwota,jdbcType=NUMERIC}");
        }
        
        if (record.getOpis() != null) {
            SET("OPIS = #{record.opis,jdbcType=VARCHAR}");
        }
        
        if (record.getKwotaDoPow() != null) {
            SET("KWOTA_DO_POW = #{record.kwotaDoPow,jdbcType=NUMERIC}");
        }
        
        if (record.getTypDok() != null) {
            SET("TYP_DOK = #{record.typDok,jdbcType=INTEGER}");
        }
        
        if (record.getNrDok() != null) {
            SET("NR_DOK = #{record.nrDok,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getWyexport() != null) {
            SET("WYEXPORT = #{record.wyexport,jdbcType=CHAR}");
        }
        
        if (record.getBddId() != null) {
            SET("BDD_ID = #{record.bddId,jdbcType=INTEGER}");
        }
        
        if (record.getBdpId() != null) {
            SET("BDP_ID = #{record.bdpId,jdbcType=INTEGER}");
        }
        
        if (record.getCzyJuzwydr() != null) {
            SET("CZY_JUZWYDR = #{record.czyJuzwydr,jdbcType=CHAR}");
        }
        
        if (record.getDataWyslania() != null) {
            SET("DATA_WYSLANIA = #{record.dataWyslania,jdbcType=DATE}");
        }
        
        if (record.getBddStatus() != null) {
            SET("BDD_STATUS = #{record.bddStatus,jdbcType=INTEGER}");
        }
        
        if (record.getBddPrPrintDate() != null) {
            SET("BDD_PR_PRINT_DATE = #{record.bddPrPrintDate,jdbcType=DATE}");
        }
        
        if (record.getBddPrDokNrFull() != null) {
            SET("BDD_PR_DOK_NR_FULL = #{record.bddPrDokNrFull,jdbcType=VARCHAR}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("MJ_WPLATY");
        
        SET("ID = #{record.id,jdbcType=INTEGER}");
        SET("ID_OSOBY = #{record.idOsoby,jdbcType=INTEGER}");
        SET("DATA = #{record.data,jdbcType=DATE}");
        SET("KWOTA = #{record.kwota,jdbcType=NUMERIC}");
        SET("OPIS = #{record.opis,jdbcType=VARCHAR}");
        SET("KWOTA_DO_POW = #{record.kwotaDoPow,jdbcType=NUMERIC}");
        SET("TYP_DOK = #{record.typDok,jdbcType=INTEGER}");
        SET("NR_DOK = #{record.nrDok,jdbcType=VARCHAR}");
        SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        SET("WYEXPORT = #{record.wyexport,jdbcType=CHAR}");
        SET("BDD_ID = #{record.bddId,jdbcType=INTEGER}");
        SET("BDP_ID = #{record.bdpId,jdbcType=INTEGER}");
        SET("CZY_JUZWYDR = #{record.czyJuzwydr,jdbcType=CHAR}");
        SET("DATA_WYSLANIA = #{record.dataWyslania,jdbcType=DATE}");
        SET("BDD_STATUS = #{record.bddStatus,jdbcType=INTEGER}");
        SET("BDD_PR_PRINT_DATE = #{record.bddPrPrintDate,jdbcType=DATE}");
        SET("BDD_PR_DOK_NR_FULL = #{record.bddPrDokNrFull,jdbcType=VARCHAR}");
        
        MjWplatyCriteria example = (MjWplatyCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByPrimaryKeySelective(MjWplaty record) {
        BEGIN();
        UPDATE("MJ_WPLATY");
        
        if (record.getIdOsoby() != null) {
            SET("ID_OSOBY = #{idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getData() != null) {
            SET("DATA = #{data,jdbcType=DATE}");
        }
        
        if (record.getKwota() != null) {
            SET("KWOTA = #{kwota,jdbcType=NUMERIC}");
        }
        
        if (record.getOpis() != null) {
            SET("OPIS = #{opis,jdbcType=VARCHAR}");
        }
        
        if (record.getKwotaDoPow() != null) {
            SET("KWOTA_DO_POW = #{kwotaDoPow,jdbcType=NUMERIC}");
        }
        
        if (record.getTypDok() != null) {
            SET("TYP_DOK = #{typDok,jdbcType=INTEGER}");
        }
        
        if (record.getNrDok() != null) {
            SET("NR_DOK = #{nrDok,jdbcType=VARCHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getWyexport() != null) {
            SET("WYEXPORT = #{wyexport,jdbcType=CHAR}");
        }
        
        if (record.getBddId() != null) {
            SET("BDD_ID = #{bddId,jdbcType=INTEGER}");
        }
        
        if (record.getBdpId() != null) {
            SET("BDP_ID = #{bdpId,jdbcType=INTEGER}");
        }
        
        if (record.getCzyJuzwydr() != null) {
            SET("CZY_JUZWYDR = #{czyJuzwydr,jdbcType=CHAR}");
        }
        
        if (record.getDataWyslania() != null) {
            SET("DATA_WYSLANIA = #{dataWyslania,jdbcType=DATE}");
        }
        
        if (record.getBddStatus() != null) {
            SET("BDD_STATUS = #{bddStatus,jdbcType=INTEGER}");
        }
        
        if (record.getBddPrPrintDate() != null) {
            SET("BDD_PR_PRINT_DATE = #{bddPrPrintDate,jdbcType=DATE}");
        }
        
        if (record.getBddPrDokNrFull() != null) {
            SET("BDD_PR_DOK_NR_FULL = #{bddPrDokNrFull,jdbcType=VARCHAR}");
        }
        
        WHERE("ID = #{id,jdbcType=INTEGER}");
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(MjWplatyCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}