package pl.topteam.arisco.dom.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.arisco.dom.model.Platnik;
import pl.topteam.arisco.dom.model_gen.PlatnikCriteria.Criteria;
import pl.topteam.arisco.dom.model_gen.PlatnikCriteria.Criterion;
import pl.topteam.arisco.dom.model.PlatnikCriteria;

public class PlatnikSqlProvider {

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String countByExample(PlatnikCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("PLATNIK");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(PlatnikCriteria example) {
        BEGIN();
        DELETE_FROM("PLATNIK");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(Platnik record) {
        BEGIN();
        INSERT_INTO("PLATNIK");
        
        if (record.getNazwa() != null) {
            VALUES("NAZWA", "#{nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getNip() != null) {
            VALUES("NIP", "#{nip,jdbcType=VARCHAR}");
        }
        
        if (record.getUlica() != null) {
            VALUES("ULICA", "#{ulica,jdbcType=VARCHAR}");
        }
        
        if (record.getNrDom() != null) {
            VALUES("NR_DOM", "#{nrDom,jdbcType=VARCHAR}");
        }
        
        if (record.getNrLok() != null) {
            VALUES("NR_LOK", "#{nrLok,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscowosc() != null) {
            VALUES("MIEJSCOWOSC", "#{miejscowosc,jdbcType=VARCHAR}");
        }
        
        if (record.getKodPoczt() != null) {
            VALUES("KOD_POCZT", "#{kodPoczt,jdbcType=VARCHAR}");
        }
        
        if (record.getPoczta() != null) {
            VALUES("POCZTA", "#{poczta,jdbcType=VARCHAR}");
        }
        
        if (record.getRegon() != null) {
            VALUES("REGON", "#{regon,jdbcType=CHAR}");
        }
        
        if (record.getPesel() != null) {
            VALUES("PESEL", "#{pesel,jdbcType=CHAR}");
        }
        
        if (record.getNazwaSkr() != null) {
            VALUES("NAZWA_SKR", "#{nazwaSkr,jdbcType=CHAR}");
        }
        
        if (record.getPowiat() != null) {
            VALUES("POWIAT", "#{powiat,jdbcType=CHAR}");
        }
        
        if (record.getGmDziel() != null) {
            VALUES("GM_DZIEL", "#{gmDziel,jdbcType=CHAR}");
        }
        
        if (record.getSkrytka() != null) {
            VALUES("SKRYTKA", "#{skrytka,jdbcType=CHAR}");
        }
        
        if (record.getTelefon() != null) {
            VALUES("TELEFON", "#{telefon,jdbcType=CHAR}");
        }
        
        if (record.getTeleks() != null) {
            VALUES("TELEKS", "#{teleks,jdbcType=CHAR}");
        }
        
        if (record.getFax() != null) {
            VALUES("FAX", "#{fax,jdbcType=CHAR}");
        }
        
        if (record.getNazwaDoDruk() != null) {
            VALUES("NAZWA_DO_DRUK", "#{nazwaDoDruk,jdbcType=CHAR}");
        }
        
        if (record.getDokumentNr() != null) {
            VALUES("DOKUMENT_NR", "#{dokumentNr,jdbcType=CHAR}");
        }
        
        if (record.getDokumentRodz() != null) {
            VALUES("DOKUMENT_RODZ", "#{dokumentRodz,jdbcType=CHAR}");
        }
        
        if (record.getOddzialZus() != null) {
            VALUES("ODDZIAL_ZUS", "#{oddzialZus,jdbcType=CHAR}");
        }
        
        if (record.getNkp() != null) {
            VALUES("NKP", "#{nkp,jdbcType=CHAR}");
        }
        
        if (record.getPoprawil() != null) {
            VALUES("POPRAWIL", "#{poprawil,jdbcType=CHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            VALUES("UTWORZYL", "#{utworzyl,jdbcType=CHAR}");
        }
        
        if (record.getEkd() != null) {
            VALUES("EKD", "#{ekd,jdbcType=CHAR}");
        }
        
        if (record.getNumerKontaBank() != null) {
            VALUES("NUMER_KONTA_BANK", "#{numerKontaBank,jdbcType=VARCHAR}");
        }
        
        if (record.getSciezkaLogo() != null) {
            VALUES("SCIEZKA_LOGO", "#{sciezkaLogo,jdbcType=VARCHAR}");
        }
        
        if (record.getKraj() != null) {
            VALUES("KRAJ", "#{kraj,jdbcType=VARCHAR}");
        }
        
        if (record.getWojewodztwo() != null) {
            VALUES("WOJEWODZTWO", "#{wojewodztwo,jdbcType=VARCHAR}");
        }
        
        if (record.getLogoWysokosc() != null) {
            VALUES("LOGO_WYSOKOSC", "#{logoWysokosc,jdbcType=SMALLINT}");
        }
        
        if (record.getRysNag() != null) {
            VALUES("RYS_NAG", "#{rysNag,jdbcType=OTHER}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(PlatnikCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("ID");
        } else {
            SELECT("ID");
        }
        SELECT("NAZWA");
        SELECT("NIP");
        SELECT("ULICA");
        SELECT("NR_DOM");
        SELECT("NR_LOK");
        SELECT("MIEJSCOWOSC");
        SELECT("KOD_POCZT");
        SELECT("POCZTA");
        SELECT("REGON");
        SELECT("PESEL");
        SELECT("NAZWA_SKR");
        SELECT("POWIAT");
        SELECT("GM_DZIEL");
        SELECT("SKRYTKA");
        SELECT("TELEFON");
        SELECT("TELEKS");
        SELECT("FAX");
        SELECT("NAZWA_DO_DRUK");
        SELECT("DOKUMENT_NR");
        SELECT("DOKUMENT_RODZ");
        SELECT("ODDZIAL_ZUS");
        SELECT("NKP");
        SELECT("POPRAWIL");
        SELECT("UTWORZYL");
        SELECT("EKD");
        SELECT("NUMER_KONTA_BANK");
        SELECT("SCIEZKA_LOGO");
        SELECT("KRAJ");
        SELECT("WOJEWODZTWO");
        SELECT("LOGO_WYSOKOSC");
        SELECT("RYS_NAG");
        FROM("PLATNIK");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        Platnik record = (Platnik) parameter.get("record");
        PlatnikCriteria example = (PlatnikCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("PLATNIK");
        
        if (record.getId() != null) {
            SET("ID = #{record.id,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getNip() != null) {
            SET("NIP = #{record.nip,jdbcType=VARCHAR}");
        }
        
        if (record.getUlica() != null) {
            SET("ULICA = #{record.ulica,jdbcType=VARCHAR}");
        }
        
        if (record.getNrDom() != null) {
            SET("NR_DOM = #{record.nrDom,jdbcType=VARCHAR}");
        }
        
        if (record.getNrLok() != null) {
            SET("NR_LOK = #{record.nrLok,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscowosc() != null) {
            SET("MIEJSCOWOSC = #{record.miejscowosc,jdbcType=VARCHAR}");
        }
        
        if (record.getKodPoczt() != null) {
            SET("KOD_POCZT = #{record.kodPoczt,jdbcType=VARCHAR}");
        }
        
        if (record.getPoczta() != null) {
            SET("POCZTA = #{record.poczta,jdbcType=VARCHAR}");
        }
        
        if (record.getRegon() != null) {
            SET("REGON = #{record.regon,jdbcType=CHAR}");
        }
        
        if (record.getPesel() != null) {
            SET("PESEL = #{record.pesel,jdbcType=CHAR}");
        }
        
        if (record.getNazwaSkr() != null) {
            SET("NAZWA_SKR = #{record.nazwaSkr,jdbcType=CHAR}");
        }
        
        if (record.getPowiat() != null) {
            SET("POWIAT = #{record.powiat,jdbcType=CHAR}");
        }
        
        if (record.getGmDziel() != null) {
            SET("GM_DZIEL = #{record.gmDziel,jdbcType=CHAR}");
        }
        
        if (record.getSkrytka() != null) {
            SET("SKRYTKA = #{record.skrytka,jdbcType=CHAR}");
        }
        
        if (record.getTelefon() != null) {
            SET("TELEFON = #{record.telefon,jdbcType=CHAR}");
        }
        
        if (record.getTeleks() != null) {
            SET("TELEKS = #{record.teleks,jdbcType=CHAR}");
        }
        
        if (record.getFax() != null) {
            SET("FAX = #{record.fax,jdbcType=CHAR}");
        }
        
        if (record.getNazwaDoDruk() != null) {
            SET("NAZWA_DO_DRUK = #{record.nazwaDoDruk,jdbcType=CHAR}");
        }
        
        if (record.getDokumentNr() != null) {
            SET("DOKUMENT_NR = #{record.dokumentNr,jdbcType=CHAR}");
        }
        
        if (record.getDokumentRodz() != null) {
            SET("DOKUMENT_RODZ = #{record.dokumentRodz,jdbcType=CHAR}");
        }
        
        if (record.getOddzialZus() != null) {
            SET("ODDZIAL_ZUS = #{record.oddzialZus,jdbcType=CHAR}");
        }
        
        if (record.getNkp() != null) {
            SET("NKP = #{record.nkp,jdbcType=CHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{record.poprawil,jdbcType=CHAR}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{record.utworzyl,jdbcType=CHAR}");
        }
        
        if (record.getEkd() != null) {
            SET("EKD = #{record.ekd,jdbcType=CHAR}");
        }
        
        if (record.getNumerKontaBank() != null) {
            SET("NUMER_KONTA_BANK = #{record.numerKontaBank,jdbcType=VARCHAR}");
        }
        
        if (record.getSciezkaLogo() != null) {
            SET("SCIEZKA_LOGO = #{record.sciezkaLogo,jdbcType=VARCHAR}");
        }
        
        if (record.getKraj() != null) {
            SET("KRAJ = #{record.kraj,jdbcType=VARCHAR}");
        }
        
        if (record.getWojewodztwo() != null) {
            SET("WOJEWODZTWO = #{record.wojewodztwo,jdbcType=VARCHAR}");
        }
        
        if (record.getLogoWysokosc() != null) {
            SET("LOGO_WYSOKOSC = #{record.logoWysokosc,jdbcType=SMALLINT}");
        }
        
        if (record.getRysNag() != null) {
            SET("RYS_NAG = #{record.rysNag,jdbcType=OTHER}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("PLATNIK");
        
        SET("ID = #{record.id,jdbcType=INTEGER}");
        SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        SET("NIP = #{record.nip,jdbcType=VARCHAR}");
        SET("ULICA = #{record.ulica,jdbcType=VARCHAR}");
        SET("NR_DOM = #{record.nrDom,jdbcType=VARCHAR}");
        SET("NR_LOK = #{record.nrLok,jdbcType=VARCHAR}");
        SET("MIEJSCOWOSC = #{record.miejscowosc,jdbcType=VARCHAR}");
        SET("KOD_POCZT = #{record.kodPoczt,jdbcType=VARCHAR}");
        SET("POCZTA = #{record.poczta,jdbcType=VARCHAR}");
        SET("REGON = #{record.regon,jdbcType=CHAR}");
        SET("PESEL = #{record.pesel,jdbcType=CHAR}");
        SET("NAZWA_SKR = #{record.nazwaSkr,jdbcType=CHAR}");
        SET("POWIAT = #{record.powiat,jdbcType=CHAR}");
        SET("GM_DZIEL = #{record.gmDziel,jdbcType=CHAR}");
        SET("SKRYTKA = #{record.skrytka,jdbcType=CHAR}");
        SET("TELEFON = #{record.telefon,jdbcType=CHAR}");
        SET("TELEKS = #{record.teleks,jdbcType=CHAR}");
        SET("FAX = #{record.fax,jdbcType=CHAR}");
        SET("NAZWA_DO_DRUK = #{record.nazwaDoDruk,jdbcType=CHAR}");
        SET("DOKUMENT_NR = #{record.dokumentNr,jdbcType=CHAR}");
        SET("DOKUMENT_RODZ = #{record.dokumentRodz,jdbcType=CHAR}");
        SET("ODDZIAL_ZUS = #{record.oddzialZus,jdbcType=CHAR}");
        SET("NKP = #{record.nkp,jdbcType=CHAR}");
        SET("POPRAWIL = #{record.poprawil,jdbcType=CHAR}");
        SET("UTWORZYL = #{record.utworzyl,jdbcType=CHAR}");
        SET("EKD = #{record.ekd,jdbcType=CHAR}");
        SET("NUMER_KONTA_BANK = #{record.numerKontaBank,jdbcType=VARCHAR}");
        SET("SCIEZKA_LOGO = #{record.sciezkaLogo,jdbcType=VARCHAR}");
        SET("KRAJ = #{record.kraj,jdbcType=VARCHAR}");
        SET("WOJEWODZTWO = #{record.wojewodztwo,jdbcType=VARCHAR}");
        SET("LOGO_WYSOKOSC = #{record.logoWysokosc,jdbcType=SMALLINT}");
        SET("RYS_NAG = #{record.rysNag,jdbcType=OTHER}");
        
        PlatnikCriteria example = (PlatnikCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(PlatnikCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}