package pl.topteam.bazmed.dao_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.bazmed.extension.model.BazylLek;
import pl.topteam.bazmed.extension.model.BazylLekCriteria;

public abstract interface BazylLekMapper {
    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @SelectProvider(type=BazylLekSqlProvider.class, method="countByExample")
    int countByExample(BazylLekCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @DeleteProvider(type=BazylLekSqlProvider.class, method="deleteByExample")
    int deleteByExample(BazylLekCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Delete({
        "delete from BAZYL_LEK",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Insert({
        "insert into BAZYL_LEK (DAWKA, NAZWA, ",
        "OPAKOWANIE_JEDNOSTKA_POJEMNOSCI, POSTAC)",
        "values (#{dawka,jdbcType=VARCHAR}, #{nazwa,jdbcType=VARCHAR}, ",
        "#{opakowanieJednostkaPojemnosci,jdbcType=VARCHAR}, #{postac,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(BazylLek record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    int mergeInto(BazylLek record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @InsertProvider(type=BazylLekSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(BazylLek record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @SelectProvider(type=BazylLekSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DAWKA", property="dawka", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPAKOWANIE_JEDNOSTKA_POJEMNOSCI", property="opakowanieJednostkaPojemnosci", jdbcType=JdbcType.VARCHAR),
        @Result(column="POSTAC", property="postac", jdbcType=JdbcType.VARCHAR)
    })
    List<BazylLek> selectByExampleWithRowbounds(BazylLekCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @SelectProvider(type=BazylLekSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DAWKA", property="dawka", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPAKOWANIE_JEDNOSTKA_POJEMNOSCI", property="opakowanieJednostkaPojemnosci", jdbcType=JdbcType.VARCHAR),
        @Result(column="POSTAC", property="postac", jdbcType=JdbcType.VARCHAR)
    })
    List<BazylLek> selectByExample(BazylLekCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Select({
        "select",
        "ID, DAWKA, NAZWA, OPAKOWANIE_JEDNOSTKA_POJEMNOSCI, POSTAC",
        "from BAZYL_LEK",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DAWKA", property="dawka", jdbcType=JdbcType.VARCHAR),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPAKOWANIE_JEDNOSTKA_POJEMNOSCI", property="opakowanieJednostkaPojemnosci", jdbcType=JdbcType.VARCHAR),
        @Result(column="POSTAC", property="postac", jdbcType=JdbcType.VARCHAR)
    })
    BazylLek selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @UpdateProvider(type=BazylLekSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") BazylLek record, @Param("example") BazylLekCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @UpdateProvider(type=BazylLekSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") BazylLek record, @Param("example") BazylLekCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @UpdateProvider(type=BazylLekSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(BazylLek record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Update({
        "update BAZYL_LEK",
        "set DAWKA = #{dawka,jdbcType=VARCHAR},",
          "NAZWA = #{nazwa,jdbcType=VARCHAR},",
          "OPAKOWANIE_JEDNOSTKA_POJEMNOSCI = #{opakowanieJednostkaPojemnosci,jdbcType=VARCHAR},",
          "POSTAC = #{postac,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(BazylLek record);
}