package pl.topteam.bazmed.dao_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.bazmed.extension.model.BazylLekPostac;
import pl.topteam.bazmed.extension.model.BazylLekPostacCriteria;

public abstract interface BazylLekPostacMapper {
    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @SelectProvider(type=BazylLekPostacSqlProvider.class, method="countByExample")
    int countByExample(BazylLekPostacCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @DeleteProvider(type=BazylLekPostacSqlProvider.class, method="deleteByExample")
    int deleteByExample(BazylLekPostacCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Delete({
        "delete from BAZYL_LEK_POSTAC",
        "where KOD_BAZYL = #{kodBazyl,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long kodBazyl);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Insert({
        "insert into BAZYL_LEK_POSTAC (KOD_BAZYL, LEK_ID, ",
        "PRODUCENT_ID, DOP_OBROT_POLSKA, ",
        "OPAKOWANIE_ILOSC, OPAKOWANIE_OPIS_BAZYL, ",
        "USUNIETY, WERSJA)",
        "values (#{kodBazyl,jdbcType=BIGINT}, #{lekId,jdbcType=BIGINT}, ",
        "#{producentId,jdbcType=BIGINT}, #{dopObrotPolska,jdbcType=BOOLEAN}, ",
        "#{opakowanieIlosc,jdbcType=DECIMAL}, #{opakowanieOpisBazyl,jdbcType=VARCHAR}, ",
        "#{usuniety,jdbcType=BOOLEAN}, #{wersja,jdbcType=DATE})"
    })
    int insert(BazylLekPostac record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    int mergeInto(BazylLekPostac record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @InsertProvider(type=BazylLekPostacSqlProvider.class, method="insertSelective")
    int insertSelective(BazylLekPostac record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @SelectProvider(type=BazylLekPostacSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="KOD_BAZYL", property="kodBazyl", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="LEK_ID", property="lekId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRODUCENT_ID", property="producentId", jdbcType=JdbcType.BIGINT),
        @Result(column="DOP_OBROT_POLSKA", property="dopObrotPolska", jdbcType=JdbcType.BOOLEAN),
        @Result(column="OPAKOWANIE_ILOSC", property="opakowanieIlosc", jdbcType=JdbcType.DECIMAL),
        @Result(column="OPAKOWANIE_OPIS_BAZYL", property="opakowanieOpisBazyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="USUNIETY", property="usuniety", jdbcType=JdbcType.BOOLEAN),
        @Result(column="WERSJA", property="wersja", jdbcType=JdbcType.DATE)
    })
    List<BazylLekPostac> selectByExampleWithRowbounds(BazylLekPostacCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @SelectProvider(type=BazylLekPostacSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="KOD_BAZYL", property="kodBazyl", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="LEK_ID", property="lekId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRODUCENT_ID", property="producentId", jdbcType=JdbcType.BIGINT),
        @Result(column="DOP_OBROT_POLSKA", property="dopObrotPolska", jdbcType=JdbcType.BOOLEAN),
        @Result(column="OPAKOWANIE_ILOSC", property="opakowanieIlosc", jdbcType=JdbcType.DECIMAL),
        @Result(column="OPAKOWANIE_OPIS_BAZYL", property="opakowanieOpisBazyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="USUNIETY", property="usuniety", jdbcType=JdbcType.BOOLEAN),
        @Result(column="WERSJA", property="wersja", jdbcType=JdbcType.DATE)
    })
    List<BazylLekPostac> selectByExample(BazylLekPostacCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Select({
        "select",
        "KOD_BAZYL, LEK_ID, PRODUCENT_ID, DOP_OBROT_POLSKA, OPAKOWANIE_ILOSC, OPAKOWANIE_OPIS_BAZYL, ",
        "USUNIETY, WERSJA",
        "from BAZYL_LEK_POSTAC",
        "where KOD_BAZYL = #{kodBazyl,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="KOD_BAZYL", property="kodBazyl", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="LEK_ID", property="lekId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRODUCENT_ID", property="producentId", jdbcType=JdbcType.BIGINT),
        @Result(column="DOP_OBROT_POLSKA", property="dopObrotPolska", jdbcType=JdbcType.BOOLEAN),
        @Result(column="OPAKOWANIE_ILOSC", property="opakowanieIlosc", jdbcType=JdbcType.DECIMAL),
        @Result(column="OPAKOWANIE_OPIS_BAZYL", property="opakowanieOpisBazyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="USUNIETY", property="usuniety", jdbcType=JdbcType.BOOLEAN),
        @Result(column="WERSJA", property="wersja", jdbcType=JdbcType.DATE)
    })
    BazylLekPostac selectByPrimaryKey(Long kodBazyl);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @UpdateProvider(type=BazylLekPostacSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") BazylLekPostac record, @Param("example") BazylLekPostacCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @UpdateProvider(type=BazylLekPostacSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") BazylLekPostac record, @Param("example") BazylLekPostacCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @UpdateProvider(type=BazylLekPostacSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(BazylLekPostac record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Update({
        "update BAZYL_LEK_POSTAC",
        "set LEK_ID = #{lekId,jdbcType=BIGINT},",
          "PRODUCENT_ID = #{producentId,jdbcType=BIGINT},",
          "DOP_OBROT_POLSKA = #{dopObrotPolska,jdbcType=BOOLEAN},",
          "OPAKOWANIE_ILOSC = #{opakowanieIlosc,jdbcType=DECIMAL},",
          "OPAKOWANIE_OPIS_BAZYL = #{opakowanieOpisBazyl,jdbcType=VARCHAR},",
          "USUNIETY = #{usuniety,jdbcType=BOOLEAN},",
          "WERSJA = #{wersja,jdbcType=DATE}",
        "where KOD_BAZYL = #{kodBazyl,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(BazylLekPostac record);
}