package pl.topteam.bazmed.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.bazmed.extension.model.BazylOdplatnoscSkladnik;
import pl.topteam.bazmed.model_gen.BazylOdplatnoscSkladnikCriteria.Criteria;
import pl.topteam.bazmed.model_gen.BazylOdplatnoscSkladnikCriteria.Criterion;
import pl.topteam.bazmed.extension.model.BazylOdplatnoscSkladnikCriteria;

public class BazylOdplatnoscSkladnikSqlProvider {

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String countByExample(BazylOdplatnoscSkladnikCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("BAZYL_ODPLATNOSC_SKLADNIK");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(BazylOdplatnoscSkladnikCriteria example) {
        BEGIN();
        DELETE_FROM("BAZYL_ODPLATNOSC_SKLADNIK");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(BazylOdplatnoscSkladnik record) {
        BEGIN();
        INSERT_INTO("BAZYL_ODPLATNOSC_SKLADNIK");
        
        if (record.getKodBazyl() != null) {
            VALUES("KOD_BAZYL", "#{kodBazyl,jdbcType=BIGINT}");
        }
        
        if (record.getUprawnienie() != null) {
            VALUES("UPRAWNIENIE", "#{uprawnienie,jdbcType=VARCHAR}");
        }
        
        if (record.getSposobObliczenia() != null) {
            VALUES("SPOSOB_OBLICZENIA", "#{sposobObliczenia,jdbcType=VARCHAR}");
        }
        
        if (record.getCenaDetal() != null) {
            VALUES("CENA_DETAL", "#{cenaDetal,jdbcType=DECIMAL}");
        }
        
        if (record.getCenaLimit() != null) {
            VALUES("CENA_LIMIT", "#{cenaLimit,jdbcType=DECIMAL}");
        }
        
        if (record.getDoplPonadLimit() != null) {
            VALUES("DOPL_PONAD_LIMIT", "#{doplPonadLimit,jdbcType=DECIMAL}");
        }
        
        if (record.getDoplataNfz() != null) {
            VALUES("DOPLATA_NFZ", "#{doplataNfz,jdbcType=DECIMAL}");
        }
        
        if (record.getMaxZaplata() != null) {
            VALUES("MAX_ZAPLATA", "#{maxZaplata,jdbcType=DECIMAL}");
        }
        
        if (record.getDokument() != null) {
            VALUES("DOKUMENT", "#{dokument,jdbcType=VARCHAR}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(BazylOdplatnoscSkladnikCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("ID");
        } else {
            SELECT("ID");
        }
        SELECT("KOD_BAZYL");
        SELECT("UPRAWNIENIE");
        SELECT("SPOSOB_OBLICZENIA");
        SELECT("CENA_DETAL");
        SELECT("CENA_LIMIT");
        SELECT("DOPL_PONAD_LIMIT");
        SELECT("DOPLATA_NFZ");
        SELECT("MAX_ZAPLATA");
        SELECT("DOKUMENT");
        FROM("BAZYL_ODPLATNOSC_SKLADNIK");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        BazylOdplatnoscSkladnik record = (BazylOdplatnoscSkladnik) parameter.get("record");
        BazylOdplatnoscSkladnikCriteria example = (BazylOdplatnoscSkladnikCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("BAZYL_ODPLATNOSC_SKLADNIK");
        
        if (record.getId() != null) {
            SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getKodBazyl() != null) {
            SET("KOD_BAZYL = #{record.kodBazyl,jdbcType=BIGINT}");
        }
        
        if (record.getUprawnienie() != null) {
            SET("UPRAWNIENIE = #{record.uprawnienie,jdbcType=VARCHAR}");
        }
        
        if (record.getSposobObliczenia() != null) {
            SET("SPOSOB_OBLICZENIA = #{record.sposobObliczenia,jdbcType=VARCHAR}");
        }
        
        if (record.getCenaDetal() != null) {
            SET("CENA_DETAL = #{record.cenaDetal,jdbcType=DECIMAL}");
        }
        
        if (record.getCenaLimit() != null) {
            SET("CENA_LIMIT = #{record.cenaLimit,jdbcType=DECIMAL}");
        }
        
        if (record.getDoplPonadLimit() != null) {
            SET("DOPL_PONAD_LIMIT = #{record.doplPonadLimit,jdbcType=DECIMAL}");
        }
        
        if (record.getDoplataNfz() != null) {
            SET("DOPLATA_NFZ = #{record.doplataNfz,jdbcType=DECIMAL}");
        }
        
        if (record.getMaxZaplata() != null) {
            SET("MAX_ZAPLATA = #{record.maxZaplata,jdbcType=DECIMAL}");
        }
        
        if (record.getDokument() != null) {
            SET("DOKUMENT = #{record.dokument,jdbcType=VARCHAR}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("BAZYL_ODPLATNOSC_SKLADNIK");
        
        SET("ID = #{record.id,jdbcType=BIGINT}");
        SET("KOD_BAZYL = #{record.kodBazyl,jdbcType=BIGINT}");
        SET("UPRAWNIENIE = #{record.uprawnienie,jdbcType=VARCHAR}");
        SET("SPOSOB_OBLICZENIA = #{record.sposobObliczenia,jdbcType=VARCHAR}");
        SET("CENA_DETAL = #{record.cenaDetal,jdbcType=DECIMAL}");
        SET("CENA_LIMIT = #{record.cenaLimit,jdbcType=DECIMAL}");
        SET("DOPL_PONAD_LIMIT = #{record.doplPonadLimit,jdbcType=DECIMAL}");
        SET("DOPLATA_NFZ = #{record.doplataNfz,jdbcType=DECIMAL}");
        SET("MAX_ZAPLATA = #{record.maxZaplata,jdbcType=DECIMAL}");
        SET("DOKUMENT = #{record.dokument,jdbcType=VARCHAR}");
        
        BazylOdplatnoscSkladnikCriteria example = (BazylOdplatnoscSkladnikCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String updateByPrimaryKeySelective(BazylOdplatnoscSkladnik record) {
        BEGIN();
        UPDATE("BAZYL_ODPLATNOSC_SKLADNIK");
        
        if (record.getKodBazyl() != null) {
            SET("KOD_BAZYL = #{kodBazyl,jdbcType=BIGINT}");
        }
        
        if (record.getUprawnienie() != null) {
            SET("UPRAWNIENIE = #{uprawnienie,jdbcType=VARCHAR}");
        }
        
        if (record.getSposobObliczenia() != null) {
            SET("SPOSOB_OBLICZENIA = #{sposobObliczenia,jdbcType=VARCHAR}");
        }
        
        if (record.getCenaDetal() != null) {
            SET("CENA_DETAL = #{cenaDetal,jdbcType=DECIMAL}");
        }
        
        if (record.getCenaLimit() != null) {
            SET("CENA_LIMIT = #{cenaLimit,jdbcType=DECIMAL}");
        }
        
        if (record.getDoplPonadLimit() != null) {
            SET("DOPL_PONAD_LIMIT = #{doplPonadLimit,jdbcType=DECIMAL}");
        }
        
        if (record.getDoplataNfz() != null) {
            SET("DOPLATA_NFZ = #{doplataNfz,jdbcType=DECIMAL}");
        }
        
        if (record.getMaxZaplata() != null) {
            SET("MAX_ZAPLATA = #{maxZaplata,jdbcType=DECIMAL}");
        }
        
        if (record.getDokument() != null) {
            SET("DOKUMENT = #{dokument,jdbcType=VARCHAR}");
        }
        
        WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(BazylOdplatnoscSkladnikCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}