package pl.topteam.bazmed.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.bazmed.extension.model.BazylOdplatnosc;
import pl.topteam.bazmed.model_gen.BazylOdplatnoscCriteria.Criteria;
import pl.topteam.bazmed.model_gen.BazylOdplatnoscCriteria.Criterion;
import pl.topteam.bazmed.extension.model.BazylOdplatnoscCriteria;

public class BazylOdplatnoscSqlProvider {

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String countByExample(BazylOdplatnoscCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("BAZYL_ODPLATNOSC");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(BazylOdplatnoscCriteria example) {
        BEGIN();
        DELETE_FROM("BAZYL_ODPLATNOSC");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(BazylOdplatnosc record) {
        BEGIN();
        INSERT_INTO("BAZYL_ODPLATNOSC");
        
        if (record.getKodBazyl() != null) {
            VALUES("KOD_BAZYL", "#{kodBazyl,jdbcType=BIGINT}");
        }
        
        if (record.getKodEan13() != null) {
            VALUES("KOD_EAN13", "#{kodEan13,jdbcType=BIGINT}");
        }
        
        if (record.getAtc() != null) {
            VALUES("ATC", "#{atc,jdbcType=VARCHAR}");
        }
        
        if (record.getKategoriaDost() != null) {
            VALUES("KATEGORIA_DOST", "#{kategoriaDost,jdbcType=VARCHAR}");
        }
        
        if (record.getKodBil() != null) {
            VALUES("KOD_BIL", "#{kodBil,jdbcType=BIGINT}");
        }
        
        if (record.getWlr() != null) {
            VALUES("WLR", "#{wlr,jdbcType=BOOLEAN}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(BazylOdplatnoscCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("KOD_BAZYL");
        } else {
            SELECT("KOD_BAZYL");
        }
        SELECT("KOD_EAN13");
        SELECT("ATC");
        SELECT("KATEGORIA_DOST");
        SELECT("KOD_BIL");
        SELECT("WLR");
        FROM("BAZYL_ODPLATNOSC");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        BazylOdplatnosc record = (BazylOdplatnosc) parameter.get("record");
        BazylOdplatnoscCriteria example = (BazylOdplatnoscCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("BAZYL_ODPLATNOSC");
        
        if (record.getKodBazyl() != null) {
            SET("KOD_BAZYL = #{record.kodBazyl,jdbcType=BIGINT}");
        }
        
        if (record.getKodEan13() != null) {
            SET("KOD_EAN13 = #{record.kodEan13,jdbcType=BIGINT}");
        }
        
        if (record.getAtc() != null) {
            SET("ATC = #{record.atc,jdbcType=VARCHAR}");
        }
        
        if (record.getKategoriaDost() != null) {
            SET("KATEGORIA_DOST = #{record.kategoriaDost,jdbcType=VARCHAR}");
        }
        
        if (record.getKodBil() != null) {
            SET("KOD_BIL = #{record.kodBil,jdbcType=BIGINT}");
        }
        
        if (record.getWlr() != null) {
            SET("WLR = #{record.wlr,jdbcType=BOOLEAN}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("BAZYL_ODPLATNOSC");
        
        SET("KOD_BAZYL = #{record.kodBazyl,jdbcType=BIGINT}");
        SET("KOD_EAN13 = #{record.kodEan13,jdbcType=BIGINT}");
        SET("ATC = #{record.atc,jdbcType=VARCHAR}");
        SET("KATEGORIA_DOST = #{record.kategoriaDost,jdbcType=VARCHAR}");
        SET("KOD_BIL = #{record.kodBil,jdbcType=BIGINT}");
        SET("WLR = #{record.wlr,jdbcType=BOOLEAN}");
        
        BazylOdplatnoscCriteria example = (BazylOdplatnoscCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    public String updateByPrimaryKeySelective(BazylOdplatnosc record) {
        BEGIN();
        UPDATE("BAZYL_ODPLATNOSC");
        
        if (record.getKodEan13() != null) {
            SET("KOD_EAN13 = #{kodEan13,jdbcType=BIGINT}");
        }
        
        if (record.getAtc() != null) {
            SET("ATC = #{atc,jdbcType=VARCHAR}");
        }
        
        if (record.getKategoriaDost() != null) {
            SET("KATEGORIA_DOST = #{kategoriaDost,jdbcType=VARCHAR}");
        }
        
        if (record.getKodBil() != null) {
            SET("KOD_BIL = #{kodBil,jdbcType=BIGINT}");
        }
        
        if (record.getWlr() != null) {
            SET("WLR = #{wlr,jdbcType=BOOLEAN}");
        }
        
        WHERE("KOD_BAZYL = #{kodBazyl,jdbcType=BIGINT}");
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(BazylOdplatnoscCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}