package pl.topteam.bazmed.dao_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.bazmed.extension.model.Icd10;
import pl.topteam.bazmed.extension.model.Icd10Criteria;

public abstract interface Icd10Mapper {
    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @SelectProvider(type=Icd10SqlProvider.class, method="countByExample")
    int countByExample(Icd10Criteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @DeleteProvider(type=Icd10SqlProvider.class, method="deleteByExample")
    int deleteByExample(Icd10Criteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Delete({
        "delete from ICD_10",
        "where KOD = #{kod,jdbcType=VARCHAR}"
    })
    int deleteByPrimaryKey(String kod);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Insert({
        "insert into ICD_10 (KOD, NAZWA, ",
        "OPIS)",
        "values (#{kod,jdbcType=VARCHAR}, #{nazwa,jdbcType=VARCHAR}, ",
        "#{opis,jdbcType=VARCHAR})"
    })
    int insert(Icd10 record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    int mergeInto(Icd10 record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @InsertProvider(type=Icd10SqlProvider.class, method="insertSelective")
    int insertSelective(Icd10 record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @SelectProvider(type=Icd10SqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="KOD", property="kod", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPIS", property="opis", jdbcType=JdbcType.VARCHAR)
    })
    List<Icd10> selectByExampleWithRowbounds(Icd10Criteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @SelectProvider(type=Icd10SqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="KOD", property="kod", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPIS", property="opis", jdbcType=JdbcType.VARCHAR)
    })
    List<Icd10> selectByExample(Icd10Criteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Select({
        "select",
        "KOD, NAZWA, OPIS",
        "from ICD_10",
        "where KOD = #{kod,jdbcType=VARCHAR}"
    })
    @Results({
        @Result(column="KOD", property="kod", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPIS", property="opis", jdbcType=JdbcType.VARCHAR)
    })
    Icd10 selectByPrimaryKey(String kod);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @UpdateProvider(type=Icd10SqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Icd10 record, @Param("example") Icd10Criteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @UpdateProvider(type=Icd10SqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Icd10 record, @Param("example") Icd10Criteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @UpdateProvider(type=Icd10SqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Icd10 record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Update({
        "update ICD_10",
        "set NAZWA = #{nazwa,jdbcType=VARCHAR},",
          "OPIS = #{opis,jdbcType=VARCHAR}",
        "where KOD = #{kod,jdbcType=VARCHAR}"
    })
    int updateByPrimaryKey(Icd10 record);
}