package pl.topteam.bazmed.dao_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.bazmed.extension.model.WyrobMedyczny;
import pl.topteam.bazmed.extension.model.WyrobMedycznyCriteria;

public abstract interface WyrobMedycznyMapper {
    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @SelectProvider(type=WyrobMedycznySqlProvider.class, method="countByExample")
    int countByExample(WyrobMedycznyCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @DeleteProvider(type=WyrobMedycznySqlProvider.class, method="deleteByExample")
    int deleteByExample(WyrobMedycznyCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Delete({
        "delete from WYROB_MEDYCZNY",
        "where KOD = #{kod,jdbcType=VARCHAR}"
    })
    int deleteByPrimaryKey(String kod);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Insert({
        "insert into WYROB_MEDYCZNY (KOD, OPIS, ",
        "TYP)",
        "values (#{kod,jdbcType=VARCHAR}, #{opis,jdbcType=VARCHAR}, ",
        "#{typ,jdbcType=VARCHAR})"
    })
    int insert(WyrobMedyczny record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    int mergeInto(WyrobMedyczny record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @InsertProvider(type=WyrobMedycznySqlProvider.class, method="insertSelective")
    int insertSelective(WyrobMedyczny record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @SelectProvider(type=WyrobMedycznySqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="KOD", property="kod", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="OPIS", property="opis", jdbcType=JdbcType.VARCHAR),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR)
    })
    List<WyrobMedyczny> selectByExampleWithRowbounds(WyrobMedycznyCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @SelectProvider(type=WyrobMedycznySqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="KOD", property="kod", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="OPIS", property="opis", jdbcType=JdbcType.VARCHAR),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR)
    })
    List<WyrobMedyczny> selectByExample(WyrobMedycznyCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Select({
        "select",
        "KOD, OPIS, TYP",
        "from WYROB_MEDYCZNY",
        "where KOD = #{kod,jdbcType=VARCHAR}"
    })
    @Results({
        @Result(column="KOD", property="kod", jdbcType=JdbcType.VARCHAR, id=true),
        @Result(column="OPIS", property="opis", jdbcType=JdbcType.VARCHAR),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR)
    })
    WyrobMedyczny selectByPrimaryKey(String kod);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @UpdateProvider(type=WyrobMedycznySqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") WyrobMedyczny record, @Param("example") WyrobMedycznyCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @UpdateProvider(type=WyrobMedycznySqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") WyrobMedyczny record, @Param("example") WyrobMedycznyCriteria example);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @UpdateProvider(type=WyrobMedycznySqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(WyrobMedyczny record);

    /**
     * @mbggenerated 2013-11-05 10:33:09
     */
    @Update({
        "update WYROB_MEDYCZNY",
        "set OPIS = #{opis,jdbcType=VARCHAR},",
          "TYP = #{typ,jdbcType=VARCHAR}",
        "where KOD = #{kod,jdbcType=VARCHAR}"
    })
    int updateByPrimaryKey(WyrobMedyczny record);
}