/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.bazmed.dao_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SqlBuilder;
import pl.topteam.bazmed.extension.model.Icd10;
import pl.topteam.bazmed.extension.model.Icd10Criteria;
import pl.topteam.bazmed.model_gen.Icd10Criteria;

public class Icd10SqlProvider {
    public String countByExample(Icd10Criteria example) {
        SqlBuilder.BEGIN();
        SqlBuilder.SELECT((String)"count(*)");
        SqlBuilder.FROM((String)"ICD_10");
        this.applyWhere(example, false);
        return SqlBuilder.SQL();
    }

    public String deleteByExample(Icd10Criteria example) {
        SqlBuilder.BEGIN();
        SqlBuilder.DELETE_FROM((String)"ICD_10");
        this.applyWhere(example, false);
        return SqlBuilder.SQL();
    }

    public String insertSelective(Icd10 record) {
        SqlBuilder.BEGIN();
        SqlBuilder.INSERT_INTO((String)"ICD_10");
        if (record.getKod() != null) {
            SqlBuilder.VALUES((String)"KOD", (String)"#{kod,jdbcType=VARCHAR}");
        }
        if (record.getNazwa() != null) {
            SqlBuilder.VALUES((String)"NAZWA", (String)"#{nazwa,jdbcType=VARCHAR}");
        }
        if (record.getOpis() != null) {
            SqlBuilder.VALUES((String)"OPIS", (String)"#{opis,jdbcType=VARCHAR}");
        }
        return SqlBuilder.SQL();
    }

    public String selectByExample(Icd10Criteria example) {
        SqlBuilder.BEGIN();
        if (example != null && example.isDistinct()) {
            SqlBuilder.SELECT_DISTINCT((String)"KOD");
        } else {
            SqlBuilder.SELECT((String)"KOD");
        }
        SqlBuilder.SELECT((String)"NAZWA");
        SqlBuilder.SELECT((String)"OPIS");
        SqlBuilder.FROM((String)"ICD_10");
        this.applyWhere(example, false);
        if (example != null && example.getOrderByClause() != null) {
            SqlBuilder.ORDER_BY((String)example.getOrderByClause());
        }
        return SqlBuilder.SQL();
    }

    public String updateByExampleSelective(Map<String, Object> parameter) {
        Icd10 record = (Icd10)parameter.get("record");
        Icd10Criteria example = (Icd10Criteria)parameter.get("example");
        SqlBuilder.BEGIN();
        SqlBuilder.UPDATE((String)"ICD_10");
        if (record.getKod() != null) {
            SqlBuilder.SET((String)"KOD = #{record.kod,jdbcType=VARCHAR}");
        }
        if (record.getNazwa() != null) {
            SqlBuilder.SET((String)"NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        }
        if (record.getOpis() != null) {
            SqlBuilder.SET((String)"OPIS = #{record.opis,jdbcType=VARCHAR}");
        }
        this.applyWhere(example, true);
        return SqlBuilder.SQL();
    }

    public String updateByExample(Map<String, Object> parameter) {
        SqlBuilder.BEGIN();
        SqlBuilder.UPDATE((String)"ICD_10");
        SqlBuilder.SET((String)"KOD = #{record.kod,jdbcType=VARCHAR}");
        SqlBuilder.SET((String)"NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        SqlBuilder.SET((String)"OPIS = #{record.opis,jdbcType=VARCHAR}");
        Icd10Criteria example = (Icd10Criteria)parameter.get("example");
        this.applyWhere(example, true);
        return SqlBuilder.SQL();
    }

    public String updateByPrimaryKeySelective(Icd10 record) {
        SqlBuilder.BEGIN();
        SqlBuilder.UPDATE((String)"ICD_10");
        if (record.getNazwa() != null) {
            SqlBuilder.SET((String)"NAZWA = #{nazwa,jdbcType=VARCHAR}");
        }
        if (record.getOpis() != null) {
            SqlBuilder.SET((String)"OPIS = #{opis,jdbcType=VARCHAR}");
        }
        SqlBuilder.WHERE((String)"KOD = #{kod,jdbcType=VARCHAR}");
        return SqlBuilder.SQL();
    }

    protected void applyWhere(Icd10Criteria example, boolean includeExamplePhrase) {
        String parmPhrase3_th;
        String parmPhrase3;
        String parmPhrase2_th;
        String parmPhrase2;
        String parmPhrase1_th;
        String parmPhrase1;
        if (example == null) {
            return;
        }
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        StringBuilder sb = new StringBuilder();
        List oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); ++i) {
            Icd10Criteria.Criteria criteria = (Icd10Criteria.Criteria)oredCriteria.get(i);
            if (!criteria.isValid()) continue;
            if (firstCriteria) {
                firstCriteria = false;
            } else {
                sb.append(" or ");
            }
            sb.append('(');
            List criterions = criteria.getAllCriteria();
            boolean firstCriterion = true;
            for (int j = 0; j < criterions.size(); ++j) {
                Icd10Criteria.Criterion criterion = (Icd10Criteria.Criterion)criterions.get(j);
                if (firstCriterion) {
                    firstCriterion = false;
                } else {
                    sb.append(" and ");
                }
                if (criterion.isNoValue()) {
                    sb.append(criterion.getCondition());
                    continue;
                }
                if (criterion.isSingleValue()) {
                    if (criterion.getTypeHandler() == null) {
                        sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        continue;
                    }
                    sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j, criterion.getTypeHandler()));
                    continue;
                }
                if (criterion.isBetweenValue()) {
                    if (criterion.getTypeHandler() == null) {
                        sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        continue;
                    }
                    sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                    continue;
                }
                if (!criterion.isListValue()) continue;
                sb.append(criterion.getCondition());
                sb.append(" (");
                List listItems = (List)criterion.getValue();
                boolean comma = false;
                for (int k = 0; k < listItems.size(); ++k) {
                    if (comma) {
                        sb.append(", ");
                    } else {
                        comma = true;
                    }
                    if (criterion.getTypeHandler() == null) {
                        sb.append(String.format(parmPhrase3, i, j, k));
                        continue;
                    }
                    sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                }
                sb.append(')');
            }
            sb.append(')');
        }
        if (sb.length() > 0) {
            SqlBuilder.WHERE((String)sb.toString());
        }
    }
}

