/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.bazmed.db.generator;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import org.h2.jdbcx.JdbcConnectionPool;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import pl.topteam.bazmed.db.ScriptRepositoryUtils;
import pl.topteam.bazmed.db.generator.AbstractDatabaseCreationTest;

@RunWith(value=Parameterized.class)
public class CreateDatabaseTest
extends AbstractDatabaseCreationTest {
    public CreateDatabaseTest(Path skrypt) {
        super(skrypt);
    }

    private static Path database() {
        return CreateDatabaseTest.target().resolve("bazmed.h2.db");
    }

    @BeforeClass
    public static void setupNewDatabase() {
        File database = CreateDatabaseTest.database().toFile();
        if (database.exists()) {
            database.delete();
        }
        cp = JdbcConnectionPool.create((String)String.format("jdbc:h2:split:%s", CreateDatabaseTest.database().toString().replace(".h2.db", "")), (String)"sysdba", (String)"masterkey");
    }

    public static Collection<Path[]> schemaScripts() {
        return Arrays.asList({ScriptRepositoryUtils.bazmed_schema_extension().resolve("ustawienia.ddl")}, {ScriptRepositoryUtils.bazmed_schema().resolve("schema.ddl")}, {ScriptRepositoryUtils.bazmed_schema_extension().resolve("bazyl_indeksy.ddl")}, {ScriptRepositoryUtils.bazmed_schema_extension().resolve("icd10_sp_indeksy.ddl")}, {ScriptRepositoryUtils.bazmed_schema_extension().resolve("bazyl_widoki.ddl")});
    }

    public static Collection<Path[]> dataScripts() {
        return Arrays.asList(new Path[][]{{ScriptRepositoryUtils.bazmed_data().resolve("bazyl_poprawki_koncowe.sql")}});
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Path[]> parameters() {
        return new ImmutableList.Builder().addAll(CreateDatabaseTest.schemaScripts()).addAll(CreateDatabaseTest.dataScripts()).build();
    }
}

