/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.bazmed.model.generator;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.topteam.bazmed.model.generator.GenerateModelTest;
import pl.topteam.bazmed.model.generator.SchemaUtils;

public abstract class AbstractGenerateTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractGenerateTest.class);
    @Rule
    public TemporaryFolder tmpWorkingDir = new TemporaryFolder();
    protected List<String> warnings;

    @Before
    public void clearWarnings() {
        if (this.warnings != null) {
            this.warnings.clear();
        } else {
            this.warnings = Lists.newArrayList();
        }
    }

    @After
    public void checkWarnings() {
        this.filterWarnings();
        if (!this.warnings.isEmpty()) {
            log.error(Joiner.on((String)"\n").join(this.warnings));
            throw new RuntimeException("There are warnings for model generation");
        }
    }

    protected String processConfig(Reader configTemplateReader, Map<String, Object> properties) {
        StringWriter writer = new StringWriter();
        Velocity.evaluate((Context)new VelocityContext(properties), (Writer)writer, (String)GenerateModelTest.class.getCanonicalName(), (Reader)configTemplateReader);
        return writer.toString();
    }

    protected void filterWarnings() {
        this.warnings = FluentIterable.from(this.warnings).filter((Predicate)new Predicate<String>(){

            public boolean apply(String w) {
                return !w.contains("MyBatis Generator will generate the property");
            }
        }).toList();
        this.warnings = FluentIterable.from(this.warnings).filter((Predicate)new Predicate<String>(){

            public boolean apply(String w) {
                return !w.contains("was overwritten");
            }
        }).toList();
        this.warnings = FluentIterable.from(this.warnings).filter((Predicate)new Predicate<String>(){

            public boolean apply(String w) {
                return !w.startsWith("Root class pl.topteam.dps.model.main_gen.GenericDPSObject");
            }
        }).toList();
        this.warnings = FluentIterable.from(this.warnings).filter((Predicate)new Predicate<String>(){

            public boolean apply(String w) {
                return !w.startsWith("Root class pl.topteam.utils.stripes.model.GenericUser");
            }
        }).toList();
    }

    protected void generateModel(Configuration config) throws SQLException, IOException, InterruptedException, InvalidConfigurationException {
        DefaultShellCallback callback = new DefaultShellCallback(true);
        MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, (ShellCallback)callback, this.warnings);
        myBatisGenerator.generate(new ProgressCallback(){

            public void introspectionStarted(int totalTasks) {
                log.info("MBG - introspectionStarted");
            }

            public void generationStarted(int totalTasks) {
                log.info("MBG - generationStarted: " + totalTasks);
            }

            public void saveStarted(int totalTasks) {
            }

            public void startTask(String taskName) {
                log.info(taskName);
            }

            public void done() {
                log.info("MBG - done");
            }

            public void checkCancel() throws InterruptedException {
            }
        });
    }

    protected void checkGeneratorConfiguration(Connection conn, Set<String> tablesFromConfiguration) throws SQLException {
        ImmutableSet tablesFromDatabase = ImmutableSet.copyOf(SchemaUtils.getTableNames(conn));
        ImmutableSet difference = new ImmutableSet.Builder().addAll((Iterable)Sets.difference(tablesFromConfiguration, (Set)tablesFromDatabase)).addAll((Iterable)Sets.difference((Set)tablesFromDatabase, tablesFromConfiguration)).build();
        if (!difference.isEmpty()) {
            log.info(String.format("Tables to check: %s", Joiner.on((String)",").join((Iterable)difference)));
            ImmutableSet intersection = Sets.intersection(tablesFromConfiguration, (Set)tablesFromDatabase).immutableCopy();
            difference = Sets.difference(tablesFromConfiguration, (Set)intersection).immutableCopy();
            log.info(String.format("Remove from configuration: %s", !difference.isEmpty() ? Joiner.on((String)",").join((Iterable)difference) : "nothing"));
            difference = Sets.difference((Set)tablesFromDatabase, (Set)intersection).immutableCopy();
            log.info(String.format("Add to configuration: %s", !difference.isEmpty() ? Joiner.on((String)",").join((Iterable)difference) : "--nothing--"));
            if (!difference.isEmpty()) {
                log.info(String.format("\n%s", Joiner.on((String)"\n").join((Iterable)FluentIterable.from((Iterable)difference).transform((Function)new Function<String, String>(){

                    public String apply(String tableName) {
                        return String.format("<table tableName=\"%s\">\n</table>", tableName);
                    }
                }))));
            }
            throw new RuntimeException("Check configuration file for differences config<->database!");
        }
    }
}

