/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.database.firebird.gbak;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.xml.DOMConfigurator;
import pl.topteam.database.firebird.gbak.GBAK;
import pl.topteam.database.firebird.gbak.GBAKBackupStreamWrapper;
import pl.topteam.database.firebird.gbak.GBAKCommand;
import pl.topteam.database.firebird.gbak.GBAKParameterEnum;
import pl.topteam.database.firebird.util.FirebirdJDBCURLResolver;
import pl.topteam.database.firebird.util.FirebirdUtils;
import pl.topteam.database.firebird.util.FirebirdUtilsBuilder;

public final class BakcupRestoreDatabase {
    private String gbakPath;
    private String gbakOutput;

    public String getGbakPath() {
        return this.gbakPath;
    }

    public void setGbakPath(String gbakPath) {
        this.gbakPath = gbakPath;
    }

    public String getGbakOutput() {
        return this.gbakOutput;
    }

    public void backupDatabase(String urlFrom, String urlTo, Boolean czyKompresja) throws Exception {
        GBAK gbak = new GBAK();
        gbak.setPath(this.getGbakPath());
        GBAKBackupStreamWrapper backupStreamWrapper = new GBAKBackupStreamWrapper();
        gbak.addObserver(backupStreamWrapper);
        if (czyKompresja == null || !czyKompresja.booleanValue()) {
            GBAKCommand komendaBrakuKompresji = new GBAKCommand(GBAKParameterEnum.NO_DATA_COMPRESSION);
            gbak.addCommandLineOption(komendaBrakuKompresji);
        }
        GBAKCommand komendaRaportowania = new GBAKCommand(GBAKParameterEnum.REPORT_EACH_ACTION_TAKEN);
        gbak.addCommandLineOption(komendaRaportowania);
        GBAKCommand komendaBackupu = new GBAKCommand(GBAKParameterEnum.BACKUP_DATABASE_TO_FILE, String.valueOf(urlFrom) + " " + urlTo);
        gbak.addCommandLineOption(komendaBackupu);
        GBAKCommand komendaSpecUsera = new GBAKCommand(GBAKParameterEnum.FIREBIRD_USER_NAME, "sysdba");
        gbak.addCommandLineOption(komendaSpecUsera);
        GBAKCommand komendaSpecHasla = new GBAKCommand(GBAKParameterEnum.FIREBIRD_PASSWORD, "masterkey");
        gbak.addCommandLineOption(komendaSpecHasla);
        Thread t = new Thread(gbak);
        t.start();
        t.join();
        this.gbakOutput = backupStreamWrapper.toString();
    }

    public void restoreDatabase(String urlFrom, String urlTo, Boolean czyKompresja) throws Exception {
        GBAK gbak = new GBAK();
        gbak.setPath(this.getGbakPath());
        GBAKBackupStreamWrapper backupStreamWrapper = new GBAKBackupStreamWrapper();
        gbak.addObserver(backupStreamWrapper);
        if (czyKompresja == null || !czyKompresja.booleanValue()) {
            GBAKCommand komendaBrakuKompresji = new GBAKCommand(GBAKParameterEnum.NO_DATA_COMPRESSION);
            gbak.addCommandLineOption(komendaBrakuKompresji);
        }
        GBAKCommand komendaRaportowania = new GBAKCommand(GBAKParameterEnum.REPORT_EACH_ACTION_TAKEN);
        gbak.addCommandLineOption(komendaRaportowania);
        GBAKCommand komendaRestore = new GBAKCommand(GBAKParameterEnum.CREATE_DATABASE_FROM_BACKUP_FILE, String.valueOf(urlFrom) + " " + urlTo);
        gbak.addCommandLineOption(komendaRestore);
        GBAKCommand komendaSpecUsera = new GBAKCommand(GBAKParameterEnum.FIREBIRD_USER_NAME, "sysdba");
        gbak.addCommandLineOption(komendaSpecUsera);
        GBAKCommand komendaSpecHasla = new GBAKCommand(GBAKParameterEnum.FIREBIRD_PASSWORD, "masterkey");
        gbak.addCommandLineOption(komendaSpecHasla);
        Thread t = new Thread(gbak);
        t.start();
        t.join();
        this.gbakOutput = backupStreamWrapper.toString();
    }

    public void restoreWithReplaceDatabase(String urlFrom, String urlTo, Boolean czyKompresja) throws Exception {
        GBAK gbak = new GBAK();
        gbak.setPath(this.getGbakPath());
        GBAKBackupStreamWrapper backupStreamWrapper = new GBAKBackupStreamWrapper();
        gbak.addObserver(backupStreamWrapper);
        if (czyKompresja == null || !czyKompresja.booleanValue()) {
            GBAKCommand komendaBrakuKompresji = new GBAKCommand(GBAKParameterEnum.NO_DATA_COMPRESSION);
            gbak.addCommandLineOption(komendaBrakuKompresji);
        }
        GBAKCommand komendaRaportowania = new GBAKCommand(GBAKParameterEnum.REPORT_EACH_ACTION_TAKEN);
        gbak.addCommandLineOption(komendaRaportowania);
        GBAKCommand komendaRestore = new GBAKCommand(GBAKParameterEnum.CREATE_DATABASE_FROM_BACKUP_FILE, String.valueOf(urlFrom) + " " + urlTo);
        gbak.addCommandLineOption(komendaRestore);
        GBAKCommand komendaSpecUsera = new GBAKCommand(GBAKParameterEnum.FIREBIRD_USER_NAME, "sysdba");
        gbak.addCommandLineOption(komendaSpecUsera);
        GBAKCommand komendaSpecHasla = new GBAKCommand(GBAKParameterEnum.FIREBIRD_PASSWORD, "masterkey");
        gbak.addCommandLineOption(komendaSpecHasla);
        Thread t = new Thread(gbak);
        t.start();
        t.join();
        this.gbakOutput = backupStreamWrapper.toString();
    }

    public static void main(String[] args) throws Exception {
        DOMConfigurator.configure((String)(String.valueOf(System.getProperty("user.dir")) + "\\log4jconfig.xml"));
        Properties databaseProp = new Properties();
        File plik = new File(String.valueOf(System.getProperty("user.dir")) + "\\db.properties");
        databaseProp.load(new FileInputStream(plik));
        FirebirdJDBCURLResolver firebirdURLResolver = new FirebirdJDBCURLResolver(databaseProp.getProperty("url"));
        FirebirdUtils firebirdUtils = FirebirdUtilsBuilder.getFirebirdUtils();
        System.out.println("GBAK PATH: " + firebirdUtils.getGBAKPath());
        System.out.println("HOST: " + firebirdURLResolver.getHost());
        System.out.println("PORT: " + firebirdURLResolver.getPort());
        System.out.println("SCIEZKA: " + firebirdURLResolver.getDatabasePath());
        BakcupRestoreDatabase bakcupDatabase = new BakcupRestoreDatabase();
        bakcupDatabase.setGbakPath(firebirdUtils.getGBAKPath());
        System.out.println("");
        bakcupDatabase.backupDatabase("192.168.1.9:C:\\topteam\\alimenty_baza\\adresy.fdb", "C:\\tomek_alimenty_baza.fbk", true);
    }
}

