/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.database.firebird.gbak;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.xml.DOMConfigurator;
import pl.topteam.database.firebird.gbak.FirebirdVersionProcessStreamWrapper;
import pl.topteam.database.firebird.gbak.GBAK;
import pl.topteam.database.firebird.gbak.GBAKCommand;
import pl.topteam.database.firebird.gbak.GBAKParameterEnum;
import pl.topteam.database.firebird.util.FirebirdUtils;
import pl.topteam.database.firebird.util.FirebirdUtilsBuilder;

public final class FirebirdVersion {
    private String gbakPath;
    private String firebirdVersion;

    public String getGbakPath() {
        return this.gbakPath;
    }

    public void setGbakPath(String gbakPath) {
        this.gbakPath = gbakPath;
    }

    public String getFirebirdVersion() throws Exception {
        if (StringUtils.isEmpty((String)this.firebirdVersion)) {
            GBAK gbak = new GBAK();
            gbak.setPath(this.getGbakPath());
            FirebirdVersionProcessStreamWrapper versionStreamWrapper = new FirebirdVersionProcessStreamWrapper();
            gbak.addObserver(versionStreamWrapper);
            GBAKCommand komendaRaportowania = new GBAKCommand(GBAKParameterEnum.REPORT_EACH_ACTION_TAKEN);
            gbak.addCommandLineOption(komendaRaportowania);
            GBAKCommand komendaWersji = new GBAKCommand(GBAKParameterEnum.PRINT_VERSION);
            gbak.addCommandLineOption(komendaWersji);
            Thread t = new Thread(gbak);
            t.start();
            t.join();
            this.firebirdVersion = versionStreamWrapper.getFirebirdVersion();
        }
        return this.firebirdVersion;
    }

    public static void main(String[] args) throws Exception {
        DOMConfigurator.configure((String)(String.valueOf(System.getProperty("user.dir")) + "\\log4jconfig.xml"));
        FirebirdUtils firebirdUtils = FirebirdUtilsBuilder.getFirebirdUtils();
        System.out.println("GBAK PATH: " + firebirdUtils.getGBAKPath());
        FirebirdVersion firebirdVersion = new FirebirdVersion();
        firebirdVersion.setGbakPath(firebirdUtils.getGBAKPath());
        System.out.println(firebirdVersion.getFirebirdVersion());
    }
}

