/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.database.firebird.gbak;

import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import org.apache.log4j.Logger;
import pl.topteam.database.firebird.gbak.GBAKCommand;
import pl.topteam.database.firebird.util.ProcessStreamWrapper;

final class GBAK
implements Runnable {
    Logger log = Logger.getLogger(GBAK.class);
    private String path;
    private List<GBAKCommand> listaOpcji = new ArrayList<GBAKCommand>();
    private List<Observer> listaObserwatorow = new ArrayList<Observer>();
    private Integer kodWyjscia;
    private Exception bladProcesuGBAK;

    public void addCommandLineOption(GBAKCommand gbakCommand) {
        if (gbakCommand == null) {
            throw new IllegalArgumentException("Parametr gbakCommand jest wymagany");
        }
        if (!gbakCommand.isValid()) {
            throw new IllegalArgumentException("Nie wyspecyfikowano wszystkich parametr\u00f3w dla opcji: " + (Object)((Object)gbakCommand.getParametrPrefix()));
        }
        this.listaOpcji.add(gbakCommand);
    }

    public void addObserver(Observer obserwujacy) {
        this.listaObserwatorow.add(obserwujacy);
    }

    public void deleteObserver(Observer obserwujacy) {
        this.listaObserwatorow.remove(obserwujacy);
    }

    public void resetPreviousExecute() {
        this.listaObserwatorow.clear();
        this.listaOpcji.clear();
    }

    public void run() {
        this.bladProcesuGBAK = null;
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(this.toString());
            ProcessStreamWrapper errorGobbler = new ProcessStreamWrapper(proc.getErrorStream());
            ProcessStreamWrapper outputGobbler = new ProcessStreamWrapper(proc.getInputStream());
            for (Observer observer : this.listaObserwatorow) {
                outputGobbler.addObserver(observer);
                errorGobbler.addObserver(observer);
            }
            errorGobbler.start();
            outputGobbler.start();
            this.kodWyjscia = proc.waitFor();
        }
        catch (Exception ex) {
            this.bladProcesuGBAK = ex;
            this.log.info((Object)("Proces backupu bazy Firebird zako\u0144czy\u0142 prac\u0119 z b\u0142\u0119dem: " + ex));
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getKodWyjscia() {
        return this.kodWyjscia;
    }

    public Exception getBladProcesuGBAK() {
        return this.bladProcesuGBAK;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.path);
        int i = 0;
        while (i < this.listaOpcji.size()) {
            sb.append(" " + this.listaOpcji.get(i).toString());
            ++i;
        }
        return sb.toString();
    }
}

