/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.database.firebird.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirebirdJDBCURLResolver {
    private String firebirdDatabaseURL;
    private String host;
    private String port;
    private String databasePath;
    private Map<String, String> parameterMap;

    public FirebirdJDBCURLResolver(String firebirdDatabaseURL) {
        this.firebirdDatabaseURL = firebirdDatabaseURL;
        this.parameterMap = new HashMap<String, String>();
        this.wrapFirebirdJDBCURL(firebirdDatabaseURL);
    }

    private void wrapFirebirdJDBCURL(String firebirdDatabaseURL) {
        if (firebirdDatabaseURL != null) {
            String[] glownyPodzial = firebirdDatabaseURL.split(":");
            this.host = glownyPodzial[2].split("/")[0];
            this.port = glownyPodzial[2].split("/")[1];
            StringBuffer databasePathBuf = new StringBuffer();
            int i = 3;
            while (i < glownyPodzial.length) {
                if (i == glownyPodzial.length - 1) {
                    databasePathBuf.append(glownyPodzial[i]);
                } else {
                    databasePathBuf.append(String.valueOf(glownyPodzial[i]) + ":");
                }
                ++i;
            }
            this.databasePath = databasePathBuf.toString().split("\\?")[0];
            String parameter = databasePathBuf.toString().split("\\?")[1];
            if (StringUtils.isNotEmpty((String)parameter)) {
                String[] rozdzParametry = parameter.split("&");
                String[] tmpParam = null;
                String[] stringArray = rozdzParametry;
                int n = rozdzParametry.length;
                int n2 = 0;
                while (n2 < n) {
                    String parametr = stringArray[n2];
                    tmpParam = parametr.split("=");
                    this.parameterMap.put(tmpParam[0], tmpParam[1]);
                    ++n2;
                }
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDatabasePath() {
        return this.databasePath;
    }

    public void setDatabasePath(String databasePath) {
        this.databasePath = databasePath;
    }

    public String getFirebirdDatabaseURL() {
        if (this.firebirdDatabaseURL == null || this.firebirdDatabaseURL.trim().length() == 0) {
            this.firebirdDatabaseURL = "jdbc:firebirdsql:" + this.host + "/" + this.port + ":" + this.databasePath;
        }
        return this.firebirdDatabaseURL;
    }

    public void setFirebirdDatabaseURL(String firebirdDatabaseURL) {
        this.firebirdDatabaseURL = firebirdDatabaseURL;
        this.wrapFirebirdJDBCURL(firebirdDatabaseURL);
    }

    public Collection<String> getURLParametersName() {
        return this.parameterMap.keySet();
    }

    public String getURLParameter(String parameterName) {
        return this.parameterMap.get(parameterName);
    }

    public void clearAllURLParameters() {
        this.parameterMap.clear();
    }
}

