package pl.topteam.dps.dao.main;

import java.util.List;
import java.util.Map;

import pl.topteam.dps.model.main.DecyzjaOOdplatnosci;

public interface DecyzjaOOdplatnosciMapper extends pl.topteam.dps.dao.main_gen.DecyzjaOOdplatnosciMapper {

	Integer filtrDecyzjiOOdplatnosciIleWierszy(Map<String, Object> filtr);
	/**
	 * Zwraca listę decyzji o odplatności dla wskazanego filtru posortowaną 
	 * domyślnie(wg członków rodziny, typu i daty wydania)
	 * 
	 * @param filtr
	 * @return
	 */
	List<DecyzjaOOdplatnosci> filtrDecyzjiOOdplatnosci(Map<String, Object> filtr);
	
	Integer filtrDecyzjiOAlimentacjiIleWierszy(Map<String, Object> filtr);
	/**
	 * Zwraca listę decyzji o alimentacji dla wskazanego filtru posortowaną 
	 * domyślnie(wg członków rodziny, typu i daty wydania)
	 * 
	 * @param filtr
	 * @return
	 */
	List<DecyzjaOOdplatnosci> filtrDecyzjiOAlimentacji(Map<String, Object> filtr);
	
	/**
	 * Zwraca listę (po jednej dla członka o ile istnieje) zobowiązań alimentacyjnych
	 * mapowanych na decyzję o odpłatnosci dla wskazanego filtru,
	 * posortowanych domyślnie(wg członków rodziny, typu i daty wydania)
	 * 
	 * @param filtr
	 * @return
	 */
	List<DecyzjaOOdplatnosci> filtrSkladnikowAlimentacji(Map<String, Object> filtr);
	
	/**
	 * Zwraca liczbę aktualnych decyzji (z najnowszą datą wydania) o alimentacji oraz odpłatności.
	 */
	Integer filtrAktualnychDecyzjiIleWierszy(Map<String, Object> filtr);
	
	/**
	 * Zwraca listę aktualnych decyzji (z najnowszą datą wydania) o alimentacji oraz odpłatności.
	 */
	List<DecyzjaOOdplatnosci> filtrAktualnychDecyzji(Map<String, Object> filtr);
}
