package pl.topteam.dps.dao.main;

import java.util.List;
import java.util.Map;

import pl.topteam.dps.model.main.Lek;

public interface LekMapper extends pl.topteam.dps.dao.main_gen.LekMapper {
	
	/**
	 * Wybiera lek, którego nazwa został ustalona za pomocą {@link LekiAction.uniqNazwaLeku(Lek lek)}.
	 * Metoda powstała na potrzeby przenoszenia leków z bazy BAZYL do bazy DPSu.
	 * 
	 * @param nazwa
	 * @return
	 */
	Lek selectByUniqNazwa(String nazwa);
	
	/**
	 * 
	 * @param idDawkowania
	 * @return
	 */
	List<Lek> selectByDawkowanieId(Long idDawkowania);
	
	/**
	 * Znajduje leki z ostatniego ustalonego dawkowania.
	 * 
	 * @param isOsoby
	 * @return
	 */
	List<Lek> selectAktualneLekiByOsobaId(Long isOsoby);
	
	/**
	 * Znajduje wszystkie leki przechowywane w magazynie podręcznym mieszkańca oraz
	 * te ustalone poprzez dawkowanie.
	 * 
	 * @param idEwidencji identyfikator wpisu ewidencyjnego osoby
	 * @return
	 */
	List<Lek> selectLekiByEwidencjaId(Long idEwidencji);
	
	/**
	 * Znajduje leki, które występują na dawkowaniach wg określonej
	 * daty oraz mieszkańca. Wynik zależy oczywiście od zawartości filtru.
	 * 
	 * @param filtr
	 * @return
	 */
	List<Lek> selectLekiNaRecepty(Map<String, Object> filtr);
	
	/**
	 * Leki, które zostały wstawione na wskazaną receptę.
	 * 
	 * @param idRecepty
	 * @return
	 */
	List<Lek> selectByReceptaId(Long idRecepty);
	
	/**
	 * Ile rekordów zrwóci zapytanie filtrujące leki
	 * 
	 * @param filtr
	 * @return
	 */
	Integer filtrLekowIleWierszy(Map<String, Object> filtr);
	
	/**
	 * Zwraca leki pasujące do wskazanego filtra.
	 * 
	 * @param filtr
	 * @return
	 */
	List<Lek> filtrLekow(Map<String, Object> filtr);
}
