package pl.topteam.dps.dao.main;

import java.util.List;
import java.util.Map;

import pl.topteam.dps.model.main.Osoba;

public interface OsobaMapper extends pl.topteam.dps.dao.main_gen.OsobaMapper {

	/**
	 * Filtr liczby osób zewidencjonowanych(osoby oczekujące oraz mieszkańcy) w programie (pełny podgląd osób)
	 */
	Integer filtrOsobIleWierszy(Map<String, Object> filtr);

	/**
	 * Filtr osób zewidencjonowanych w programie (pełny podgląd osób)
	 */
	List<Osoba> filtrOsob(Map<String, Object> filtr);
	
	/**
	 * Filtr liczby osób zewidencjonowanych(osoby oczekujące oraz mieszkańcy) aktualnie w programie (podgląd tylko danych osobowych).
	 * Uwzględnia aktualny status osoby.
	 */
	Integer filtrProstyOsobIleWierszy(Map<String, Object> filtr);

	/**
	 * Filtr osób zewidencjonowanych(osoby oczekujące oraz mieszkańcy) w aktualnie programie (podgląd tylko danych osobowych)
	 * Uwzględnia aktualny status osoby.
	 */
	List<Osoba> filtrProstyOsob(Map<String, Object> filtr);
	
	/**
	 * Filtr liczby wszystkich osób
	 */
	Integer filtrWszystkichOsobIleWierszy(Map<String, Object> filtr);

	/**
	 * Filtr wszystkich osób
	 */
	List<Osoba> filtrWszystkichOsob(Map<String, Object> filtr);
	
	/**
	 * Dla potrzeb podejrzenia szerokiej gamy danych nt. osoby.
	 * Zapytanie podpięte zawiera dużą liczbę zapytań typu lazy-loading.
	 * 
	 * Nie warto stosować na szeroką skalę
	 * @param idOsoby
	 * @return
	 */
	Osoba podgladOsoby(Long idOsoby);
	
	/**
	 * Zwraca liczbę wpisów jako mieszkaniec dla wskazanej osoby
	 * 
	 * @return
	 */
	Integer selectLiczbaEwidencjiJakoMieszkaniec(Long osobaId);
	
	/**
	 * @param ewidencjaId identyfikator ewidencji osoby
	 * @return
	 */
	Osoba selectByEwidencjaId(Long ewidencjaId);
}
