package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.Adres;
import pl.topteam.dps.model.main_gen.AdresCriteria.Criteria;
import pl.topteam.dps.model.main_gen.AdresCriteria.Criterion;
import pl.topteam.dps.model.main.AdresCriteria;

public class AdresSqlProvider {

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String countByExample(AdresCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("ADRES");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String deleteByExample(AdresCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("ADRES");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String insertSelective(Adres record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("ADRES");
        
        if (record.getDataOd() != null) {
            sql.VALUES("DATA_OD", "#{dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.VALUES("DATA_DO", "#{dataDo,jdbcType=DATE}");
        }
        
        if (record.getFax() != null) {
            sql.VALUES("FAX", "#{fax,jdbcType=VARCHAR}");
        }
        
        if (record.getGmina() != null) {
            sql.VALUES("GMINA", "#{gmina,jdbcType=VARCHAR}");
        }
        
        if (record.getKodPocztowy() != null) {
            sql.VALUES("KOD_POCZTOWY", "#{kodPocztowy,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscowosc() != null) {
            sql.VALUES("MIEJSCOWOSC", "#{miejscowosc,jdbcType=VARCHAR}");
        }
        
        if (record.getNrDomu() != null) {
            sql.VALUES("NR_DOMU", "#{nrDomu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrLokalu() != null) {
            sql.VALUES("NR_LOKALU", "#{nrLokalu,jdbcType=VARCHAR}");
        }
        
        if (record.getPanstwo() != null) {
            sql.VALUES("PANSTWO", "#{panstwo,jdbcType=VARCHAR}");
        }
        
        if (record.getPoczta() != null) {
            sql.VALUES("POCZTA", "#{poczta,jdbcType=VARCHAR}");
        }
        
        if (record.getPowiat() != null) {
            sql.VALUES("POWIAT", "#{powiat,jdbcType=VARCHAR}");
        }
        
        if (record.getTelefon() != null) {
            sql.VALUES("TELEFON", "#{telefon,jdbcType=VARCHAR}");
        }
        
        if (record.getTyp() != null) {
            sql.VALUES("TYP", "#{typ,jdbcType=VARCHAR}");
        }
        
        if (record.getUlica() != null) {
            sql.VALUES("ULICA", "#{ulica,jdbcType=VARCHAR}");
        }
        
        if (record.getWojewodztwo() != null) {
            sql.VALUES("WOJEWODZTWO", "#{wojewodztwo,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String selectByExample(AdresCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("DATA_OD");
        sql.SELECT("DATA_DO");
        sql.SELECT("FAX");
        sql.SELECT("GMINA");
        sql.SELECT("KOD_POCZTOWY");
        sql.SELECT("MIEJSCOWOSC");
        sql.SELECT("NR_DOMU");
        sql.SELECT("NR_LOKALU");
        sql.SELECT("PANSTWO");
        sql.SELECT("POCZTA");
        sql.SELECT("POWIAT");
        sql.SELECT("TELEFON");
        sql.SELECT("TYP");
        sql.SELECT("ULICA");
        sql.SELECT("WOJEWODZTWO");
        sql.FROM("ADRES");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        Adres record = (Adres) parameter.get("record");
        AdresCriteria example = (AdresCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("ADRES");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        }
        
        if (record.getFax() != null) {
            sql.SET("FAX = #{record.fax,jdbcType=VARCHAR}");
        }
        
        if (record.getGmina() != null) {
            sql.SET("GMINA = #{record.gmina,jdbcType=VARCHAR}");
        }
        
        if (record.getKodPocztowy() != null) {
            sql.SET("KOD_POCZTOWY = #{record.kodPocztowy,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscowosc() != null) {
            sql.SET("MIEJSCOWOSC = #{record.miejscowosc,jdbcType=VARCHAR}");
        }
        
        if (record.getNrDomu() != null) {
            sql.SET("NR_DOMU = #{record.nrDomu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrLokalu() != null) {
            sql.SET("NR_LOKALU = #{record.nrLokalu,jdbcType=VARCHAR}");
        }
        
        if (record.getPanstwo() != null) {
            sql.SET("PANSTWO = #{record.panstwo,jdbcType=VARCHAR}");
        }
        
        if (record.getPoczta() != null) {
            sql.SET("POCZTA = #{record.poczta,jdbcType=VARCHAR}");
        }
        
        if (record.getPowiat() != null) {
            sql.SET("POWIAT = #{record.powiat,jdbcType=VARCHAR}");
        }
        
        if (record.getTelefon() != null) {
            sql.SET("TELEFON = #{record.telefon,jdbcType=VARCHAR}");
        }
        
        if (record.getTyp() != null) {
            sql.SET("TYP = #{record.typ,jdbcType=VARCHAR}");
        }
        
        if (record.getUlica() != null) {
            sql.SET("ULICA = #{record.ulica,jdbcType=VARCHAR}");
        }
        
        if (record.getWojewodztwo() != null) {
            sql.SET("WOJEWODZTWO = #{record.wojewodztwo,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("ADRES");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        sql.SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        sql.SET("FAX = #{record.fax,jdbcType=VARCHAR}");
        sql.SET("GMINA = #{record.gmina,jdbcType=VARCHAR}");
        sql.SET("KOD_POCZTOWY = #{record.kodPocztowy,jdbcType=VARCHAR}");
        sql.SET("MIEJSCOWOSC = #{record.miejscowosc,jdbcType=VARCHAR}");
        sql.SET("NR_DOMU = #{record.nrDomu,jdbcType=VARCHAR}");
        sql.SET("NR_LOKALU = #{record.nrLokalu,jdbcType=VARCHAR}");
        sql.SET("PANSTWO = #{record.panstwo,jdbcType=VARCHAR}");
        sql.SET("POCZTA = #{record.poczta,jdbcType=VARCHAR}");
        sql.SET("POWIAT = #{record.powiat,jdbcType=VARCHAR}");
        sql.SET("TELEFON = #{record.telefon,jdbcType=VARCHAR}");
        sql.SET("TYP = #{record.typ,jdbcType=VARCHAR}");
        sql.SET("ULICA = #{record.ulica,jdbcType=VARCHAR}");
        sql.SET("WOJEWODZTWO = #{record.wojewodztwo,jdbcType=VARCHAR}");
        
        AdresCriteria example = (AdresCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByPrimaryKeySelective(Adres record) {
        SQL sql = new SQL();
        sql.UPDATE("ADRES");
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.SET("DATA_DO = #{dataDo,jdbcType=DATE}");
        }
        
        if (record.getFax() != null) {
            sql.SET("FAX = #{fax,jdbcType=VARCHAR}");
        }
        
        if (record.getGmina() != null) {
            sql.SET("GMINA = #{gmina,jdbcType=VARCHAR}");
        }
        
        if (record.getKodPocztowy() != null) {
            sql.SET("KOD_POCZTOWY = #{kodPocztowy,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejscowosc() != null) {
            sql.SET("MIEJSCOWOSC = #{miejscowosc,jdbcType=VARCHAR}");
        }
        
        if (record.getNrDomu() != null) {
            sql.SET("NR_DOMU = #{nrDomu,jdbcType=VARCHAR}");
        }
        
        if (record.getNrLokalu() != null) {
            sql.SET("NR_LOKALU = #{nrLokalu,jdbcType=VARCHAR}");
        }
        
        if (record.getPanstwo() != null) {
            sql.SET("PANSTWO = #{panstwo,jdbcType=VARCHAR}");
        }
        
        if (record.getPoczta() != null) {
            sql.SET("POCZTA = #{poczta,jdbcType=VARCHAR}");
        }
        
        if (record.getPowiat() != null) {
            sql.SET("POWIAT = #{powiat,jdbcType=VARCHAR}");
        }
        
        if (record.getTelefon() != null) {
            sql.SET("TELEFON = #{telefon,jdbcType=VARCHAR}");
        }
        
        if (record.getTyp() != null) {
            sql.SET("TYP = #{typ,jdbcType=VARCHAR}");
        }
        
        if (record.getUlica() != null) {
            sql.SET("ULICA = #{ulica,jdbcType=VARCHAR}");
        }
        
        if (record.getWojewodztwo() != null) {
            sql.SET("WOJEWODZTWO = #{wojewodztwo,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    protected void applyWhere(SQL sql, AdresCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}