package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.DowodOsobisty;
import pl.topteam.dps.model.main.DowodOsobistyCriteria;

public abstract interface DowodOsobistyMapper {
    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=DowodOsobistySqlProvider.class, method="countByExample")
    int countByExample(DowodOsobistyCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @DeleteProvider(type=DowodOsobistySqlProvider.class, method="deleteByExample")
    int deleteByExample(DowodOsobistyCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Delete({
        "delete from DOWOD_OSOBISTY",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Insert({
        "insert into DOWOD_OSOBISTY (OSOBA_ID, WYDANY_PRZEZ_ID, ",
        "DATA_WAZNOSCI, DATA_WPROWADZENIA, ",
        "DATA_WYDANIA, SERIA_NR)",
        "values (#{osobaId,jdbcType=BIGINT}, #{wydanyPrzezId,jdbcType=BIGINT}, ",
        "#{dataWaznosci,jdbcType=DATE}, #{dataWprowadzenia,jdbcType=DATE}, ",
        "#{dataWydania,jdbcType=DATE}, #{seriaNr,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(DowodOsobisty record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    int mergeInto(DowodOsobisty record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @InsertProvider(type=DowodOsobistySqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(DowodOsobisty record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=DowodOsobistySqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="WYDANY_PRZEZ_ID", property="wydanyPrzezId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_WAZNOSCI", property="dataWaznosci", jdbcType=JdbcType.DATE),
        @Result(column="DATA_WPROWADZENIA", property="dataWprowadzenia", jdbcType=JdbcType.DATE),
        @Result(column="DATA_WYDANIA", property="dataWydania", jdbcType=JdbcType.DATE),
        @Result(column="SERIA_NR", property="seriaNr", jdbcType=JdbcType.VARCHAR)
    })
    List<DowodOsobisty> selectByExampleWithRowbounds(DowodOsobistyCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=DowodOsobistySqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="WYDANY_PRZEZ_ID", property="wydanyPrzezId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_WAZNOSCI", property="dataWaznosci", jdbcType=JdbcType.DATE),
        @Result(column="DATA_WPROWADZENIA", property="dataWprowadzenia", jdbcType=JdbcType.DATE),
        @Result(column="DATA_WYDANIA", property="dataWydania", jdbcType=JdbcType.DATE),
        @Result(column="SERIA_NR", property="seriaNr", jdbcType=JdbcType.VARCHAR)
    })
    List<DowodOsobisty> selectByExample(DowodOsobistyCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Select({
        "select",
        "ID, OSOBA_ID, WYDANY_PRZEZ_ID, DATA_WAZNOSCI, DATA_WPROWADZENIA, DATA_WYDANIA, ",
        "SERIA_NR",
        "from DOWOD_OSOBISTY",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="WYDANY_PRZEZ_ID", property="wydanyPrzezId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_WAZNOSCI", property="dataWaznosci", jdbcType=JdbcType.DATE),
        @Result(column="DATA_WPROWADZENIA", property="dataWprowadzenia", jdbcType=JdbcType.DATE),
        @Result(column="DATA_WYDANIA", property="dataWydania", jdbcType=JdbcType.DATE),
        @Result(column="SERIA_NR", property="seriaNr", jdbcType=JdbcType.VARCHAR)
    })
    DowodOsobisty selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=DowodOsobistySqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") DowodOsobisty record, @Param("example") DowodOsobistyCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=DowodOsobistySqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") DowodOsobisty record, @Param("example") DowodOsobistyCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=DowodOsobistySqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(DowodOsobisty record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Update({
        "update DOWOD_OSOBISTY",
        "set OSOBA_ID = #{osobaId,jdbcType=BIGINT},",
          "WYDANY_PRZEZ_ID = #{wydanyPrzezId,jdbcType=BIGINT},",
          "DATA_WAZNOSCI = #{dataWaznosci,jdbcType=DATE},",
          "DATA_WPROWADZENIA = #{dataWprowadzenia,jdbcType=DATE},",
          "DATA_WYDANIA = #{dataWydania,jdbcType=DATE},",
          "SERIA_NR = #{seriaNr,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(DowodOsobisty record);
}