package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.EwidencjaDps;
import pl.topteam.dps.model.main_gen.EwidencjaDpsCriteria.Criteria;
import pl.topteam.dps.model.main_gen.EwidencjaDpsCriteria.Criterion;
import pl.topteam.dps.model.main.EwidencjaDpsCriteria;

public class EwidencjaDpsSqlProvider {

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String countByExample(EwidencjaDpsCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("EWIDENCJA_DPS");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String deleteByExample(EwidencjaDpsCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("EWIDENCJA_DPS");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String insertSelective(EwidencjaDps record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("EWIDENCJA_DPS");
        
        if (record.getEwidPoprzedniWpisId() != null) {
            sql.VALUES("EWID_POPRZEDNI_WPIS_ID", "#{ewidPoprzedniWpisId,jdbcType=BIGINT}");
        }
        
        if (record.getDokadOdszedlId() != null) {
            sql.VALUES("DOKAD_ODSZEDL_ID", "#{dokadOdszedlId,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.VALUES("OSOBA_ID", "#{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getSzablonWydrukuId() != null) {
            sql.VALUES("SZABLON_WYDRUKU_ID", "#{szablonWydrukuId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.VALUES("DATA_OD", "#{dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.VALUES("DATA_DO", "#{dataDo,jdbcType=DATE}");
        }
        
        if (record.getNumerEwidencyjny() != null) {
            sql.VALUES("NUMER_EWIDENCYJNY", "#{numerEwidencyjny,jdbcType=VARCHAR}");
        }
        
        if (record.getStaleZameldowanieDom() != null) {
            sql.VALUES("STALE_ZAMELDOWANIE_DOM", "#{staleZameldowanieDom,jdbcType=BOOLEAN}");
        }
        
        if (record.getTyp() != null) {
            sql.VALUES("TYP", "#{typ,jdbcType=VARCHAR}");
        }
        
        if (record.getProfilDomu() != null) {
            sql.VALUES("PROFIL_DOMU", "#{profilDomu,jdbcType=VARCHAR}");
        }
        
        if (record.getSkadPrzyszedlId() != null) {
            sql.VALUES("SKAD_PRZYSZEDL_ID", "#{skadPrzyszedlId,jdbcType=BIGINT}");
        }
        
        if (record.getDzienPierwszyOdplatny() != null) {
            sql.VALUES("DZIEN_PIERWSZY_ODPLATNY", "#{dzienPierwszyOdplatny,jdbcType=BOOLEAN}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String selectByExample(EwidencjaDpsCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("EWID_POPRZEDNI_WPIS_ID");
        sql.SELECT("DOKAD_ODSZEDL_ID");
        sql.SELECT("OSOBA_ID");
        sql.SELECT("SZABLON_WYDRUKU_ID");
        sql.SELECT("DATA_OD");
        sql.SELECT("DATA_DO");
        sql.SELECT("NUMER_EWIDENCYJNY");
        sql.SELECT("STALE_ZAMELDOWANIE_DOM");
        sql.SELECT("TYP");
        sql.SELECT("PROFIL_DOMU");
        sql.SELECT("SKAD_PRZYSZEDL_ID");
        sql.SELECT("DZIEN_PIERWSZY_ODPLATNY");
        sql.FROM("EWIDENCJA_DPS");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        EwidencjaDps record = (EwidencjaDps) parameter.get("record");
        EwidencjaDpsCriteria example = (EwidencjaDpsCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("EWIDENCJA_DPS");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getEwidPoprzedniWpisId() != null) {
            sql.SET("EWID_POPRZEDNI_WPIS_ID = #{record.ewidPoprzedniWpisId,jdbcType=BIGINT}");
        }
        
        if (record.getDokadOdszedlId() != null) {
            sql.SET("DOKAD_ODSZEDL_ID = #{record.dokadOdszedlId,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getSzablonWydrukuId() != null) {
            sql.SET("SZABLON_WYDRUKU_ID = #{record.szablonWydrukuId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        }
        
        if (record.getNumerEwidencyjny() != null) {
            sql.SET("NUMER_EWIDENCYJNY = #{record.numerEwidencyjny,jdbcType=VARCHAR}");
        }
        
        if (record.getStaleZameldowanieDom() != null) {
            sql.SET("STALE_ZAMELDOWANIE_DOM = #{record.staleZameldowanieDom,jdbcType=BOOLEAN}");
        }
        
        if (record.getTyp() != null) {
            sql.SET("TYP = #{record.typ,jdbcType=VARCHAR}");
        }
        
        if (record.getProfilDomu() != null) {
            sql.SET("PROFIL_DOMU = #{record.profilDomu,jdbcType=VARCHAR}");
        }
        
        if (record.getSkadPrzyszedlId() != null) {
            sql.SET("SKAD_PRZYSZEDL_ID = #{record.skadPrzyszedlId,jdbcType=BIGINT}");
        }
        
        if (record.getDzienPierwszyOdplatny() != null) {
            sql.SET("DZIEN_PIERWSZY_ODPLATNY = #{record.dzienPierwszyOdplatny,jdbcType=BOOLEAN}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("EWIDENCJA_DPS");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("EWID_POPRZEDNI_WPIS_ID = #{record.ewidPoprzedniWpisId,jdbcType=BIGINT}");
        sql.SET("DOKAD_ODSZEDL_ID = #{record.dokadOdszedlId,jdbcType=BIGINT}");
        sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        sql.SET("SZABLON_WYDRUKU_ID = #{record.szablonWydrukuId,jdbcType=BIGINT}");
        sql.SET("DATA_OD = #{record.dataOd,jdbcType=DATE}");
        sql.SET("DATA_DO = #{record.dataDo,jdbcType=DATE}");
        sql.SET("NUMER_EWIDENCYJNY = #{record.numerEwidencyjny,jdbcType=VARCHAR}");
        sql.SET("STALE_ZAMELDOWANIE_DOM = #{record.staleZameldowanieDom,jdbcType=BOOLEAN}");
        sql.SET("TYP = #{record.typ,jdbcType=VARCHAR}");
        sql.SET("PROFIL_DOMU = #{record.profilDomu,jdbcType=VARCHAR}");
        sql.SET("SKAD_PRZYSZEDL_ID = #{record.skadPrzyszedlId,jdbcType=BIGINT}");
        sql.SET("DZIEN_PIERWSZY_ODPLATNY = #{record.dzienPierwszyOdplatny,jdbcType=BOOLEAN}");
        
        EwidencjaDpsCriteria example = (EwidencjaDpsCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByPrimaryKeySelective(EwidencjaDps record) {
        SQL sql = new SQL();
        sql.UPDATE("EWIDENCJA_DPS");
        
        if (record.getEwidPoprzedniWpisId() != null) {
            sql.SET("EWID_POPRZEDNI_WPIS_ID = #{ewidPoprzedniWpisId,jdbcType=BIGINT}");
        }
        
        if (record.getDokadOdszedlId() != null) {
            sql.SET("DOKAD_ODSZEDL_ID = #{dokadOdszedlId,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getSzablonWydrukuId() != null) {
            sql.SET("SZABLON_WYDRUKU_ID = #{szablonWydrukuId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOd() != null) {
            sql.SET("DATA_OD = #{dataOd,jdbcType=DATE}");
        }
        
        if (record.getDataDo() != null) {
            sql.SET("DATA_DO = #{dataDo,jdbcType=DATE}");
        }
        
        if (record.getNumerEwidencyjny() != null) {
            sql.SET("NUMER_EWIDENCYJNY = #{numerEwidencyjny,jdbcType=VARCHAR}");
        }
        
        if (record.getStaleZameldowanieDom() != null) {
            sql.SET("STALE_ZAMELDOWANIE_DOM = #{staleZameldowanieDom,jdbcType=BOOLEAN}");
        }
        
        if (record.getTyp() != null) {
            sql.SET("TYP = #{typ,jdbcType=VARCHAR}");
        }
        
        if (record.getProfilDomu() != null) {
            sql.SET("PROFIL_DOMU = #{profilDomu,jdbcType=VARCHAR}");
        }
        
        if (record.getSkadPrzyszedlId() != null) {
            sql.SET("SKAD_PRZYSZEDL_ID = #{skadPrzyszedlId,jdbcType=BIGINT}");
        }
        
        if (record.getDzienPierwszyOdplatny() != null) {
            sql.SET("DZIEN_PIERWSZY_ODPLATNY = #{dzienPierwszyOdplatny,jdbcType=BOOLEAN}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    protected void applyWhere(SQL sql, EwidencjaDpsCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}