package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Grupa;
import pl.topteam.dps.model.main.GrupaCriteria;

public abstract interface GrupaMapper {
    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=GrupaSqlProvider.class, method="countByExample")
    int countByExample(GrupaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @DeleteProvider(type=GrupaSqlProvider.class, method="deleteByExample")
    int deleteByExample(GrupaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Delete({
        "delete from GRUPA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Insert({
        "insert into GRUPA (NAZWA)",
        "values (#{nazwa,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Grupa record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    int mergeInto(Grupa record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @InsertProvider(type=GrupaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Grupa record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=GrupaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR)
    })
    List<Grupa> selectByExampleWithRowbounds(GrupaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=GrupaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR)
    })
    List<Grupa> selectByExample(GrupaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Select({
        "select",
        "ID, NAZWA",
        "from GRUPA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR)
    })
    Grupa selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=GrupaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Grupa record, @Param("example") GrupaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=GrupaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Grupa record, @Param("example") GrupaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=GrupaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Grupa record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Update({
        "update GRUPA",
        "set NAZWA = #{nazwa,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Grupa record);
}