package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.InformacjaDodatkowaPoleWpis;
import pl.topteam.dps.model.main_gen.InformacjaDodatkowaPoleWpisCriteria.Criteria;
import pl.topteam.dps.model.main_gen.InformacjaDodatkowaPoleWpisCriteria.Criterion;
import pl.topteam.dps.model.main.InformacjaDodatkowaPoleWpisCriteria;

public class InformacjaDodatkowaPoleWpisSqlProvider {

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String countByExample(InformacjaDodatkowaPoleWpisCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("INFORMACJA_DODATKOWA_POLE_WPIS");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String deleteByExample(InformacjaDodatkowaPoleWpisCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("INFORMACJA_DODATKOWA_POLE_WPIS");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String insertSelective(InformacjaDodatkowaPoleWpis record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("INFORMACJA_DODATKOWA_POLE_WPIS");
        
        if (record.getInformacjaWpisId() != null) {
            sql.VALUES("INFORMACJA_WPIS_ID", "#{informacjaWpisId,jdbcType=BIGINT}");
        }
        
        if (record.getPoleId() != null) {
            sql.VALUES("POLE_ID", "#{poleId,jdbcType=BIGINT}");
        }
        
        if (record.getNiePrzypominaj() != null) {
            sql.VALUES("NIE_PRZYPOMINAJ", "#{niePrzypominaj,jdbcType=BOOLEAN}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String selectByExample(InformacjaDodatkowaPoleWpisCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("INFORMACJA_WPIS_ID");
        sql.SELECT("POLE_ID");
        sql.SELECT("NIE_PRZYPOMINAJ");
        sql.FROM("INFORMACJA_DODATKOWA_POLE_WPIS");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        InformacjaDodatkowaPoleWpis record = (InformacjaDodatkowaPoleWpis) parameter.get("record");
        InformacjaDodatkowaPoleWpisCriteria example = (InformacjaDodatkowaPoleWpisCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("INFORMACJA_DODATKOWA_POLE_WPIS");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getInformacjaWpisId() != null) {
            sql.SET("INFORMACJA_WPIS_ID = #{record.informacjaWpisId,jdbcType=BIGINT}");
        }
        
        if (record.getPoleId() != null) {
            sql.SET("POLE_ID = #{record.poleId,jdbcType=BIGINT}");
        }
        
        if (record.getNiePrzypominaj() != null) {
            sql.SET("NIE_PRZYPOMINAJ = #{record.niePrzypominaj,jdbcType=BOOLEAN}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("INFORMACJA_DODATKOWA_POLE_WPIS");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("INFORMACJA_WPIS_ID = #{record.informacjaWpisId,jdbcType=BIGINT}");
        sql.SET("POLE_ID = #{record.poleId,jdbcType=BIGINT}");
        sql.SET("NIE_PRZYPOMINAJ = #{record.niePrzypominaj,jdbcType=BOOLEAN}");
        
        InformacjaDodatkowaPoleWpisCriteria example = (InformacjaDodatkowaPoleWpisCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByPrimaryKeySelective(InformacjaDodatkowaPoleWpis record) {
        SQL sql = new SQL();
        sql.UPDATE("INFORMACJA_DODATKOWA_POLE_WPIS");
        
        if (record.getInformacjaWpisId() != null) {
            sql.SET("INFORMACJA_WPIS_ID = #{informacjaWpisId,jdbcType=BIGINT}");
        }
        
        if (record.getPoleId() != null) {
            sql.SET("POLE_ID = #{poleId,jdbcType=BIGINT}");
        }
        
        if (record.getNiePrzypominaj() != null) {
            sql.SET("NIE_PRZYPOMINAJ = #{niePrzypominaj,jdbcType=BOOLEAN}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    protected void applyWhere(SQL sql, InformacjaDodatkowaPoleWpisCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}