package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.KontoBankowe;
import pl.topteam.dps.model.main.KontoBankoweCriteria;

public abstract interface KontoBankoweMapper {
    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=KontoBankoweSqlProvider.class, method="countByExample")
    int countByExample(KontoBankoweCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @DeleteProvider(type=KontoBankoweSqlProvider.class, method="deleteByExample")
    int deleteByExample(KontoBankoweCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Delete({
        "delete from KONTO_BANKOWE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Insert({
        "insert into KONTO_BANKOWE (IBAN, LICZNIK_UZYCIE, ",
        "LICZNIK_PRZYPISAN)",
        "values (#{iban,jdbcType=VARCHAR}, #{licznikUzycie,jdbcType=INTEGER}, ",
        "#{licznikPrzypisan,jdbcType=INTEGER})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(KontoBankowe record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    int mergeInto(KontoBankowe record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @InsertProvider(type=KontoBankoweSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(KontoBankowe record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=KontoBankoweSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="IBAN", property="iban", jdbcType=JdbcType.VARCHAR),
        @Result(column="LICZNIK_UZYCIE", property="licznikUzycie", jdbcType=JdbcType.INTEGER),
        @Result(column="LICZNIK_PRZYPISAN", property="licznikPrzypisan", jdbcType=JdbcType.INTEGER)
    })
    List<KontoBankowe> selectByExampleWithRowbounds(KontoBankoweCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=KontoBankoweSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="IBAN", property="iban", jdbcType=JdbcType.VARCHAR),
        @Result(column="LICZNIK_UZYCIE", property="licznikUzycie", jdbcType=JdbcType.INTEGER),
        @Result(column="LICZNIK_PRZYPISAN", property="licznikPrzypisan", jdbcType=JdbcType.INTEGER)
    })
    List<KontoBankowe> selectByExample(KontoBankoweCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Select({
        "select",
        "ID, IBAN, LICZNIK_UZYCIE, LICZNIK_PRZYPISAN",
        "from KONTO_BANKOWE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="IBAN", property="iban", jdbcType=JdbcType.VARCHAR),
        @Result(column="LICZNIK_UZYCIE", property="licznikUzycie", jdbcType=JdbcType.INTEGER),
        @Result(column="LICZNIK_PRZYPISAN", property="licznikPrzypisan", jdbcType=JdbcType.INTEGER)
    })
    KontoBankowe selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=KontoBankoweSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") KontoBankowe record, @Param("example") KontoBankoweCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=KontoBankoweSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") KontoBankowe record, @Param("example") KontoBankoweCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=KontoBankoweSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(KontoBankowe record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Update({
        "update KONTO_BANKOWE",
        "set IBAN = #{iban,jdbcType=VARCHAR},",
          "LICZNIK_UZYCIE = #{licznikUzycie,jdbcType=INTEGER},",
          "LICZNIK_PRZYPISAN = #{licznikPrzypisan,jdbcType=INTEGER}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(KontoBankowe record);
}