package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.NaliczeniePobyt;
import pl.topteam.dps.model.main.NaliczeniePobytCriteria;

public abstract interface NaliczeniePobytMapper {
    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=NaliczeniePobytSqlProvider.class, method="countByExample")
    int countByExample(NaliczeniePobytCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @DeleteProvider(type=NaliczeniePobytSqlProvider.class, method="deleteByExample")
    int deleteByExample(NaliczeniePobytCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Delete({
        "delete from NALICZENIE_POBYT",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Insert({
        "insert into NALICZENIE_POBYT (ZADLUZENIE_POZYCJA_ID, DATA_OBLICZENIA, ",
        "KWOTA, DATA_KSIEGOWANIA, ",
        "DOLICZENIE_ID)",
        "values (#{zadluzeniePozycjaId,jdbcType=BIGINT}, #{dataObliczenia,jdbcType=DATE}, ",
        "#{kwota,jdbcType=DECIMAL}, #{dataKsiegowania,jdbcType=DATE}, ",
        "#{doliczenieId,jdbcType=BIGINT})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(NaliczeniePobyt record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    int mergeInto(NaliczeniePobyt record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @InsertProvider(type=NaliczeniePobytSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(NaliczeniePobyt record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=NaliczeniePobytSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ZADLUZENIE_POZYCJA_ID", property="zadluzeniePozycjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_OBLICZENIA", property="dataObliczenia", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="DATA_KSIEGOWANIA", property="dataKsiegowania", jdbcType=JdbcType.DATE),
        @Result(column="DOLICZENIE_ID", property="doliczenieId", jdbcType=JdbcType.BIGINT)
    })
    List<NaliczeniePobyt> selectByExampleWithRowbounds(NaliczeniePobytCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=NaliczeniePobytSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ZADLUZENIE_POZYCJA_ID", property="zadluzeniePozycjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_OBLICZENIA", property="dataObliczenia", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="DATA_KSIEGOWANIA", property="dataKsiegowania", jdbcType=JdbcType.DATE),
        @Result(column="DOLICZENIE_ID", property="doliczenieId", jdbcType=JdbcType.BIGINT)
    })
    List<NaliczeniePobyt> selectByExample(NaliczeniePobytCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Select({
        "select",
        "ID, ZADLUZENIE_POZYCJA_ID, DATA_OBLICZENIA, KWOTA, DATA_KSIEGOWANIA, DOLICZENIE_ID",
        "from NALICZENIE_POBYT",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ZADLUZENIE_POZYCJA_ID", property="zadluzeniePozycjaId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_OBLICZENIA", property="dataObliczenia", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="DATA_KSIEGOWANIA", property="dataKsiegowania", jdbcType=JdbcType.DATE),
        @Result(column="DOLICZENIE_ID", property="doliczenieId", jdbcType=JdbcType.BIGINT)
    })
    NaliczeniePobyt selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=NaliczeniePobytSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") NaliczeniePobyt record, @Param("example") NaliczeniePobytCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=NaliczeniePobytSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") NaliczeniePobyt record, @Param("example") NaliczeniePobytCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=NaliczeniePobytSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(NaliczeniePobyt record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Update({
        "update NALICZENIE_POBYT",
        "set ZADLUZENIE_POZYCJA_ID = #{zadluzeniePozycjaId,jdbcType=BIGINT},",
          "DATA_OBLICZENIA = #{dataObliczenia,jdbcType=DATE},",
          "KWOTA = #{kwota,jdbcType=DECIMAL},",
          "DATA_KSIEGOWANIA = #{dataKsiegowania,jdbcType=DATE},",
          "DOLICZENIE_ID = #{doliczenieId,jdbcType=BIGINT}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(NaliczeniePobyt record);
}