package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.OrzeczONiepelnospraw;
import pl.topteam.dps.model.main_gen.OrzeczONiepelnosprawCriteria.Criteria;
import pl.topteam.dps.model.main_gen.OrzeczONiepelnosprawCriteria.Criterion;
import pl.topteam.dps.model.main.OrzeczONiepelnosprawCriteria;

public class OrzeczONiepelnosprawSqlProvider {

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String countByExample(OrzeczONiepelnosprawCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("ORZECZ_O_NIEPELNOSPRAW");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String deleteByExample(OrzeczONiepelnosprawCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("ORZECZ_O_NIEPELNOSPRAW");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String insertSelective(OrzeczONiepelnospraw record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("ORZECZ_O_NIEPELNOSPRAW");
        
        if (record.getOsobaId() != null) {
            sql.VALUES("OSOBA_ID", "#{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOrzeczenia() != null) {
            sql.VALUES("DATA_ORZECZENIA", "#{dataOrzeczenia,jdbcType=DATE}");
        }
        
        if (record.getNr() != null) {
            sql.VALUES("NR", "#{nr,jdbcType=VARCHAR}");
        }
        
        if (record.getObowiazujeOd() != null) {
            sql.VALUES("OBOWIAZUJE_OD", "#{obowiazujeOd,jdbcType=DATE}");
        }
        
        if (record.getStopienNiepelnospraw() != null) {
            sql.VALUES("STOPIEN_NIEPELNOSPRAW", "#{stopienNiepelnospraw,jdbcType=VARCHAR}");
        }
        
        if (record.getWazneDo() != null) {
            sql.VALUES("WAZNE_DO", "#{wazneDo,jdbcType=DATE}");
        }
        
        if (record.getRodzajOrzecznictwa() != null) {
            sql.VALUES("RODZAJ_ORZECZNICTWA", "#{rodzajOrzecznictwa,jdbcType=VARCHAR}");
        }
        
        if (record.getWydanePrzezId() != null) {
            sql.VALUES("WYDANE_PRZEZ_ID", "#{wydanePrzezId,jdbcType=BIGINT}");
        }
        
        if (record.getUwagi() != null) {
            sql.VALUES("UWAGI", "#{uwagi,jdbcType=VARCHAR}");
        }
        
        if (record.getBezPrzypomnienia() != null) {
            sql.VALUES("BEZ_PRZYPOMNIENIA", "#{bezPrzypomnienia,jdbcType=BOOLEAN}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String selectByExample(OrzeczONiepelnosprawCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("OSOBA_ID");
        sql.SELECT("DATA_ORZECZENIA");
        sql.SELECT("NR");
        sql.SELECT("OBOWIAZUJE_OD");
        sql.SELECT("STOPIEN_NIEPELNOSPRAW");
        sql.SELECT("WAZNE_DO");
        sql.SELECT("RODZAJ_ORZECZNICTWA");
        sql.SELECT("WYDANE_PRZEZ_ID");
        sql.SELECT("UWAGI");
        sql.SELECT("BEZ_PRZYPOMNIENIA");
        sql.FROM("ORZECZ_O_NIEPELNOSPRAW");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        OrzeczONiepelnospraw record = (OrzeczONiepelnospraw) parameter.get("record");
        OrzeczONiepelnosprawCriteria example = (OrzeczONiepelnosprawCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("ORZECZ_O_NIEPELNOSPRAW");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOrzeczenia() != null) {
            sql.SET("DATA_ORZECZENIA = #{record.dataOrzeczenia,jdbcType=DATE}");
        }
        
        if (record.getNr() != null) {
            sql.SET("NR = #{record.nr,jdbcType=VARCHAR}");
        }
        
        if (record.getObowiazujeOd() != null) {
            sql.SET("OBOWIAZUJE_OD = #{record.obowiazujeOd,jdbcType=DATE}");
        }
        
        if (record.getStopienNiepelnospraw() != null) {
            sql.SET("STOPIEN_NIEPELNOSPRAW = #{record.stopienNiepelnospraw,jdbcType=VARCHAR}");
        }
        
        if (record.getWazneDo() != null) {
            sql.SET("WAZNE_DO = #{record.wazneDo,jdbcType=DATE}");
        }
        
        if (record.getRodzajOrzecznictwa() != null) {
            sql.SET("RODZAJ_ORZECZNICTWA = #{record.rodzajOrzecznictwa,jdbcType=VARCHAR}");
        }
        
        if (record.getWydanePrzezId() != null) {
            sql.SET("WYDANE_PRZEZ_ID = #{record.wydanePrzezId,jdbcType=BIGINT}");
        }
        
        if (record.getUwagi() != null) {
            sql.SET("UWAGI = #{record.uwagi,jdbcType=VARCHAR}");
        }
        
        if (record.getBezPrzypomnienia() != null) {
            sql.SET("BEZ_PRZYPOMNIENIA = #{record.bezPrzypomnienia,jdbcType=BOOLEAN}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("ORZECZ_O_NIEPELNOSPRAW");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        sql.SET("DATA_ORZECZENIA = #{record.dataOrzeczenia,jdbcType=DATE}");
        sql.SET("NR = #{record.nr,jdbcType=VARCHAR}");
        sql.SET("OBOWIAZUJE_OD = #{record.obowiazujeOd,jdbcType=DATE}");
        sql.SET("STOPIEN_NIEPELNOSPRAW = #{record.stopienNiepelnospraw,jdbcType=VARCHAR}");
        sql.SET("WAZNE_DO = #{record.wazneDo,jdbcType=DATE}");
        sql.SET("RODZAJ_ORZECZNICTWA = #{record.rodzajOrzecznictwa,jdbcType=VARCHAR}");
        sql.SET("WYDANE_PRZEZ_ID = #{record.wydanePrzezId,jdbcType=BIGINT}");
        sql.SET("UWAGI = #{record.uwagi,jdbcType=VARCHAR}");
        sql.SET("BEZ_PRZYPOMNIENIA = #{record.bezPrzypomnienia,jdbcType=BOOLEAN}");
        
        OrzeczONiepelnosprawCriteria example = (OrzeczONiepelnosprawCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByPrimaryKeySelective(OrzeczONiepelnospraw record) {
        SQL sql = new SQL();
        sql.UPDATE("ORZECZ_O_NIEPELNOSPRAW");
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getDataOrzeczenia() != null) {
            sql.SET("DATA_ORZECZENIA = #{dataOrzeczenia,jdbcType=DATE}");
        }
        
        if (record.getNr() != null) {
            sql.SET("NR = #{nr,jdbcType=VARCHAR}");
        }
        
        if (record.getObowiazujeOd() != null) {
            sql.SET("OBOWIAZUJE_OD = #{obowiazujeOd,jdbcType=DATE}");
        }
        
        if (record.getStopienNiepelnospraw() != null) {
            sql.SET("STOPIEN_NIEPELNOSPRAW = #{stopienNiepelnospraw,jdbcType=VARCHAR}");
        }
        
        if (record.getWazneDo() != null) {
            sql.SET("WAZNE_DO = #{wazneDo,jdbcType=DATE}");
        }
        
        if (record.getRodzajOrzecznictwa() != null) {
            sql.SET("RODZAJ_ORZECZNICTWA = #{rodzajOrzecznictwa,jdbcType=VARCHAR}");
        }
        
        if (record.getWydanePrzezId() != null) {
            sql.SET("WYDANE_PRZEZ_ID = #{wydanePrzezId,jdbcType=BIGINT}");
        }
        
        if (record.getUwagi() != null) {
            sql.SET("UWAGI = #{uwagi,jdbcType=VARCHAR}");
        }
        
        if (record.getBezPrzypomnienia() != null) {
            sql.SET("BEZ_PRZYPOMNIENIA = #{bezPrzypomnienia,jdbcType=BOOLEAN}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    protected void applyWhere(SQL sql, OrzeczONiepelnosprawCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}