package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.OsobaSprawozdanie;
import pl.topteam.dps.model.main.OsobaSprawozdanieCriteria;

public abstract interface OsobaSprawozdanieMapper {
    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=OsobaSprawozdanieSqlProvider.class, method="countByExample")
    int countByExample(OsobaSprawozdanieCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @DeleteProvider(type=OsobaSprawozdanieSqlProvider.class, method="deleteByExample")
    int deleteByExample(OsobaSprawozdanieCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Delete({
        "delete from OSOBA_SPRAWOZDANIE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Insert({
        "insert into OSOBA_SPRAWOZDANIE (OSOBA_ID, TYP)",
        "values (#{osobaId,jdbcType=BIGINT}, #{typ,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(OsobaSprawozdanie record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    int mergeInto(OsobaSprawozdanie record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @InsertProvider(type=OsobaSprawozdanieSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(OsobaSprawozdanie record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=OsobaSprawozdanieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR)
    })
    List<OsobaSprawozdanie> selectByExampleWithRowbounds(OsobaSprawozdanieCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=OsobaSprawozdanieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR)
    })
    List<OsobaSprawozdanie> selectByExample(OsobaSprawozdanieCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Select({
        "select",
        "ID, OSOBA_ID, TYP",
        "from OSOBA_SPRAWOZDANIE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR)
    })
    OsobaSprawozdanie selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=OsobaSprawozdanieSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") OsobaSprawozdanie record, @Param("example") OsobaSprawozdanieCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=OsobaSprawozdanieSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") OsobaSprawozdanie record, @Param("example") OsobaSprawozdanieCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=OsobaSprawozdanieSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(OsobaSprawozdanie record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Update({
        "update OSOBA_SPRAWOZDANIE",
        "set OSOBA_ID = #{osobaId,jdbcType=BIGINT},",
          "TYP = #{typ,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(OsobaSprawozdanie record);
}