package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.PlanWsparciaRealizacja;
import pl.topteam.dps.model.main.PlanWsparciaRealizacjaCriteria;

public abstract interface PlanWsparciaRealizacjaMapper {
    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=PlanWsparciaRealizacjaSqlProvider.class, method="countByExample")
    int countByExample(PlanWsparciaRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @DeleteProvider(type=PlanWsparciaRealizacjaSqlProvider.class, method="deleteByExample")
    int deleteByExample(PlanWsparciaRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Delete({
        "delete from PLAN_WSPARCIA_REALIZACJA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Insert({
        "insert into PLAN_WSPARCIA_REALIZACJA (OSOBA_ID, PRACOWNIK_ID, ",
        "DATA_REALIZACJI)",
        "values (#{osobaId,jdbcType=BIGINT}, #{pracownikId,jdbcType=BIGINT}, ",
        "#{dataRealizacji,jdbcType=DATE})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(PlanWsparciaRealizacja record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    int mergeInto(PlanWsparciaRealizacja record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @InsertProvider(type=PlanWsparciaRealizacjaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(PlanWsparciaRealizacja record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=PlanWsparciaRealizacjaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_ID", property="pracownikId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_REALIZACJI", property="dataRealizacji", jdbcType=JdbcType.DATE)
    })
    List<PlanWsparciaRealizacja> selectByExampleWithRowbounds(PlanWsparciaRealizacjaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=PlanWsparciaRealizacjaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_ID", property="pracownikId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_REALIZACJI", property="dataRealizacji", jdbcType=JdbcType.DATE)
    })
    List<PlanWsparciaRealizacja> selectByExample(PlanWsparciaRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Select({
        "select",
        "ID, OSOBA_ID, PRACOWNIK_ID, DATA_REALIZACJI",
        "from PLAN_WSPARCIA_REALIZACJA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="PRACOWNIK_ID", property="pracownikId", jdbcType=JdbcType.BIGINT),
        @Result(column="DATA_REALIZACJI", property="dataRealizacji", jdbcType=JdbcType.DATE)
    })
    PlanWsparciaRealizacja selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=PlanWsparciaRealizacjaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") PlanWsparciaRealizacja record, @Param("example") PlanWsparciaRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=PlanWsparciaRealizacjaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") PlanWsparciaRealizacja record, @Param("example") PlanWsparciaRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=PlanWsparciaRealizacjaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(PlanWsparciaRealizacja record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Update({
        "update PLAN_WSPARCIA_REALIZACJA",
        "set OSOBA_ID = #{osobaId,jdbcType=BIGINT},",
          "PRACOWNIK_ID = #{pracownikId,jdbcType=BIGINT},",
          "DATA_REALIZACJI = #{dataRealizacji,jdbcType=DATE}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(PlanWsparciaRealizacja record);
}