package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.PoraDnia;
import pl.topteam.dps.model.main_gen.PoraDniaCriteria.Criteria;
import pl.topteam.dps.model.main_gen.PoraDniaCriteria.Criterion;
import pl.topteam.dps.model.main.PoraDniaCriteria;

public class PoraDniaSqlProvider {

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String countByExample(PoraDniaCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("PORA_DNIA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String deleteByExample(PoraDniaCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("PORA_DNIA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String insertSelective(PoraDnia record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("PORA_DNIA");
        
        if (record.getCzyAktualna() != null) {
            sql.VALUES("CZY_AKTUALNA", "#{czyAktualna,jdbcType=BOOLEAN}");
        }
        
        if (record.getGodzina() != null) {
            sql.VALUES("GODZINA", "#{godzina,jdbcType=INTEGER}");
        }
        
        if (record.getKolejnosc() != null) {
            sql.VALUES("KOLEJNOSC", "#{kolejnosc,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            sql.VALUES("NAZWA", "#{nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getSkrot() != null) {
            sql.VALUES("SKROT", "#{skrot,jdbcType=VARCHAR}");
        }
        
        if (record.getWrp() != null) {
            sql.VALUES("WRP", "#{wrp,jdbcType=BOOLEAN}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String selectByExample(PoraDniaCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("CZY_AKTUALNA");
        sql.SELECT("GODZINA");
        sql.SELECT("KOLEJNOSC");
        sql.SELECT("NAZWA");
        sql.SELECT("SKROT");
        sql.SELECT("WRP");
        sql.FROM("PORA_DNIA");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        PoraDnia record = (PoraDnia) parameter.get("record");
        PoraDniaCriteria example = (PoraDniaCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("PORA_DNIA");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getCzyAktualna() != null) {
            sql.SET("CZY_AKTUALNA = #{record.czyAktualna,jdbcType=BOOLEAN}");
        }
        
        if (record.getGodzina() != null) {
            sql.SET("GODZINA = #{record.godzina,jdbcType=INTEGER}");
        }
        
        if (record.getKolejnosc() != null) {
            sql.SET("KOLEJNOSC = #{record.kolejnosc,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            sql.SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getSkrot() != null) {
            sql.SET("SKROT = #{record.skrot,jdbcType=VARCHAR}");
        }
        
        if (record.getWrp() != null) {
            sql.SET("WRP = #{record.wrp,jdbcType=BOOLEAN}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("PORA_DNIA");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("CZY_AKTUALNA = #{record.czyAktualna,jdbcType=BOOLEAN}");
        sql.SET("GODZINA = #{record.godzina,jdbcType=INTEGER}");
        sql.SET("KOLEJNOSC = #{record.kolejnosc,jdbcType=INTEGER}");
        sql.SET("NAZWA = #{record.nazwa,jdbcType=VARCHAR}");
        sql.SET("SKROT = #{record.skrot,jdbcType=VARCHAR}");
        sql.SET("WRP = #{record.wrp,jdbcType=BOOLEAN}");
        
        PoraDniaCriteria example = (PoraDniaCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByPrimaryKeySelective(PoraDnia record) {
        SQL sql = new SQL();
        sql.UPDATE("PORA_DNIA");
        
        if (record.getCzyAktualna() != null) {
            sql.SET("CZY_AKTUALNA = #{czyAktualna,jdbcType=BOOLEAN}");
        }
        
        if (record.getGodzina() != null) {
            sql.SET("GODZINA = #{godzina,jdbcType=INTEGER}");
        }
        
        if (record.getKolejnosc() != null) {
            sql.SET("KOLEJNOSC = #{kolejnosc,jdbcType=INTEGER}");
        }
        
        if (record.getNazwa() != null) {
            sql.SET("NAZWA = #{nazwa,jdbcType=VARCHAR}");
        }
        
        if (record.getSkrot() != null) {
            sql.SET("SKROT = #{skrot,jdbcType=VARCHAR}");
        }
        
        if (record.getWrp() != null) {
            sql.SET("WRP = #{wrp,jdbcType=BOOLEAN}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    protected void applyWhere(SQL sql, PoraDniaCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}