package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.QrtzTriggers;
import pl.topteam.dps.model.main_gen.QrtzTriggersCriteria.Criteria;
import pl.topteam.dps.model.main_gen.QrtzTriggersCriteria.Criterion;
import pl.topteam.dps.model.main.QrtzTriggersCriteria;

public class QrtzTriggersSqlProvider {

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String countByExample(QrtzTriggersCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("QRTZ_TRIGGERS");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String deleteByExample(QrtzTriggersCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("QRTZ_TRIGGERS");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String insertSelective(QrtzTriggers record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("QRTZ_TRIGGERS");
        
        if (record.getSchedName() != null) {
            sql.VALUES("SCHED_NAME", "#{schedName,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerName() != null) {
            sql.VALUES("TRIGGER_NAME", "#{triggerName,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerGroup() != null) {
            sql.VALUES("TRIGGER_GROUP", "#{triggerGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getJobName() != null) {
            sql.VALUES("JOB_NAME", "#{jobName,jdbcType=VARCHAR}");
        }
        
        if (record.getJobGroup() != null) {
            sql.VALUES("JOB_GROUP", "#{jobGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getDescription() != null) {
            sql.VALUES("DESCRIPTION", "#{description,jdbcType=VARCHAR}");
        }
        
        if (record.getNextFireTime() != null) {
            sql.VALUES("NEXT_FIRE_TIME", "#{nextFireTime,jdbcType=BIGINT}");
        }
        
        if (record.getPrevFireTime() != null) {
            sql.VALUES("PREV_FIRE_TIME", "#{prevFireTime,jdbcType=BIGINT}");
        }
        
        if (record.getPriority() != null) {
            sql.VALUES("PRIORITY", "#{priority,jdbcType=INTEGER}");
        }
        
        if (record.getTriggerState() != null) {
            sql.VALUES("TRIGGER_STATE", "#{triggerState,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerType() != null) {
            sql.VALUES("TRIGGER_TYPE", "#{triggerType,jdbcType=VARCHAR}");
        }
        
        if (record.getStartTime() != null) {
            sql.VALUES("START_TIME", "#{startTime,jdbcType=BIGINT}");
        }
        
        if (record.getEndTime() != null) {
            sql.VALUES("END_TIME", "#{endTime,jdbcType=BIGINT}");
        }
        
        if (record.getCalendarName() != null) {
            sql.VALUES("CALENDAR_NAME", "#{calendarName,jdbcType=VARCHAR}");
        }
        
        if (record.getMisfireInstr() != null) {
            sql.VALUES("MISFIRE_INSTR", "#{misfireInstr,jdbcType=SMALLINT}");
        }
        
        if (record.getJobData() != null) {
            sql.VALUES("JOB_DATA", "#{jobData,jdbcType=BLOB}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String selectByExampleWithBLOBs(QrtzTriggersCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("SCHED_NAME");
        } else {
            sql.SELECT("SCHED_NAME");
        }
        sql.SELECT("TRIGGER_NAME");
        sql.SELECT("TRIGGER_GROUP");
        sql.SELECT("JOB_NAME");
        sql.SELECT("JOB_GROUP");
        sql.SELECT("DESCRIPTION");
        sql.SELECT("NEXT_FIRE_TIME");
        sql.SELECT("PREV_FIRE_TIME");
        sql.SELECT("PRIORITY");
        sql.SELECT("TRIGGER_STATE");
        sql.SELECT("TRIGGER_TYPE");
        sql.SELECT("START_TIME");
        sql.SELECT("END_TIME");
        sql.SELECT("CALENDAR_NAME");
        sql.SELECT("MISFIRE_INSTR");
        sql.SELECT("JOB_DATA");
        sql.FROM("QRTZ_TRIGGERS");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String selectByExample(QrtzTriggersCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("SCHED_NAME");
        } else {
            sql.SELECT("SCHED_NAME");
        }
        sql.SELECT("TRIGGER_NAME");
        sql.SELECT("TRIGGER_GROUP");
        sql.SELECT("JOB_NAME");
        sql.SELECT("JOB_GROUP");
        sql.SELECT("DESCRIPTION");
        sql.SELECT("NEXT_FIRE_TIME");
        sql.SELECT("PREV_FIRE_TIME");
        sql.SELECT("PRIORITY");
        sql.SELECT("TRIGGER_STATE");
        sql.SELECT("TRIGGER_TYPE");
        sql.SELECT("START_TIME");
        sql.SELECT("END_TIME");
        sql.SELECT("CALENDAR_NAME");
        sql.SELECT("MISFIRE_INSTR");
        sql.FROM("QRTZ_TRIGGERS");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        QrtzTriggers record = (QrtzTriggers) parameter.get("record");
        QrtzTriggersCriteria example = (QrtzTriggersCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_TRIGGERS");
        
        if (record.getSchedName() != null) {
            sql.SET("SCHED_NAME = #{record.schedName,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerName() != null) {
            sql.SET("TRIGGER_NAME = #{record.triggerName,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerGroup() != null) {
            sql.SET("TRIGGER_GROUP = #{record.triggerGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getJobName() != null) {
            sql.SET("JOB_NAME = #{record.jobName,jdbcType=VARCHAR}");
        }
        
        if (record.getJobGroup() != null) {
            sql.SET("JOB_GROUP = #{record.jobGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getDescription() != null) {
            sql.SET("DESCRIPTION = #{record.description,jdbcType=VARCHAR}");
        }
        
        if (record.getNextFireTime() != null) {
            sql.SET("NEXT_FIRE_TIME = #{record.nextFireTime,jdbcType=BIGINT}");
        }
        
        if (record.getPrevFireTime() != null) {
            sql.SET("PREV_FIRE_TIME = #{record.prevFireTime,jdbcType=BIGINT}");
        }
        
        if (record.getPriority() != null) {
            sql.SET("PRIORITY = #{record.priority,jdbcType=INTEGER}");
        }
        
        if (record.getTriggerState() != null) {
            sql.SET("TRIGGER_STATE = #{record.triggerState,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerType() != null) {
            sql.SET("TRIGGER_TYPE = #{record.triggerType,jdbcType=VARCHAR}");
        }
        
        if (record.getStartTime() != null) {
            sql.SET("START_TIME = #{record.startTime,jdbcType=BIGINT}");
        }
        
        if (record.getEndTime() != null) {
            sql.SET("END_TIME = #{record.endTime,jdbcType=BIGINT}");
        }
        
        if (record.getCalendarName() != null) {
            sql.SET("CALENDAR_NAME = #{record.calendarName,jdbcType=VARCHAR}");
        }
        
        if (record.getMisfireInstr() != null) {
            sql.SET("MISFIRE_INSTR = #{record.misfireInstr,jdbcType=SMALLINT}");
        }
        
        if (record.getJobData() != null) {
            sql.SET("JOB_DATA = #{record.jobData,jdbcType=BLOB}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExampleWithBLOBs(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_TRIGGERS");
        
        sql.SET("SCHED_NAME = #{record.schedName,jdbcType=VARCHAR}");
        sql.SET("TRIGGER_NAME = #{record.triggerName,jdbcType=VARCHAR}");
        sql.SET("TRIGGER_GROUP = #{record.triggerGroup,jdbcType=VARCHAR}");
        sql.SET("JOB_NAME = #{record.jobName,jdbcType=VARCHAR}");
        sql.SET("JOB_GROUP = #{record.jobGroup,jdbcType=VARCHAR}");
        sql.SET("DESCRIPTION = #{record.description,jdbcType=VARCHAR}");
        sql.SET("NEXT_FIRE_TIME = #{record.nextFireTime,jdbcType=BIGINT}");
        sql.SET("PREV_FIRE_TIME = #{record.prevFireTime,jdbcType=BIGINT}");
        sql.SET("PRIORITY = #{record.priority,jdbcType=INTEGER}");
        sql.SET("TRIGGER_STATE = #{record.triggerState,jdbcType=VARCHAR}");
        sql.SET("TRIGGER_TYPE = #{record.triggerType,jdbcType=VARCHAR}");
        sql.SET("START_TIME = #{record.startTime,jdbcType=BIGINT}");
        sql.SET("END_TIME = #{record.endTime,jdbcType=BIGINT}");
        sql.SET("CALENDAR_NAME = #{record.calendarName,jdbcType=VARCHAR}");
        sql.SET("MISFIRE_INSTR = #{record.misfireInstr,jdbcType=SMALLINT}");
        sql.SET("JOB_DATA = #{record.jobData,jdbcType=BLOB}");
        
        QrtzTriggersCriteria example = (QrtzTriggersCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_TRIGGERS");
        
        sql.SET("SCHED_NAME = #{record.schedName,jdbcType=VARCHAR}");
        sql.SET("TRIGGER_NAME = #{record.triggerName,jdbcType=VARCHAR}");
        sql.SET("TRIGGER_GROUP = #{record.triggerGroup,jdbcType=VARCHAR}");
        sql.SET("JOB_NAME = #{record.jobName,jdbcType=VARCHAR}");
        sql.SET("JOB_GROUP = #{record.jobGroup,jdbcType=VARCHAR}");
        sql.SET("DESCRIPTION = #{record.description,jdbcType=VARCHAR}");
        sql.SET("NEXT_FIRE_TIME = #{record.nextFireTime,jdbcType=BIGINT}");
        sql.SET("PREV_FIRE_TIME = #{record.prevFireTime,jdbcType=BIGINT}");
        sql.SET("PRIORITY = #{record.priority,jdbcType=INTEGER}");
        sql.SET("TRIGGER_STATE = #{record.triggerState,jdbcType=VARCHAR}");
        sql.SET("TRIGGER_TYPE = #{record.triggerType,jdbcType=VARCHAR}");
        sql.SET("START_TIME = #{record.startTime,jdbcType=BIGINT}");
        sql.SET("END_TIME = #{record.endTime,jdbcType=BIGINT}");
        sql.SET("CALENDAR_NAME = #{record.calendarName,jdbcType=VARCHAR}");
        sql.SET("MISFIRE_INSTR = #{record.misfireInstr,jdbcType=SMALLINT}");
        
        QrtzTriggersCriteria example = (QrtzTriggersCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByPrimaryKeySelective(QrtzTriggers record) {
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_TRIGGERS");
        
        if (record.getJobName() != null) {
            sql.SET("JOB_NAME = #{jobName,jdbcType=VARCHAR}");
        }
        
        if (record.getJobGroup() != null) {
            sql.SET("JOB_GROUP = #{jobGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getDescription() != null) {
            sql.SET("DESCRIPTION = #{description,jdbcType=VARCHAR}");
        }
        
        if (record.getNextFireTime() != null) {
            sql.SET("NEXT_FIRE_TIME = #{nextFireTime,jdbcType=BIGINT}");
        }
        
        if (record.getPrevFireTime() != null) {
            sql.SET("PREV_FIRE_TIME = #{prevFireTime,jdbcType=BIGINT}");
        }
        
        if (record.getPriority() != null) {
            sql.SET("PRIORITY = #{priority,jdbcType=INTEGER}");
        }
        
        if (record.getTriggerState() != null) {
            sql.SET("TRIGGER_STATE = #{triggerState,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerType() != null) {
            sql.SET("TRIGGER_TYPE = #{triggerType,jdbcType=VARCHAR}");
        }
        
        if (record.getStartTime() != null) {
            sql.SET("START_TIME = #{startTime,jdbcType=BIGINT}");
        }
        
        if (record.getEndTime() != null) {
            sql.SET("END_TIME = #{endTime,jdbcType=BIGINT}");
        }
        
        if (record.getCalendarName() != null) {
            sql.SET("CALENDAR_NAME = #{calendarName,jdbcType=VARCHAR}");
        }
        
        if (record.getMisfireInstr() != null) {
            sql.SET("MISFIRE_INSTR = #{misfireInstr,jdbcType=SMALLINT}");
        }
        
        if (record.getJobData() != null) {
            sql.SET("JOB_DATA = #{jobData,jdbcType=BLOB}");
        }
        
        sql.WHERE("SCHED_NAME = #{schedName,jdbcType=VARCHAR}");
        sql.WHERE("TRIGGER_NAME = #{triggerName,jdbcType=VARCHAR}");
        sql.WHERE("TRIGGER_GROUP = #{triggerGroup,jdbcType=VARCHAR}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    protected void applyWhere(SQL sql, QrtzTriggersCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}