package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Recepta;
import pl.topteam.dps.model.main.ReceptaCriteria;

public abstract interface ReceptaMapper {
    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=ReceptaSqlProvider.class, method="countByExample")
    int countByExample(ReceptaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @DeleteProvider(type=ReceptaSqlProvider.class, method="deleteByExample")
    int deleteByExample(ReceptaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Delete({
        "delete from RECEPTA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Insert({
        "insert into RECEPTA (EWIDENCJA_DPS_ID, LEKARZ_WYSTAWIL_ID, ",
        "CHOROBY_PRZEWLEKLE, DATA_WYSTAWIENIA, ",
        "ODDZIAL_NFZ, UPRAWNIENIE)",
        "values (#{ewidencjaDpsId,jdbcType=BIGINT}, #{lekarzWystawilId,jdbcType=BIGINT}, ",
        "#{chorobyPrzewlekle,jdbcType=VARCHAR}, #{dataWystawienia,jdbcType=DATE}, ",
        "#{oddzialNfz,jdbcType=VARCHAR}, #{uprawnienie,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Recepta record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    int mergeInto(Recepta record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @InsertProvider(type=ReceptaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Recepta record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=ReceptaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="EWIDENCJA_DPS_ID", property="ewidencjaDpsId", jdbcType=JdbcType.BIGINT),
        @Result(column="LEKARZ_WYSTAWIL_ID", property="lekarzWystawilId", jdbcType=JdbcType.BIGINT),
        @Result(column="CHOROBY_PRZEWLEKLE", property="chorobyPrzewlekle", jdbcType=JdbcType.VARCHAR),
        @Result(column="DATA_WYSTAWIENIA", property="dataWystawienia", jdbcType=JdbcType.DATE),
        @Result(column="ODDZIAL_NFZ", property="oddzialNfz", jdbcType=JdbcType.VARCHAR),
        @Result(column="UPRAWNIENIE", property="uprawnienie", jdbcType=JdbcType.VARCHAR)
    })
    List<Recepta> selectByExampleWithRowbounds(ReceptaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=ReceptaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="EWIDENCJA_DPS_ID", property="ewidencjaDpsId", jdbcType=JdbcType.BIGINT),
        @Result(column="LEKARZ_WYSTAWIL_ID", property="lekarzWystawilId", jdbcType=JdbcType.BIGINT),
        @Result(column="CHOROBY_PRZEWLEKLE", property="chorobyPrzewlekle", jdbcType=JdbcType.VARCHAR),
        @Result(column="DATA_WYSTAWIENIA", property="dataWystawienia", jdbcType=JdbcType.DATE),
        @Result(column="ODDZIAL_NFZ", property="oddzialNfz", jdbcType=JdbcType.VARCHAR),
        @Result(column="UPRAWNIENIE", property="uprawnienie", jdbcType=JdbcType.VARCHAR)
    })
    List<Recepta> selectByExample(ReceptaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Select({
        "select",
        "ID, EWIDENCJA_DPS_ID, LEKARZ_WYSTAWIL_ID, CHOROBY_PRZEWLEKLE, DATA_WYSTAWIENIA, ",
        "ODDZIAL_NFZ, UPRAWNIENIE",
        "from RECEPTA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="EWIDENCJA_DPS_ID", property="ewidencjaDpsId", jdbcType=JdbcType.BIGINT),
        @Result(column="LEKARZ_WYSTAWIL_ID", property="lekarzWystawilId", jdbcType=JdbcType.BIGINT),
        @Result(column="CHOROBY_PRZEWLEKLE", property="chorobyPrzewlekle", jdbcType=JdbcType.VARCHAR),
        @Result(column="DATA_WYSTAWIENIA", property="dataWystawienia", jdbcType=JdbcType.DATE),
        @Result(column="ODDZIAL_NFZ", property="oddzialNfz", jdbcType=JdbcType.VARCHAR),
        @Result(column="UPRAWNIENIE", property="uprawnienie", jdbcType=JdbcType.VARCHAR)
    })
    Recepta selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=ReceptaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Recepta record, @Param("example") ReceptaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=ReceptaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Recepta record, @Param("example") ReceptaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=ReceptaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Recepta record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Update({
        "update RECEPTA",
        "set EWIDENCJA_DPS_ID = #{ewidencjaDpsId,jdbcType=BIGINT},",
          "LEKARZ_WYSTAWIL_ID = #{lekarzWystawilId,jdbcType=BIGINT},",
          "CHOROBY_PRZEWLEKLE = #{chorobyPrzewlekle,jdbcType=VARCHAR},",
          "DATA_WYSTAWIENIA = #{dataWystawienia,jdbcType=DATE},",
          "ODDZIAL_NFZ = #{oddzialNfz,jdbcType=VARCHAR},",
          "UPRAWNIENIE = #{uprawnienie,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Recepta record);
}