package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.Slowo;
import pl.topteam.dps.model.main_gen.SlowoCriteria.Criteria;
import pl.topteam.dps.model.main_gen.SlowoCriteria.Criterion;
import pl.topteam.dps.model.main.SlowoCriteria;

public class SlowoSqlProvider {

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String countByExample(SlowoCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("SLOWO");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String deleteByExample(SlowoCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("SLOWO");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String insertSelective(Slowo record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("SLOWO");
        
        if (record.getSlownikId() != null) {
            sql.VALUES("SLOWNIK_ID", "#{slownikId,jdbcType=BIGINT}");
        }
        
        if (record.getKod() != null) {
            sql.VALUES("KOD", "#{kod,jdbcType=VARCHAR}");
        }
        
        if (record.getWartString() != null) {
            sql.VALUES("WART_STRING", "#{wartString,jdbcType=VARCHAR}");
        }
        
        if (record.getWartInt() != null) {
            sql.VALUES("WART_INT", "#{wartInt,jdbcType=INTEGER}");
        }
        
        if (record.getWaznoscOd() != null) {
            sql.VALUES("WAZNOSC_OD", "#{waznoscOd,jdbcType=DATE}");
        }
        
        if (record.getWaznoscDo() != null) {
            sql.VALUES("WAZNOSC_DO", "#{waznoscDo,jdbcType=DATE}");
        }
        
        if (record.getKolejnosc() != null) {
            sql.VALUES("KOLEJNOSC", "#{kolejnosc,jdbcType=INTEGER}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String selectByExample(SlowoCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("SLOWNIK_ID");
        sql.SELECT("KOD");
        sql.SELECT("WART_STRING");
        sql.SELECT("WART_INT");
        sql.SELECT("WAZNOSC_OD");
        sql.SELECT("WAZNOSC_DO");
        sql.SELECT("KOLEJNOSC");
        sql.FROM("SLOWO");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        Slowo record = (Slowo) parameter.get("record");
        SlowoCriteria example = (SlowoCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("SLOWO");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getSlownikId() != null) {
            sql.SET("SLOWNIK_ID = #{record.slownikId,jdbcType=BIGINT}");
        }
        
        if (record.getKod() != null) {
            sql.SET("KOD = #{record.kod,jdbcType=VARCHAR}");
        }
        
        if (record.getWartString() != null) {
            sql.SET("WART_STRING = #{record.wartString,jdbcType=VARCHAR}");
        }
        
        if (record.getWartInt() != null) {
            sql.SET("WART_INT = #{record.wartInt,jdbcType=INTEGER}");
        }
        
        if (record.getWaznoscOd() != null) {
            sql.SET("WAZNOSC_OD = #{record.waznoscOd,jdbcType=DATE}");
        }
        
        if (record.getWaznoscDo() != null) {
            sql.SET("WAZNOSC_DO = #{record.waznoscDo,jdbcType=DATE}");
        }
        
        if (record.getKolejnosc() != null) {
            sql.SET("KOLEJNOSC = #{record.kolejnosc,jdbcType=INTEGER}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("SLOWO");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("SLOWNIK_ID = #{record.slownikId,jdbcType=BIGINT}");
        sql.SET("KOD = #{record.kod,jdbcType=VARCHAR}");
        sql.SET("WART_STRING = #{record.wartString,jdbcType=VARCHAR}");
        sql.SET("WART_INT = #{record.wartInt,jdbcType=INTEGER}");
        sql.SET("WAZNOSC_OD = #{record.waznoscOd,jdbcType=DATE}");
        sql.SET("WAZNOSC_DO = #{record.waznoscDo,jdbcType=DATE}");
        sql.SET("KOLEJNOSC = #{record.kolejnosc,jdbcType=INTEGER}");
        
        SlowoCriteria example = (SlowoCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByPrimaryKeySelective(Slowo record) {
        SQL sql = new SQL();
        sql.UPDATE("SLOWO");
        
        if (record.getSlownikId() != null) {
            sql.SET("SLOWNIK_ID = #{slownikId,jdbcType=BIGINT}");
        }
        
        if (record.getKod() != null) {
            sql.SET("KOD = #{kod,jdbcType=VARCHAR}");
        }
        
        if (record.getWartString() != null) {
            sql.SET("WART_STRING = #{wartString,jdbcType=VARCHAR}");
        }
        
        if (record.getWartInt() != null) {
            sql.SET("WART_INT = #{wartInt,jdbcType=INTEGER}");
        }
        
        if (record.getWaznoscOd() != null) {
            sql.SET("WAZNOSC_OD = #{waznoscOd,jdbcType=DATE}");
        }
        
        if (record.getWaznoscDo() != null) {
            sql.SET("WAZNOSC_DO = #{waznoscDo,jdbcType=DATE}");
        }
        
        if (record.getKolejnosc() != null) {
            sql.SET("KOLEJNOSC = #{kolejnosc,jdbcType=INTEGER}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    protected void applyWhere(SQL sql, SlowoCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}