package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Sprawozdanie;
import pl.topteam.dps.model.main.SprawozdanieCriteria;

public abstract interface SprawozdanieMapper {
    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=SprawozdanieSqlProvider.class, method="countByExample")
    int countByExample(SprawozdanieCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @DeleteProvider(type=SprawozdanieSqlProvider.class, method="deleteByExample")
    int deleteByExample(SprawozdanieCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Delete({
        "delete from SPRAWOZDANIE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Insert({
        "insert into SPRAWOZDANIE (DATA_WYGENEROWANIA, KWARTAL, ",
        "NAZWA_PLIKU, NUMER, ",
        "TYP, ROK)",
        "values (#{dataWygenerowania,jdbcType=TIMESTAMP}, #{kwartal,jdbcType=INTEGER}, ",
        "#{nazwaPliku,jdbcType=VARCHAR}, #{numer,jdbcType=BIGINT}, ",
        "#{typ,jdbcType=VARCHAR}, #{rok,jdbcType=INTEGER})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Sprawozdanie record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    int mergeInto(Sprawozdanie record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @InsertProvider(type=SprawozdanieSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Sprawozdanie record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=SprawozdanieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA_WYGENEROWANIA", property="dataWygenerowania", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="KWARTAL", property="kwartal", jdbcType=JdbcType.INTEGER),
        @Result(column="NAZWA_PLIKU", property="nazwaPliku", jdbcType=JdbcType.VARCHAR),
        @Result(column="NUMER", property="numer", jdbcType=JdbcType.BIGINT),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR),
        @Result(column="ROK", property="rok", jdbcType=JdbcType.INTEGER)
    })
    List<Sprawozdanie> selectByExampleWithRowbounds(SprawozdanieCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=SprawozdanieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA_WYGENEROWANIA", property="dataWygenerowania", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="KWARTAL", property="kwartal", jdbcType=JdbcType.INTEGER),
        @Result(column="NAZWA_PLIKU", property="nazwaPliku", jdbcType=JdbcType.VARCHAR),
        @Result(column="NUMER", property="numer", jdbcType=JdbcType.BIGINT),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR),
        @Result(column="ROK", property="rok", jdbcType=JdbcType.INTEGER)
    })
    List<Sprawozdanie> selectByExample(SprawozdanieCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Select({
        "select",
        "ID, DATA_WYGENEROWANIA, KWARTAL, NAZWA_PLIKU, NUMER, TYP, ROK",
        "from SPRAWOZDANIE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA_WYGENEROWANIA", property="dataWygenerowania", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="KWARTAL", property="kwartal", jdbcType=JdbcType.INTEGER),
        @Result(column="NAZWA_PLIKU", property="nazwaPliku", jdbcType=JdbcType.VARCHAR),
        @Result(column="NUMER", property="numer", jdbcType=JdbcType.BIGINT),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR),
        @Result(column="ROK", property="rok", jdbcType=JdbcType.INTEGER)
    })
    Sprawozdanie selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=SprawozdanieSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Sprawozdanie record, @Param("example") SprawozdanieCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=SprawozdanieSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Sprawozdanie record, @Param("example") SprawozdanieCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=SprawozdanieSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Sprawozdanie record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Update({
        "update SPRAWOZDANIE",
        "set DATA_WYGENEROWANIA = #{dataWygenerowania,jdbcType=TIMESTAMP},",
          "KWARTAL = #{kwartal,jdbcType=INTEGER},",
          "NAZWA_PLIKU = #{nazwaPliku,jdbcType=VARCHAR},",
          "NUMER = #{numer,jdbcType=BIGINT},",
          "TYP = #{typ,jdbcType=VARCHAR},",
          "ROK = #{rok,jdbcType=INTEGER}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Sprawozdanie record);
}