package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.SwiadczenieGrupa;
import pl.topteam.dps.model.main.SwiadczenieGrupaCriteria;

public abstract interface SwiadczenieGrupaMapper {
    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=SwiadczenieGrupaSqlProvider.class, method="countByExample")
    int countByExample(SwiadczenieGrupaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @DeleteProvider(type=SwiadczenieGrupaSqlProvider.class, method="deleteByExample")
    int deleteByExample(SwiadczenieGrupaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Delete({
        "delete from SWIADCZENIE_GRUPA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Insert({
        "insert into SWIADCZENIE_GRUPA (KOLEJNOSC_WYDRUK, NAZWA)",
        "values (#{kolejnoscWydruk,jdbcType=INTEGER}, #{nazwa,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(SwiadczenieGrupa record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    int mergeInto(SwiadczenieGrupa record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @InsertProvider(type=SwiadczenieGrupaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(SwiadczenieGrupa record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=SwiadczenieGrupaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="KOLEJNOSC_WYDRUK", property="kolejnoscWydruk", jdbcType=JdbcType.INTEGER),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR)
    })
    List<SwiadczenieGrupa> selectByExampleWithRowbounds(SwiadczenieGrupaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=SwiadczenieGrupaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="KOLEJNOSC_WYDRUK", property="kolejnoscWydruk", jdbcType=JdbcType.INTEGER),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR)
    })
    List<SwiadczenieGrupa> selectByExample(SwiadczenieGrupaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Select({
        "select",
        "ID, KOLEJNOSC_WYDRUK, NAZWA",
        "from SWIADCZENIE_GRUPA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="KOLEJNOSC_WYDRUK", property="kolejnoscWydruk", jdbcType=JdbcType.INTEGER),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR)
    })
    SwiadczenieGrupa selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=SwiadczenieGrupaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") SwiadczenieGrupa record, @Param("example") SwiadczenieGrupaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=SwiadczenieGrupaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") SwiadczenieGrupa record, @Param("example") SwiadczenieGrupaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=SwiadczenieGrupaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(SwiadczenieGrupa record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Update({
        "update SWIADCZENIE_GRUPA",
        "set KOLEJNOSC_WYDRUK = #{kolejnoscWydruk,jdbcType=INTEGER},",
          "NAZWA = #{nazwa,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(SwiadczenieGrupa record);
}