package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.SwiadczenieRealizacja;
import pl.topteam.dps.model.main_gen.SwiadczenieRealizacjaCriteria.Criteria;
import pl.topteam.dps.model.main_gen.SwiadczenieRealizacjaCriteria.Criterion;
import pl.topteam.dps.model.main.SwiadczenieRealizacjaCriteria;

public class SwiadczenieRealizacjaSqlProvider {

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String countByExample(SwiadczenieRealizacjaCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("SWIADCZENIE_REALIZACJA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String deleteByExample(SwiadczenieRealizacjaCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("SWIADCZENIE_REALIZACJA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String insertSelective(SwiadczenieRealizacja record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("SWIADCZENIE_REALIZACJA");
        
        if (record.getSwiadczenieId() != null) {
            sql.VALUES("SWIADCZENIE_ID", "#{swiadczenieId,jdbcType=BIGINT}");
        }
        
        if (record.getData() != null) {
            sql.VALUES("DATA", "#{data,jdbcType=DATE}");
        }
        
        if (record.getMieszkaniecId() != null) {
            sql.VALUES("MIESZKANIEC_ID", "#{mieszkaniecId,jdbcType=BIGINT}");
        }
        
        if (record.getIlosc() != null) {
            sql.VALUES("ILOSC", "#{ilosc,jdbcType=DECIMAL}");
        }
        
        if (record.getIloscRezygnacja() != null) {
            sql.VALUES("ILOSC_REZYGNACJA", "#{iloscRezygnacja,jdbcType=DECIMAL}");
        }
        
        if (record.getIloscPelnoplatne() != null) {
            sql.VALUES("ILOSC_PELNOPLATNE", "#{iloscPelnoplatne,jdbcType=DECIMAL}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String selectByExample(SwiadczenieRealizacjaCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("SWIADCZENIE_ID");
        } else {
            sql.SELECT("SWIADCZENIE_ID");
        }
        sql.SELECT("DATA");
        sql.SELECT("MIESZKANIEC_ID");
        sql.SELECT("ILOSC");
        sql.SELECT("ILOSC_REZYGNACJA");
        sql.SELECT("ILOSC_PELNOPLATNE");
        sql.FROM("SWIADCZENIE_REALIZACJA");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        SwiadczenieRealizacja record = (SwiadczenieRealizacja) parameter.get("record");
        SwiadczenieRealizacjaCriteria example = (SwiadczenieRealizacjaCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("SWIADCZENIE_REALIZACJA");
        
        if (record.getSwiadczenieId() != null) {
            sql.SET("SWIADCZENIE_ID = #{record.swiadczenieId,jdbcType=BIGINT}");
        }
        
        if (record.getData() != null) {
            sql.SET("DATA = #{record.data,jdbcType=DATE}");
        }
        
        if (record.getMieszkaniecId() != null) {
            sql.SET("MIESZKANIEC_ID = #{record.mieszkaniecId,jdbcType=BIGINT}");
        }
        
        if (record.getIlosc() != null) {
            sql.SET("ILOSC = #{record.ilosc,jdbcType=DECIMAL}");
        }
        
        if (record.getIloscRezygnacja() != null) {
            sql.SET("ILOSC_REZYGNACJA = #{record.iloscRezygnacja,jdbcType=DECIMAL}");
        }
        
        if (record.getIloscPelnoplatne() != null) {
            sql.SET("ILOSC_PELNOPLATNE = #{record.iloscPelnoplatne,jdbcType=DECIMAL}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("SWIADCZENIE_REALIZACJA");
        
        sql.SET("SWIADCZENIE_ID = #{record.swiadczenieId,jdbcType=BIGINT}");
        sql.SET("DATA = #{record.data,jdbcType=DATE}");
        sql.SET("MIESZKANIEC_ID = #{record.mieszkaniecId,jdbcType=BIGINT}");
        sql.SET("ILOSC = #{record.ilosc,jdbcType=DECIMAL}");
        sql.SET("ILOSC_REZYGNACJA = #{record.iloscRezygnacja,jdbcType=DECIMAL}");
        sql.SET("ILOSC_PELNOPLATNE = #{record.iloscPelnoplatne,jdbcType=DECIMAL}");
        
        SwiadczenieRealizacjaCriteria example = (SwiadczenieRealizacjaCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    public String updateByPrimaryKeySelective(SwiadczenieRealizacja record) {
        SQL sql = new SQL();
        sql.UPDATE("SWIADCZENIE_REALIZACJA");
        
        if (record.getIlosc() != null) {
            sql.SET("ILOSC = #{ilosc,jdbcType=DECIMAL}");
        }
        
        if (record.getIloscRezygnacja() != null) {
            sql.SET("ILOSC_REZYGNACJA = #{iloscRezygnacja,jdbcType=DECIMAL}");
        }
        
        if (record.getIloscPelnoplatne() != null) {
            sql.SET("ILOSC_PELNOPLATNE = #{iloscPelnoplatne,jdbcType=DECIMAL}");
        }
        
        sql.WHERE("SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}");
        sql.WHERE("DATA = #{data,jdbcType=DATE}");
        sql.WHERE("MIESZKANIEC_ID = #{mieszkaniecId,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    protected void applyWhere(SQL sql, SwiadczenieRealizacjaCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}