package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.UmowaApteka;
import pl.topteam.dps.model.main.UmowaAptekaCriteria;

public abstract interface UmowaAptekaMapper {
    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=UmowaAptekaSqlProvider.class, method="countByExample")
    int countByExample(UmowaAptekaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @DeleteProvider(type=UmowaAptekaSqlProvider.class, method="deleteByExample")
    int deleteByExample(UmowaAptekaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Delete({
        "delete from UMOWA_APTEKA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Insert({
        "insert into UMOWA_APTEKA (DATA_OD, DATA_DO, ",
        "KWOTA, NR)",
        "values (#{dataOd,jdbcType=DATE}, #{dataDo,jdbcType=DATE}, ",
        "#{kwota,jdbcType=DECIMAL}, #{nr,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(UmowaApteka record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    int mergeInto(UmowaApteka record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @InsertProvider(type=UmowaAptekaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(UmowaApteka record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=UmowaAptekaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="NR", property="nr", jdbcType=JdbcType.VARCHAR)
    })
    List<UmowaApteka> selectByExampleWithRowbounds(UmowaAptekaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @SelectProvider(type=UmowaAptekaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="NR", property="nr", jdbcType=JdbcType.VARCHAR)
    })
    List<UmowaApteka> selectByExample(UmowaAptekaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Select({
        "select",
        "ID, DATA_OD, DATA_DO, KWOTA, NR",
        "from UMOWA_APTEKA",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA_OD", property="dataOd", jdbcType=JdbcType.DATE),
        @Result(column="DATA_DO", property="dataDo", jdbcType=JdbcType.DATE),
        @Result(column="KWOTA", property="kwota", jdbcType=JdbcType.DECIMAL),
        @Result(column="NR", property="nr", jdbcType=JdbcType.VARCHAR)
    })
    UmowaApteka selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=UmowaAptekaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") UmowaApteka record, @Param("example") UmowaAptekaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=UmowaAptekaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") UmowaApteka record, @Param("example") UmowaAptekaCriteria example);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @UpdateProvider(type=UmowaAptekaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(UmowaApteka record);

    /**
     * @mbggenerated 2014-03-13 16:02:38
     */
    @Update({
        "update UMOWA_APTEKA",
        "set DATA_OD = #{dataOd,jdbcType=DATE},",
          "DATA_DO = #{dataDo,jdbcType=DATE},",
          "KWOTA = #{kwota,jdbcType=DECIMAL},",
          "NR = #{nr,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(UmowaApteka record);
}